/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.editing.JSSmartEnterProcessor;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.TypeScriptImplementMembersHandler;
import com.intellij.lang.javascript.intentions.JSFileNameMismatchIntentionBase;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSCreateSubclassIntention
extends JavaScriptIntention {
    @NotNull
    @IntentionName
    private String myText = JavaScriptBundle.message((String)"js.create.derived.type.class", (Object[])new Object[0]);
    private boolean myIsImplement = false;
    private boolean myIsImplementClause = false;
    private String myName;

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSClass jsClass;
        if (project == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(1);
        }
        if ((jsClass = (JSClass)ObjectUtils.tryCast((Object)JSFileNameMismatchIntentionBase.findNamedElement(element), JSClass.class)) == null || jsClass instanceof TypeScriptEnum || jsClass instanceof TypeScriptTypeAlias || jsClass instanceof JSClassExpression || !DialectDetector.isJavaScriptFamily((PsiElement)jsClass)) {
            return false;
        }
        this.myName = jsClass.getName();
        if (this.myName == null) {
            return false;
        }
        if (jsClass.isInterface()) {
            this.myText = JavaScriptBundle.message((String)"js.create.derived.type.interface", (Object[])new Object[0]);
            this.myIsImplement = true;
            this.myIsImplementClause = true;
        } else {
            this.myIsImplementClause = false;
            if (JSRefactoringUtil.isAbstract((PsiElement)jsClass, (JSAttributeListOwner)jsClass)) {
                this.myText = JavaScriptBundle.message((String)"js.create.derived.type.abstract.class", (Object[])new Object[0]);
                this.myIsImplement = true;
            } else {
                this.myText = JavaScriptBundle.message((String)"js.create.derived.type.class", (Object[])new Object[0]);
                this.myIsImplement = false;
            }
        }
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.create.derived.type.family", (Object[])new Object[0]);
        if (string == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TypeScriptTypeParameterList list;
        if (project == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(5);
        }
        JSClass jsClass = (JSClass)JSFileNameMismatchIntentionBase.findNamedElement(element);
        assert (jsClass != null);
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{jsClass.getContainingFile().getVirtualFile()})) {
            return;
        }
        Ref createdClassRef = Ref.create(null);
        StringBuilder baseTypeString = new StringBuilder(this.myIsImplementClause ? "implements " : "extends ").append(this.myName);
        LinkedHashSet<String> genericArgs = null;
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (list = ((TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList()) != null && list.getTypeParameters().length > 0) {
            genericArgs = new LinkedHashSet<String>();
            baseTypeString.append("<");
            TypeScriptTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String name = parameters[i].getName();
                baseTypeString.append(name);
                genericArgs.add(name);
                if (i == parameters.length - 1) continue;
                baseTypeString.append(", ");
            }
            baseTypeString.append(">");
        }
        String newName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)(this.myName + JSNameSuggestionsUtil.getImplSuffix((Project)project)), (PsiElement)jsClass.getParent(), (Collection)ContainerUtil.emptyList(), (boolean)false);
        ApplicationManager.getApplication().runWriteAction(() -> {
            JSClass statement = JSPsiElementFactory.createJSClass((String)("class " + newName + " " + String.valueOf(baseTypeString) + "{}"), (PsiElement)jsClass);
            PsiElement parent = jsClass.getParent();
            JSSmartEnterProcessor.fixClassLikeBraces((Editor)editor, (PsiElement)jsClass);
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement after = parent.addAfter((PsiElement)statement, (PsiElement)jsClass);
            assert (after instanceof JSClass);
            createdClassRef.set((Object)((JSClass)after));
            JSCreateSubclassIntention.moveCaretToClassName(project, after);
        });
        JSClass createdClass = (JSClass)createdClassRef.get();
        if (createdClass != null && this.myIsImplement) {
            TypeScriptImplementMembersHandler handler = new TypeScriptImplementMembersHandler(false, BaseJSGenerateHandler.ElementsToSelect.All, false);
            handler.invoke(project, editor, createdClass.getContainingFile());
        }
        if (createdClass != null) {
            if (genericArgs != null) {
                final String createdNamed = createdClass.getName();
                if (createdNamed == null) {
                    return;
                }
                boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
                TemplateManager templateManager = TemplateManager.getInstance((Project)project);
                JSCreateSubclassIntention.replaceGenericsWithTemplateVariables(createdClass, genericArgs);
                ApplicationManager.getApplication().runWriteAction(() -> FormatFixer.create((PsiElement)createdClass, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat());
                TemplateImpl template = new TemplateImpl("", createdClass.getText(), "");
                for (String genericName : genericArgs) {
                    template.addVariable(genericName, (Expression)(isUnitTest ? new ConstantNode("SUBST_" + genericName) : new MacroCallNode((Macro)new CompleteMacro())), true);
                }
                template.setToReformat(true);
                final PsiElement parent = createdClass.getParent();
                ApplicationManager.getApplication().runWriteAction(() -> createdClass.delete());
                templateManager.startTemplate(editor, (Template)template, (TemplateEditingListener)new TemplateEditingAdapter(this){

                    public void templateFinished(@NotNull Template template, boolean brokenOff) {
                        if (template == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Collection classes = PsiTreeUtil.findChildrenOfType((PsiElement)parent, JSClass.class);
                        for (JSClass clazz : classes) {
                            if (!createdNamed.equals(clazz.getName())) continue;
                            JSCreateSubclassIntention.moveCaretToClassName(project, (PsiElement)clazz);
                            JSCreateSubclassIntention.renameCreatedClass(editor, clazz);
                            break;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/lang/javascript/intentions/JSCreateSubclassIntention$1", "templateFinished"));
                    }
                });
            } else {
                JSCreateSubclassIntention.moveCaretToClassName(project, (PsiElement)createdClass);
                JSCreateSubclassIntention.renameCreatedClass(editor, createdClass);
            }
        }
    }

    private static void renameCreatedClass(Editor editor, JSClass createdClass) {
        JSRefactoringUtil.suggestSameFileRename((PsiFile)createdClass.getContainingFile(), (Editor)editor, (PsiNameIdentifierOwner)createdClass, (String)createdClass.getName());
    }

    private static void replaceGenericsWithTemplateVariables(@NotNull JSClass createdClass, @NotNull LinkedHashSet<String> finalGenericArgs) {
        if (createdClass == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(6);
        }
        if (finalGenericArgs == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            Collection types = PsiTreeUtil.findChildrenOfType((PsiElement)createdClass, TypeScriptSingleType.class);
            for (TypeScriptSingleType singleType : types) {
                String typeName = singleType.getQualifiedTypeName();
                if (typeName == null || !finalGenericArgs.contains(typeName)) continue;
                TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)singleType, TypeScriptTypeParameterListOwner.class, (boolean)true);
                boolean conflict = false;
                while (owner != null && owner != createdClass) {
                    TypeScriptTypeParameterList list = owner.getTypeParameterList();
                    if (list != null && Arrays.stream(list.getTypeParameters()).anyMatch(p -> typeName.equals(p.getName()))) {
                        conflict = true;
                        break;
                    }
                    owner = (TypeScriptTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, TypeScriptTypeParameterListOwner.class, (boolean)true);
                }
                if (conflict) continue;
                singleType.replace((PsiElement)JSPsiElementFactory.createTypeScriptType((String)("$" + typeName + "$"), (PsiElement)singleType.getParent()));
            }
        });
    }

    private static void moveCaretToClassName(@NotNull Project project, PsiElement after) {
        if (project == null) {
            JSCreateSubclassIntention.$$$reportNull$$$0(8);
        }
        PsiElement nameIdentifier = ((JSClass)after).getNameIdentifier();
        assert (nameIdentifier != null);
        Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, after.getContainingFile().getVirtualFile(), nameIdentifier.getTextOffset());
        descriptor.navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCreateSubclassIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalGenericArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCreateSubclassIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceGenericsWithTemplateVariables";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToClassName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

