/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSFieldInplaceIntroducer
extends JSBaseInplaceIntroducer<BaseIntroduceSettings> {
    private final Runnable myCallback;
    private final String myExprText;
    private final int myExprIndex;
    private final List<JSAttributeList.AccessType> TS_VISIBILITIES = Arrays.asList(JSAttributeList.AccessType.PRIVATE, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PUBLIC);
    private final String myExprTypeText;
    private JSAttributeList.AccessType myAccessType;
    private final boolean myHadOwnConstructor;
    private final Ref<SmartPsiElementPointer<JSAssignmentExpression>> myInsertedExtra;
    private final Collection<JSIntroduceFieldSettings.InitializationPlace> myAllPlaces;
    private JSIntroduceFieldSettings.InitializationPlace myInitializationPlace;
    private boolean myIsMakeReadonly;
    private static final int BALLOON_INDENT = 5;
    private static final String SILLY_FIELD_PLACEHOLDER = "this.q";

    public JSFieldInplaceIntroducer(Project project, Editor editor, JSExpression[] occurrences, JSBaseIntroduceHandler<? extends JSElement, BaseIntroduceSettings, ? extends JSBaseIntroduceDialog> introduceHandler, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Runnable callback, Ref<SmartPsiElementPointer<JSAssignmentExpression>> insertedExtra) {
        super(project, editor, (JSExpression)context.expressionDescriptor.first, occurrences, ((JSExpression)context.expressionDescriptor.first).getContainingFile().getFileType(), introduceHandler, context);
        this.myInsertedExtra = insertedExtra;
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)context.scope);
        this.myHadOwnConstructor = jsClass != null && jsClass.getConstructor() != null;
        this.myCallback = callback;
        this.myExprText = ((JSExpression)this.myExpr).getText();
        this.myExprIndex = JSFieldInplaceIntroducer.getIndex(occurrences, (JSExpression)this.myExpr);
        this.myAccessType = ((JSIntroduceFieldSettings)context.settings).getAccessType();
        this.myInitializationPlace = ((JSIntroduceFieldSettings)context.settings).getInitializationPlace();
        this.myAllPlaces = ((JSIntroduceFieldSettings)context.settings).getAllPlaces();
        this.myIsMakeReadonly = ((JSIntroduceFieldSettings)context.settings).isMakeReadonly();
        this.myExprTypeText = JSIntroducedExpressionUtil.willReplacePartOfExpression(context.expressionDescriptor) ? null : JSFieldInplaceIntroducer.getFieldType((JSExpression)this.myExpr);
    }

    @Nullable
    public static String getFieldType(JSExpression expr) {
        JSType type = DialectDetector.hasFeature((PsiElement)expr, (JSLanguageFeature)JSLanguageFeature.TYPES) ? JSResolveUtil.getExpressionJSType((JSExpression)expr) : null;
        return type == null || JSTypeUtils.isAnyType((JSType)type) ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    private static int getIndex(JSExpression @Unmodifiable [] occurrences, JSExpression expression) {
        ArrayList<JSExpression> expressions = new ArrayList<JSExpression>(Arrays.asList(occurrences));
        expressions.sort(Comparator.comparing(e -> e.getTextOffset()));
        return expressions.indexOf(expression);
    }

    protected void adjustBalloon(BalloonBuilder builder) {
        builder.setShowCallout(false);
    }

    protected void showBalloonInEditor() {
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        Dimension size = this.myBalloon.getPreferredSize();
        int em = EditorUtil.charWidth((char)'m', (int)0, (Editor)this.myEditor);
        this.myBalloon.show(new RelativePoint((Component)this.myEditor.getContentComponent(), new Point(CodeStyle.getSettings((Editor)this.myEditor).RIGHT_MARGIN * em - size.width / 2 + 5, area.y + size.height / 2 - 5)), Balloon.Position.atRight);
    }

    @Override
    protected JSIntroduceFieldSettings getInplaceIntroduceSettings(final String name) {
        return new JSIntroduceFieldSettings(){

            @Override
            public JSIntroduceFieldSettings.InitializationPlace getInitializationPlace() {
                return JSFieldInplaceIntroducer.this.myInitializationPlace;
            }

            @Override
            public Collection<JSIntroduceFieldSettings.InitializationPlace> getAllPlaces() {
                return JSFieldInplaceIntroducer.this.myAllPlaces;
            }

            @Override
            public JSAttributeList.AccessType getAccessType() {
                return JSFieldInplaceIntroducer.this.myAccessType;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return JSFieldInplaceIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return JSFieldInplaceIntroducer.this.myExprTypeText;
            }

            @Override
            public boolean isMakeReadonly() {
                return JSFieldInplaceIntroducer.this.myIsMakeReadonly;
            }
        };
    }

    protected JComponent getComponent() {
        Collection<JSIntroduceFieldSettings.InitializationPlace> places = this.myAllPlaces;
        if (places.size() == 1 && !DialectDetector.isTypeScript((PsiElement)this.myExpr)) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(null);
        String text = JavaScriptBundle.message((String)"javascript.introduce.field.make.readonly", (Object[])new Object[0]);
        StateRestoringCheckBox readonlyBox = new StateRestoringCheckBox(text);
        readonlyBox.setMnemonic(JSFieldInplaceIntroducer.extractMnemonic(text, 'r'));
        if (this.myInitializationPlace == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            readonlyBox.setSelected(false);
            readonlyBox.makeUnselectable(false);
            if (places.size() == 1) {
                readonlyBox.setVisible(false);
            }
        }
        int rowCount = (places.size() > 1 ? 1 : 0) + (DialectDetector.isTypeScript((PsiElement)this.myExpr) ? 2 : 0);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout((LayoutManager)new GridLayoutManager(rowCount, 2));
        int row = 0;
        if (places.size() > 1) {
            String initializeInMessage = JavaScriptBundle.message((String)"javascript.introduce.field.initialize.in.scope", (Object[])new Object[0]);
            this.createMultiOptionDropdown(places, tablePanel, initializeInMessage, JSFieldInplaceIntroducer.extractMnemonic(initializeInMessage, 'i'), () -> this.myInitializationPlace, p -> p.getDescription(), place -> {
                boolean isCurrent;
                this.myInitializationPlace = place;
                boolean bl = isCurrent = place == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod;
                if (isCurrent) {
                    this.myIsMakeReadonly = false;
                }
                if (isCurrent) {
                    readonlyBox.makeUnselectable(false);
                } else {
                    readonlyBox.makeSelectable();
                }
                JSIntroduceFieldHandler.setLastInitPlace(this.myProject, place);
            }, row++);
        }
        if (DialectDetector.isTypeScript((PsiElement)this.myExpr)) {
            String visibilityMessage = JavaScriptBundle.message((String)"javascript.introduce.field.visibility", (Object[])new Object[0]);
            this.createMultiOptionDropdown(this.TS_VISIBILITIES, tablePanel, visibilityMessage, JSFieldInplaceIntroducer.extractMnemonic(visibilityMessage, 'v'), () -> this.myAccessType, t -> Objects.requireNonNull(JSVisibilityUtil.PresentableAccessModifier.ofAccessType((JSAttributeList.AccessType)t, (PsiElement)this.myExpr)).getText(), m -> {
                this.myAccessType = m;
                JSIntroduceFieldHandler.setLastModifier(this.myProject, m);
            }, row++);
            tablePanel.add((Component)readonlyBox, JSFieldInplaceIntroducer.createConstraints(row, 0, 2, true, 8));
            readonlyBox.setSelected(this.myIsMakeReadonly);
            readonlyBox.setFocusable(false);
            readonlyBox.addItemListener(i -> {
                boolean selected = readonlyBox.isSelected();
                if (this.myIsMakeReadonly != selected) {
                    this.myIsMakeReadonly = selected;
                    JSIntroduceFieldHandler.setLastIsReadonly(this.myProject, selected);
                    this.restartInplaceIntroduceTemplate();
                }
            });
        }
        panel.add(tablePanel);
        JBLabel hint = new JBLabel(JavaScriptBundle.message((String)"javascript.introduce.field.keyboard.hint", (Object[])new Object[]{KeymapUtil.getKeyText((int)18)}), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        hint.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        panel.add((Component)hint);
        MnemonicHelper.init((Component)panel);
        return panel;
    }

    private static char extractMnemonic(@NotNull String message, char fallback) {
        int indexOf;
        if (message == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return (indexOf = message.indexOf(38)) >= 0 ? Character.toLowerCase(message.charAt(indexOf)) : fallback;
    }

    private <T> void createMultiOptionDropdown(@NotNull Collection<? extends T> places, @NotNull JPanel panel, @NlsContexts.Label @NotNull String labelText, char mnemonic, @NotNull Supplier<? extends T> valueToCheckAgainstSupplier, @NotNull Function<? super T, @NlsContexts.ListItem String> getDescription, @NotNull Consumer<? super T> update, int row) {
        if (places == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (panel == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(2);
        }
        if (labelText == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(3);
        }
        if (valueToCheckAgainstSupplier == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(4);
        }
        if (getDescription == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(5);
        }
        if (update == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(6);
        }
        ComboBox box = new ComboBox();
        ArrayList orderedPlaces = new ArrayList(places);
        for (int i = 0; i < orderedPlaces.size(); ++i) {
            Object place = orderedPlaces.get(i);
            box.addItem((Object)getDescription.apply(place));
            if (place != valueToCheckAgainstSupplier.get()) continue;
            box.setSelectedIndex(i);
        }
        JLabel label = new JLabel(labelText);
        label.setDisplayedMnemonic(mnemonic);
        label.setLabelFor((Component)box);
        panel.add((Component)label, JSFieldInplaceIntroducer.createConstraints(row, 0, 1, false, 1));
        panel.add((Component)box, JSFieldInplaceIntroducer.createConstraints(row, 1, 1, true, 1));
        KeyboardComboSwitcher.setupActions((JComboBox)box, (Project)this.myProject);
        box.addActionListener(e -> {
            int index = box.getSelectedIndex();
            if (index >= 0) {
                Object place = orderedPlaces.get(index);
                if (valueToCheckAgainstSupplier.get() != place) {
                    update.accept((Object)place);
                    this.restartInplaceIntroduceTemplate();
                }
            }
        });
    }

    private static GridConstraints createConstraints(int row, int col, int colspan, boolean wantGrow, int anchor) {
        int policy = wantGrow ? 5 : 0;
        return new GridConstraints(row, col, 1, colspan, anchor, 3, policy, 5, null, null, null);
    }

    protected void updateTitle(@Nullable JSVariable variable, String value) {
        if (variable == null) {
            return;
        }
        String prefix = JSFieldInplaceIntroducer.getPrefix(variable);
        String variableText = variable.getText();
        PsiElement identifier = variable.getNameIdentifier();
        if (identifier != null) {
            int startOffsetInParent = identifier.getStartOffsetInParent();
            this.setPreviewText(prefix + variableText.substring(0, startOffsetInParent) + value + variableText.substring(startOffsetInParent + identifier.getTextLength()));
        } else {
            this.setPreviewText(prefix + variableText.replaceFirst(variable.getName(), value));
        }
        this.revalidate();
    }

    @NotNull
    private static String getPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(7);
        }
        if ((statement = variable.getStatement()) == null) {
            return "";
        }
        JSAttributeList list = statement.getAttributeList();
        Object object = list == null ? "" : list.getText() + " ";
        if (object == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(8);
        }
        return object;
    }

    protected void updateTitle(@Nullable JSVariable variable) {
        if (variable == null) {
            return;
        }
        this.setPreviewText(JSFieldInplaceIntroducer.getPrefix(variable) + variable.getText());
        this.revalidate();
    }

    protected void performPostIntroduceTasks() {
        super.performPostIntroduceTasks();
        this.myCallback.run();
    }

    @Nullable
    public JSExpression getExpr() {
        if (this.myInitializationPlace == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod && this.myIsIntroduceFromExpressionStatement) {
            return null;
        }
        return (JSExpression)super.getExpr();
    }

    protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
        PsiElement nameIdentifier;
        JSVariable localVariable;
        SmartPsiElementPointer pointer;
        JSAssignmentExpression element;
        if (stringUsages == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(9);
        }
        if (this.isReplaceAllOccurrences()) {
            for (JSExpression expression : (JSExpression[])this.getOccurrences()) {
                PsiUtilCore.ensureValid((PsiElement)expression);
                boolean isOurExpression = expression == this.myExpr;
                Ref expressionRef = Ref.create((Object)expression);
                ApplicationManager.getApplication().runWriteAction(() -> expressionRef.set((Object)((JSExpression)JSElementImpl.replaceInParent((PsiElement)((PsiElement)expressionRef.get()), (PsiElement)JSPsiElementFactory.createJSExpression((String)SILLY_FIELD_PLACEHOLDER, (PsiElement)((PsiElement)expressionRef.get()))))));
                expression = (JSExpression)expressionRef.get();
                if (isOurExpression) {
                    this.moveAfterThis();
                }
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression, (Object)JSFieldInplaceIntroducer.getRangeWithoutQualifier(expression)));
            }
        } else if (this.getExpr() != null) {
            this.correctExpression();
            JSExpression expr = this.getExpr();
            PsiUtilCore.ensureValid((PsiElement)expr);
            this.moveAfterThis();
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expr, (Object)JSFieldInplaceIntroducer.getRangeWithoutQualifier(expr)));
        }
        JSAssignmentExpression jSAssignmentExpression = element = (pointer = (SmartPsiElementPointer)this.myInsertedExtra.get()) == null ? null : (JSAssignmentExpression)pointer.getElement();
        if (element != null) {
            JSExpression jsExpression;
            JSDefinitionExpression expression = element.getDefinitionExpression();
            JSExpression jSExpression = jsExpression = expression == null ? null : expression.getExpression();
            if (jsExpression != null) {
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)jsExpression, (Object)JSFieldInplaceIntroducer.getRangeWithoutQualifier(jsExpression)));
                if (this.myIsIntroduceFromExpressionStatement) {
                    this.myEditor.getCaretModel().moveToOffset(jsExpression.getTextRange().getEndOffset());
                }
            }
        }
        if ((localVariable = (JSVariable)this.getLocalVariable()) != null && (nameIdentifier = localVariable.getNameIdentifier()) != null) {
            int length = nameIdentifier.getTextLength();
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)nameIdentifier, (Object)new TextRange(0, length)));
        }
    }

    private void moveAfterThis() {
        this.myEditor.getCaretModel().moveToOffset(this.myEditor.getCaretModel().getOffset() + SILLY_FIELD_PLACEHOLDER.length());
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(10);
        }
        if (element instanceof JSReferenceExpression) {
            return JSFieldInplaceIntroducer.getRangeWithoutQualifier((JSExpression)element);
        }
        TextRange textRange = super.getRangeToRename(element);
        if (textRange == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    protected void deleteTemplateField(JSVariable psiField) {
        JSVarStatement statement;
        JSFunction constructor;
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myEditor.getDocument());
        ArrayList<JSExpression> occurrences = new ArrayList<JSExpression>(((JSExpression[])this.myOccurrences).length);
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)psiField, JSClass.class);
        if (jsClass == null) {
            super.deleteTemplateField((PsiNameIdentifierOwner)psiField);
            return;
        }
        ReferencesSearch.search((PsiElement)psiField, (SearchScope)new LocalSearchScope((PsiElement)jsClass)).asIterable().forEach(r -> {
            if (r instanceof JSReferenceExpression) {
                PsiElement parent = ((JSReferenceExpression)r).getParent();
                Computable computable = null;
                if (parent instanceof JSDefinitionExpression) {
                    if (this.myIsIntroduceFromExpressionStatement && parent.getParent().getParent() instanceof JSExpressionStatement) {
                        computable = () -> {
                            JSExpressionStatement grandParent = (JSExpressionStatement)parent.getParent().getParent();
                            return Objects.requireNonNull(grandParent.getExpression()).replace(JSPsiElementFactory.createJSExpression((String)this.myExprText, (PsiElement)((PsiElement)r)));
                        };
                    } else {
                        JSFieldInplaceIntroducer.deleteAndFixWs(parent.getParent().getParent());
                    }
                } else {
                    computable = () -> ((JSReferenceExpression)r).replace(JSPsiElementFactory.createJSExpression((String)this.myExprText, (PsiElement)((PsiElement)r)));
                }
                if (computable != null) {
                    JSExpression replaced = (JSExpression)WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Computable)computable);
                    occurrences.add(replaced);
                }
            }
        });
        occurrences.sort(Comparator.comparing(e -> e.getTextOffset()));
        this.myOccurrences = (PsiElement[])ContainerUtil.toArray(occurrences, JSExpression[]::new);
        this.myExpr = (PsiElement)occurrences.get(this.myExprIndex < occurrences.size() ? this.myExprIndex : 0);
        if (!this.myHadOwnConstructor && (constructor = jsClass.getConstructor()) != null) {
            JSFieldInplaceIntroducer.deleteAndFixWs((PsiElement)constructor);
        }
        if ((statement = psiField.getStatement()) != null) {
            JSFieldInplaceIntroducer.deleteAndFixWs((PsiElement)statement);
        } else {
            psiField.delete();
        }
        this.restoreRangesForSubexpression();
    }

    @Override
    protected void moveOffsetAfterVariable() {
    }

    private static void deleteAndFixWs(@NotNull PsiElement statement) {
        if (statement == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(12);
        }
        Project project = statement.getProject();
        PsiElement sibling = statement.getPrevSibling();
        PsiElement nextSibling = statement.getNextSibling();
        PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
        statement.delete();
        if (sibling instanceof PsiWhiteSpace && nextSibling instanceof PsiWhiteSpace) {
            PsiElement prevSibling;
            if (sibling.isValid() && nextSibling.isValid() && sibling.getNextSibling() == nextSibling) {
                nextSibling.delete();
            } else if (nextElement != null && (prevSibling = nextElement.getPrevSibling()) instanceof PsiWhiteSpace) {
                Object text = prevSibling.getText();
                text = "\n" + StringUtil.trimLeading((String)text, (char)'\n');
                prevSibling.replace(PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText((String)text));
            }
        }
    }

    protected int adjustHighlightsStartOffset(int offset) {
        return offset + "this.".length();
    }

    @NotNull
    private static TextRange getRangeWithoutQualifier(@NotNull JSExpression expression) {
        if (expression == null) {
            JSFieldInplaceIntroducer.$$$reportNull$$$0(13);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return new TextRange(0, expression.getTextLength());
        }
        JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
        if (qualifier == null) {
            return new TextRange(0, expression.getTextLength());
        }
        return new TextRange(qualifier.getTextLength() + (((JSReferenceExpression)expression).getReferenceKind() == JSReferenceExpression.Kind.ElvisAccess ? 2 : 1), expression.getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueToCheckAgainstSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getDescription";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceField/JSFieldInplaceIntroducer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceField/JSFieldInplaceIntroducer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractMnemonic";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMultiOptionDropdown";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteAndFixWs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRangeWithoutQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11 -> new IllegalStateException(string);
        };
    }
}

