/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public final class JSClassNamingConventionInspection
extends ConventionInspection {
    @Override
    protected String getDefaultRegex() {
        return "[A-Z][a-zA-Z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        boolean isClass = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), (Class[])new Class[]{JSClass.class, JSFunction.class}) instanceof JSClass;
        String name = ((PsiElement)args[0]).getText();
        assert (name != null);
        if (name.length() < this.getMinLength()) {
            String string = JavaScriptBundle.message((String)(isClass ? "class.name.is.too.short.error.string" : "constructor.name.is.too.short.error.string"), (Object[])new Object[]{name});
            if (string == null) {
                JSClassNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (name.length() > this.getMaxLength()) {
            String string = JavaScriptBundle.message((String)(isClass ? "class.name.is.too.long.error.string" : "constructor.name.is.too.long.error.string"), (Object[])new Object[]{name});
            if (string == null) {
                JSClassNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JavaScriptBundle.message((String)(isClass ? "class.name.doesnt.match.regex.error.string" : "constructor.name.doesnt.match.regex.error.string"), (Object[])new Object[]{name, this.getRegex()});
        if (string == null) {
            JSClassNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/JSClassNamingConventionInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            JSDocComment docComment;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function);
            if (JSClassNamingConventionInspection.this.isInvalidName((PsiNameIdentifierOwner)function) && (docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)function)) != null && docComment.isClassExplicitly()) {
                this.registerFunctionError(function);
            }
        }

        public void visitJSClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSClass(aClass);
            if (JSClassNamingConventionInspection.this.isInvalidName((PsiNameIdentifierOwner)aClass)) {
                this.registerError(aClass.getNameIdentifier());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/naming/JSClassNamingConventionInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

