/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.blame.helpers;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.blame.helpers.AbstractLocalHistoryProcessor;
import com.intellij.code.provenance.core.blame.helpers.LocalHistoryResult;
import com.intellij.code.provenance.core.events.detector.VcsKindDetectorEP;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/intellij/code/provenance/core/blame/helpers/LocalHistoryChangeProcessor;", "Lcom/intellij/code/provenance/core/blame/helpers/AbstractLocalHistoryProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "currentContent", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/CharSequence;Lcom/intellij/openapi/vfs/VirtualFile;)V", "newContent", "newTimestamp", "", "totalContentLength", "", "localHistoryTooBig", "", "getLocalHistoryTooBig", "()Z", "localHistoryEvents", "", "Lcom/intellij/code/provenance/core/blame/helpers/LocalHistoryResult;", "getLocalHistoryEvents", "()Ljava/util/List;", "processMatchingChange", "", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "change", "Lcom/intellij/history/core/changes/Change;", "changePath", "", "addEvent", "element", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nLocalHistoryChangeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalHistoryChangeProcessor.kt\ncom/intellij/code/provenance/core/blame/helpers/LocalHistoryChangeProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class LocalHistoryChangeProcessor
extends AbstractLocalHistoryProcessor {
    @NotNull
    private final VirtualFile vFile;
    @Nullable
    private CharSequence newContent;
    private long newTimestamp;
    private int totalContentLength;
    @NotNull
    private final List<LocalHistoryResult> localHistoryEvents;

    public LocalHistoryChangeProcessor(@NotNull Project project, @Nullable CharSequence currentContent, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        String string = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        super(string);
        this.vFile = vFile;
        this.newContent = currentContent;
        this.newTimestamp = System.currentTimeMillis();
        this.localHistoryEvents = new ArrayList();
    }

    public final boolean getLocalHistoryTooBig() {
        return UtilsKt.isTooBigContent(this.totalContentLength);
    }

    @NotNull
    public final List<LocalHistoryResult> getLocalHistoryEvents() {
        return this.localHistoryEvents;
    }

    @Override
    protected void processMatchingChange(@NotNull ChangeSet changeSet, @NotNull Change change, @NotNull String changePath) {
        block5: {
            Change change2;
            DocumentChangesKind vcsKind;
            block4: {
                Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                Intrinsics.checkNotNullParameter((Object)changePath, (String)"changePath");
                if (this.getLocalHistoryTooBig()) {
                    return;
                }
                vcsKind = VcsKindDetectorEP.Companion.detectKind(changeSet);
                change2 = change;
                if (!(change2 instanceof CreateFileChange)) break block4;
                CharSequence charSequence = this.newContent;
                if (charSequence == null) break block5;
                CharSequence it = charSequence;
                boolean bl = false;
                this.addEvent(new LocalHistoryResult(changePath, this.newTimestamp, vcsKind, "", UtilsKt.getEmptyHash(), UtilsKt.contentHash(it)));
                break block5;
            }
            if (!(change2 instanceof ContentChange)) break block5;
            CharSequence charSequence = UtilsKt.decodeOldContent((ContentChange)change, this.vFile);
            if (charSequence != null) {
                Long l;
                CharSequence oldContent = charSequence;
                boolean bl = false;
                long oldContentHash = UtilsKt.contentHash(oldContent);
                CharSequence charSequence2 = this.newContent;
                if (charSequence2 != null) {
                    CharSequence it = charSequence2;
                    boolean bl2 = false;
                    l = UtilsKt.contentHash(it);
                } else {
                    l = null;
                }
                Long newContentHash = l;
                this.addEvent(new LocalHistoryResult(changePath, this.newTimestamp, vcsKind, oldContent, oldContentHash, newContentHash));
                this.newContent = oldContent;
                this.newTimestamp = ((ContentChange)change).getOldTimestamp();
            }
        }
    }

    private final boolean addEvent(LocalHistoryResult element) {
        this.totalContentLength += element.getOldContent().length();
        return this.localHistoryEvents.add(element);
    }
}

