import React from 'react';
import { ERROR_TEXT } from '../../constants';
var renderErrors = function (errors) {
    if (!errors) {
        return null;
    }
    return errors
        .map(function (singleError, index) {
        var _a, _b, _c, _d, _e;
        if (!(singleError === null || singleError === void 0 ? void 0 : singleError.title)) {
            return null;
        }
        return (React.createElement("div", { key: index, className: "flex gap-2" },
            ((_b = (_a = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _a === void 0 ? void 0 : _a.startLine) !== null && _b !== void 0 ? _b : (_c = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _c === void 0 ? void 0 : _c.startOffset) && (React.createElement("span", null, "line ".concat(((_d = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _d === void 0 ? void 0 : _d.startLine) + ((_e = singleError === null || singleError === void 0 ? void 0 : singleError.location) === null || _e === void 0 ? void 0 : _e.startOffset), ":"))),
            React.createElement("code", { className: "whitespace-pre-wrap break-all ml-2" }, singleError.title)));
    })
        .filter(Boolean);
};
export var Error = function (_a) {
    var error = _a.error;
    if (!error) {
        return null;
    }
    var title = error.title, validationErrors = error.validationErrors;
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center p-8" },
            React.createElement("section", { className: "shadow rounded bg-gray-200 border-red-500 border-l-8" },
                React.createElement("h2", { className: "p-2" }, title ? "".concat(ERROR_TEXT, ": ").concat(title) : ERROR_TEXT),
                (validationErrors === null || validationErrors === void 0 ? void 0 : validationErrors.length) ? (React.createElement("div", { className: "bg-gray-800 text-white text-xs p-2" },
                    React.createElement("pre", null, renderErrors(validationErrors)))) : null)),
        React.createElement("div", { className: "panel-item--right" })));
};
//# sourceMappingURL=Error.js.map