/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.format.ComponentFormatter;
import org.assertj.swing.format.IntrospectionComponentFormatter;
import org.assertj.swing.format.JComboBoxFormatter;
import org.assertj.swing.format.JFileChooserFormatter;
import org.assertj.swing.format.JListFormatter;
import org.assertj.swing.format.JOptionPaneFormatter;
import org.assertj.swing.format.JTabbedPaneFormatter;
import org.assertj.swing.format.JTableFormatter;
import org.assertj.swing.format.JTreeFormatter;
import org.assertj.swing.util.Maps;

public class Formatting {
    private static final String MAXIMUM = "maximum";
    private static final String MINIMUM = "minimum";
    private static final String NULL_COMPONENT_MESSAGE = "Null Component";
    private static final String ENABLED = "enabled";
    private static final String NAME = "name";
    private static final String SHOWING = "showing";
    private static final String TEXT = "text";
    private static final String TITLE = "title";
    private static final String VALUE = "value";
    private static final String VISIBLE = "visible";
    private static final ConcurrentMap<Class<?>, ComponentFormatter> FORMATTERS = Maps.newConcurrentHashMap();
    private static Logger logger = Logger.getLogger(Formatting.class.getCanonicalName());

    @Nonnull
    private static ComponentFormatter instrospect(@Nonnull Class<? extends Component> targetType, String ... propertyNames) {
        return new IntrospectionComponentFormatter(targetType, propertyNames);
    }

    @Nonnull
    private static ComponentFormatter empty(@Nonnull Class<? extends Component> targetType) {
        return new IntrospectionComponentFormatter(targetType, new String[0]);
    }

    @Nonnull
    private static ComponentFormatter nameOnly(@Nonnull Class<? extends Component> targetType) {
        return new IntrospectionComponentFormatter(targetType, NAME);
    }

    public static void register(@Nonnull ComponentFormatter formatter) {
        Class<? extends Component> key = formatter.targetType();
        ComponentFormatter previous = FORMATTERS.put(key, formatter);
        if (previous != null) {
            String format = "Replaced formatter %s with %s for type %s";
            logger.info(String.format(format, previous.toString(), formatter.toString(), key.getName()));
        }
    }

    @VisibleForTesting
    static ComponentFormatter formatter(@Nonnull Class<?> type) {
        return (ComponentFormatter)FORMATTERS.get(type);
    }

    @Nonnull
    @RunsInEDT
    public static String inEdtFormat(@Nonnull Component c) {
        return (String)Preconditions.checkNotNull((Object)GuiActionRunner.execute(() -> Formatting.format(c)));
    }

    @Nonnull
    @RunsInCurrentThread
    public static String format(@Nullable Component c) {
        if (c == null) {
            return NULL_COMPONENT_MESSAGE;
        }
        ComponentFormatter formatter = Formatting.formatterFor(c.getClass());
        if (formatter != null) {
            return formatter.format(c);
        }
        String name = c.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            return c.toString();
        }
        return String.format("%s[name=%s]", c.getClass().getName(), name);
    }

    @Nullable
    private static ComponentFormatter formatterFor(@Nonnull Class<?> type) {
        ComponentFormatter formatter = (ComponentFormatter)FORMATTERS.get(type);
        if (formatter != null) {
            return formatter;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            return Formatting.formatterFor(superType);
        }
        return null;
    }

    private Formatting() {
    }

    static {
        Formatting.register(Formatting.instrospect(AbstractButton.class, NAME, TEXT, "selected", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Dialog.class, NAME, TITLE, ENABLED, "modal", VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Frame.class, NAME, TITLE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JComboBoxFormatter());
        Formatting.register(Formatting.instrospect(JButton.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JFileChooserFormatter());
        Formatting.register(Formatting.instrospect(JLabel.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JLayeredPane.class));
        Formatting.register(new JListFormatter());
        Formatting.register(Formatting.empty(JMenuBar.class));
        Formatting.register(new JOptionPaneFormatter());
        Formatting.register(Formatting.nameOnly(JPanel.class));
        Formatting.register(Formatting.instrospect(JPopupMenu.class, NAME, "label", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JProgressBar.class, NAME, VALUE, MINIMUM, MAXIMUM, "string", "stringPainted", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JRootPane.class));
        Formatting.register(Formatting.instrospect(JScrollBar.class, NAME, VALUE, "blockIncrement", MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JScrollPane.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSlider.class, NAME, VALUE, MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSpinner.class, NAME, VALUE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTabbedPaneFormatter());
        Formatting.register(new JTableFormatter());
        Formatting.register(Formatting.nameOnly(JToolBar.class));
        Formatting.register(Formatting.instrospect(JPasswordField.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JTextComponent.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTreeFormatter());
    }
}

