/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesCustomResource;
import com.intellij.kubernetes.api.KubernetesCustomResourceList;
import com.intellij.kubernetes.api.KubernetesEntityKt;
import com.intellij.kubernetes.view.mappers.KubernetesClusterRoleMapper;
import com.intellij.kubernetes.view.mappers.KubernetesConfigMapMapper;
import com.intellij.kubernetes.view.mappers.KubernetesCronJobMapper;
import com.intellij.kubernetes.view.mappers.KubernetesCustomResourceDefinitionMapper;
import com.intellij.kubernetes.view.mappers.KubernetesDaemonSetMapper;
import com.intellij.kubernetes.view.mappers.KubernetesDeploymentMapper;
import com.intellij.kubernetes.view.mappers.KubernetesEventMapper;
import com.intellij.kubernetes.view.mappers.KubernetesIngressMapper;
import com.intellij.kubernetes.view.mappers.KubernetesJobMapper;
import com.intellij.kubernetes.view.mappers.KubernetesNamespaceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesNodeMapper;
import com.intellij.kubernetes.view.mappers.KubernetesPersistentVolumeClaimMapper;
import com.intellij.kubernetes.view.mappers.KubernetesPersistentVolumeMapper;
import com.intellij.kubernetes.view.mappers.KubernetesPodMapper;
import com.intellij.kubernetes.view.mappers.KubernetesReplicaSetMapper;
import com.intellij.kubernetes.view.mappers.KubernetesReplicationControllerMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesRoleMapper;
import com.intellij.kubernetes.view.mappers.KubernetesSecretMapper;
import com.intellij.kubernetes.view.mappers.KubernetesServiceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesStatefulSetMapper;
import com.intellij.kubernetes.view.mappers.KubernetesStorageClassMapper;
import com.intellij.kubernetes.view.nodes.network.KubernetesEndpointsMapper;
import com.intellij.kubernetes.view.nodes.network.KubernetesNetworkPoliceMapper;
import com.intellij.openapi.util.text.Strings;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleList;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1CronJobList;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinition;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionList;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionSpec;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersion;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1DaemonSetList;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobList;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NamespaceList;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1NetworkPolicyList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicaSetList;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerList;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.openapi.models.V1StorageClass;
import io.kubernetes.client.openapi.models.V1StorageClassList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0002./B\u0089\u0001\b\u0002\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u0012\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u000b\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u0012\u000b\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u0012\u0011\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0'2\u000b\u0010(\u001a\u00070\u0007\u00a2\u0006\u0002\b\nJ\u0014\u0010)\u001a\u00020\u00142\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0096\u0082\u0004J\n\u0010+\u001a\u00020,H\u0096\u0080\u0004J\n\u0010-\u001a\u00020\u0007H\u0096\u0080\u0004R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0016\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0016\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u001c\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010$R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00060"}, d2={"Lcom/intellij/kubernetes/api/KubernetesEntity;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "", "kind", "", "Lorg/jetbrains/annotations/NonNls;", "displayableKind", "Lcom/intellij/openapi/util/NlsSafe;", "resource", "type", "Lkotlin/reflect/KClass;", "displayableKinds", "resources", "listType", "apiPathSegments", "", "isNamespaced", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/util/List;ZLjavax/swing/Icon;)V", "getKind", "()Ljava/lang/String;", "getDisplayableKind", "getResource", "getType", "()Lkotlin/reflect/KClass;", "getDisplayableKinds", "getResources", "getListType", "getApiPathSegments", "()Ljava/util/List;", "()Z", "getIcon", "()Ljavax/swing/Icon;", "Lkotlin/sequences/Sequence;", "namespace", "equals", "other", "hashCode", "", "toString", "Serializer", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity\n+ 2 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity$Companion\n*L\n1#1,353:1\n335#2,16:354\n327#2,24:370\n327#2,24:394\n335#2,16:418\n327#2,24:434\n327#2,24:458\n327#2,24:482\n327#2,24:506\n327#2,24:530\n327#2,24:554\n327#2,24:578\n327#2,24:602\n327#2,24:626\n327#2,24:650\n327#2,24:674\n327#2,24:698\n327#2,24:722\n327#2,24:746\n327#2,24:770\n327#2,24:794\n327#2,24:818\n327#2,24:842\n335#2,16:866\n*S KotlinDebug\n*F\n+ 1 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity\n*L\n102#1:354,16\n112#1:370,24\n120#1:394,24\n129#1:418,16\n139#1:434,24\n148#1:458,24\n157#1:482,24\n165#1:506,24\n174#1:530,24\n183#1:554,24\n192#1:578,24\n200#1:602,24\n209#1:626,24\n218#1:650,24\n227#1:674,24\n235#1:698,24\n243#1:722,24\n251#1:746,24\n260#1:770,24\n269#1:794,24\n277#1:818,24\n285#1:842,24\n294#1:866,16\n*E\n"})
public final class KubernetesEntity<T extends KubernetesObject, L extends KubernetesListObject> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String kind;
    @NotNull
    private final String displayableKind;
    @NotNull
    private final String resource;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final String displayableKinds;
    @NotNull
    private final String resources;
    @NotNull
    private final KClass<L> listType;
    @NotNull
    private final List<String> apiPathSegments;
    private final boolean isNamespaced;
    @NotNull
    private final Icon icon;
    @NotNull
    private static final Map<String, KubernetesEntity<?, ?>> entities;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ClusterRole, V1ClusterRoleList> ClusterRole;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ConfigMap, V1ConfigMapList> ConfigMap;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1CronJob, V1CronJobList> CronJob;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1CustomResourceDefinition, V1CustomResourceDefinitionList> CustomResourceDefinition;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1DaemonSet, V1DaemonSetList> DaemonSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Deployment, V1DeploymentList> Deployment;
    @JvmField
    @NotNull
    public static final KubernetesEntity<CoreV1Event, CoreV1EventList> Event;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Namespace, V1NamespaceList> Namespace;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Ingress, V1IngressList> Ingress;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1NetworkPolicy, V1NetworkPolicyList> NetworkPolice;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Endpoints, V1EndpointsList> Endpoints;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Job, V1JobList> Job;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Node, V1NodeList> Node;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1PersistentVolume, V1PersistentVolumeList> PersistentVolume;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1PersistentVolumeClaim, V1PersistentVolumeClaimList> PersistentVolumeClaim;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Pod, V1PodList> Pod;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ReplicationController, V1ReplicationControllerList> ReplicationController;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ReplicaSet, V1ReplicaSetList> ReplicaSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Role, V1RoleList> Role;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Secret, V1SecretList> Secrets;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Service, V1ServiceList> Service;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1StatefulSet, V1StatefulSetList> StatefulSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1StorageClass, V1StorageClassList> StorageClass;

    private KubernetesEntity(String kind, String displayableKind, String resource, KClass<T> type, String displayableKinds, String resources2, KClass<L> listType, List<String> apiPathSegments, boolean isNamespaced, Icon icon) {
        this.kind = kind;
        this.displayableKind = displayableKind;
        this.resource = resource;
        this.type = type;
        this.displayableKinds = displayableKinds;
        this.resources = resources2;
        this.listType = listType;
        this.apiPathSegments = apiPathSegments;
        this.isNamespaced = isNamespaced;
        this.icon = icon;
        entities.put(this.kind, this);
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final String getDisplayableKind() {
        return this.displayableKind;
    }

    @NotNull
    public final String getResource() {
        return this.resource;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    @NotNull
    public final String getDisplayableKinds() {
        return this.displayableKinds;
    }

    @NotNull
    public final String getResources() {
        return this.resources;
    }

    @NotNull
    public final KClass<L> getListType() {
        return this.listType;
    }

    @NotNull
    public final List<String> getApiPathSegments() {
        return this.apiPathSegments;
    }

    public final boolean isNamespaced() {
        return this.isNamespaced;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Sequence<String> apiPathSegments(@NotNull String namespace) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)this.apiPathSegments);
        if (this.isNamespaced && !Intrinsics.areEqual((Object)namespace, (Object)"Kubernetes.All.Namespaces.Label")) {
            Object[] objectArray = new String[]{"namespaces", namespace};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence2, (Sequence)sequence), (Object)this.resources);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.kubernetes.api.KubernetesEntity<*, *>");
        KubernetesEntity cfr_ignored_0 = (KubernetesEntity)object2;
        return Intrinsics.areEqual((Object)this.kind, (Object)((KubernetesEntity)other).kind) && Intrinsics.areEqual(this.type, ((KubernetesEntity)other).type) && Intrinsics.areEqual((Object)this.resource, (Object)((KubernetesEntity)other).resource) && this.isNamespaced == ((KubernetesEntity)other).isNamespaced;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.kind, this.type, this.resource, this.isNamespaced};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("KubernetesEntity(kind='" + this.kind + "',\n    | displayableKind='" + this.displayableKind + "', \n    | resource='" + this.resource + "', \n    | type=" + this.type + ", \n    | displayableKinds='" + this.displayableKinds + "', \n    | resources='" + this.resources + "', \n    | listType=" + this.listType + ", \n    | isNamespaced=" + this.isNamespaced + ")"), null, (int)1, null);
    }

    private static final KubernetesResourceMapper ClusterRole$lambda$0() {
        return KubernetesClusterRoleMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper ConfigMap$lambda$0() {
        return KubernetesConfigMapMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper CronJob$lambda$0() {
        return KubernetesCronJobMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper CustomResourceDefinition$lambda$0() {
        return KubernetesCustomResourceDefinitionMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper DaemonSet$lambda$0() {
        return KubernetesDaemonSetMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Deployment$lambda$0() {
        return KubernetesDeploymentMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Event$lambda$0() {
        return KubernetesEventMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Namespace$lambda$0() {
        return KubernetesNamespaceMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Ingress$lambda$0() {
        return KubernetesIngressMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper NetworkPolice$lambda$0() {
        return KubernetesNetworkPoliceMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Endpoints$lambda$0() {
        return KubernetesEndpointsMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Job$lambda$0() {
        return KubernetesJobMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Node$lambda$0() {
        return KubernetesNodeMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper PersistentVolume$lambda$0() {
        return KubernetesPersistentVolumeMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper PersistentVolumeClaim$lambda$0() {
        return KubernetesPersistentVolumeClaimMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Pod$lambda$0() {
        return KubernetesPodMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper ReplicationController$lambda$0() {
        return KubernetesReplicationControllerMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper ReplicaSet$lambda$0() {
        return KubernetesReplicaSetMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Role$lambda$0() {
        return KubernetesRoleMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Secrets$lambda$0() {
        return KubernetesSecretMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper Service$lambda$0() {
        return KubernetesServiceMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper StatefulSet$lambda$0() {
        return KubernetesStatefulSetMapper.INSTANCE;
    }

    private static final KubernetesResourceMapper StorageClass$lambda$0() {
        return KubernetesStorageClassMapper.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> createCustomResource(@NotNull V1CustomResourceDefinition definition, boolean isNamespaced) {
        return Companion.createCustomResource(definition, isNamespaced);
    }

    public /* synthetic */ KubernetesEntity(String kind, String displayableKind, String resource, KClass type, String displayableKinds, String resources2, KClass listType, List apiPathSegments, boolean isNamespaced, Icon icon, DefaultConstructorMarker $constructor_marker) {
        this(kind, displayableKind, resource, type, displayableKinds, resources2, listType, apiPathSegments, isNamespaced, icon);
    }

    static {
        Function0 lazyMapper$iv;
        Icon icon$iv;
        boolean isNamespaced$iv;
        Object apiPathSegments$iv;
        String displayableKinds$iv;
        String displayableKind$iv;
        Companion = new Companion(null);
        entities = new LinkedHashMap();
        Companion companion = Companion;
        String string = "Cluster Role";
        String string2 = "Cluster Roles";
        List list2 = KubernetesEntityKt.access$getApisRbacAuthV1Segments$p();
        boolean bl = false;
        Function0 function0 = KubernetesEntity::ClusterRole$lambda$0;
        Icon icon = KubernetesIcons.ClusterRole;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ClusterRole");
        boolean $i$f$createStandard = false;
        String kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string3 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        KClass kClass = Reflection.getOrCreateKotlinClass(V1ClusterRole.class);
        String string4 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        KubernetesEntity entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string3, kClass, displayableKinds$iv, string4, Reflection.getOrCreateKotlinClass(V1ClusterRoleList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ClusterRole = entity$iv;
        Companion this_$iv = Companion;
        displayableKind$iv = "Config Map";
        displayableKinds$iv = "Config Maps";
        lazyMapper$iv = KubernetesEntity::ConfigMap$lambda$0;
        icon$iv = KubernetesIcons.ConfigMap;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"ConfigMap");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string5 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(V1ConfigMap.class);
        String string6 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string5, kClass2, displayableKinds$iv, string6, Reflection.getOrCreateKotlinClass(V1ConfigMapList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ConfigMap = entity$iv;
        Companion $this$iv = Companion;
        displayableKind$iv = "Cron Job";
        displayableKinds$iv = "Cron Jobs";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisBatchIOPathSegments$p();
        lazyMapper$iv = KubernetesEntity::CronJob$lambda$0;
        icon$iv = KubernetesIcons.CronJobs;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"CronJobs");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string7 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        KClass kClass3 = Reflection.getOrCreateKotlinClass(V1CronJob.class);
        String string8 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string7, kClass3, displayableKinds$iv, string8, Reflection.getOrCreateKotlinClass(V1CronJobList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        CronJob = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Custom Resource Definition";
        displayableKinds$iv = "Custom Resource Definitions";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisExtensionsIOPathSegments$p();
        isNamespaced$iv = false;
        lazyMapper$iv = KubernetesEntity::CustomResourceDefinition$lambda$0;
        icon$iv = KubernetesIcons.CustomResourceDefinition;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"CustomResourceDefinition");
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string9 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        KClass kClass4 = Reflection.getOrCreateKotlinClass(V1CustomResourceDefinition.class);
        String string10 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string9, kClass4, displayableKinds$iv, string10, Reflection.getOrCreateKotlinClass(V1CustomResourceDefinitionList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        CustomResourceDefinition = entity$iv;
        this_$iv = Companion;
        displayableKind$iv = "Daemon Set";
        displayableKinds$iv = "Daemon Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = KubernetesEntity::DaemonSet$lambda$0;
        icon$iv = KubernetesIcons.DaemonSet;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"DaemonSet");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string11 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toLowerCase(...)");
        KClass kClass5 = Reflection.getOrCreateKotlinClass(V1DaemonSet.class);
        String string12 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string11, kClass5, displayableKinds$iv, string12, Reflection.getOrCreateKotlinClass(V1DaemonSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        DaemonSet = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Deployment";
        displayableKinds$iv = "Deployments";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = KubernetesEntity::Deployment$lambda$0;
        icon$iv = KubernetesIcons.Deployment;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Deployment");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string13 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toLowerCase(...)");
        KClass kClass6 = Reflection.getOrCreateKotlinClass(V1Deployment.class);
        String string14 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string13, kClass6, displayableKinds$iv, string14, Reflection.getOrCreateKotlinClass(V1DeploymentList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Deployment = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Event";
        displayableKinds$iv = "Events";
        lazyMapper$iv = KubernetesEntity::Event$lambda$0;
        icon$iv = KubernetesIcons.Events;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Events");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string15 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toLowerCase(...)");
        KClass kClass7 = Reflection.getOrCreateKotlinClass(CoreV1Event.class);
        String string16 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string15, kClass7, displayableKinds$iv, string16, Reflection.getOrCreateKotlinClass(CoreV1EventList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Event = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Namespace";
        displayableKinds$iv = "Namespaces";
        isNamespaced$iv = false;
        lazyMapper$iv = KubernetesEntity::Namespace$lambda$0;
        icon$iv = KubernetesIcons.Namespace;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Namespace");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string17 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toLowerCase(...)");
        KClass kClass8 = Reflection.getOrCreateKotlinClass(V1Namespace.class);
        String string18 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string17, kClass8, displayableKinds$iv, string18, Reflection.getOrCreateKotlinClass(V1NamespaceList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Namespace = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Ingress";
        displayableKinds$iv = "Ingresses";
        apiPathSegments$iv = new String[]{"apis", "networking.k8s.io", "v1"};
        apiPathSegments$iv = CollectionsKt.listOf((Object[])apiPathSegments$iv);
        lazyMapper$iv = KubernetesEntity::Ingress$lambda$0;
        icon$iv = KubernetesIcons.Ingress;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Ingress");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string19 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"toLowerCase(...)");
        KClass kClass9 = Reflection.getOrCreateKotlinClass(V1Ingress.class);
        String string20 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string19, kClass9, displayableKinds$iv, string20, Reflection.getOrCreateKotlinClass(V1IngressList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Ingress = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "NetworkPolicy";
        displayableKinds$iv = "NetworkPolicies";
        apiPathSegments$iv = new String[]{"apis", "networking.k8s.io", "v1"};
        apiPathSegments$iv = CollectionsKt.listOf((Object[])apiPathSegments$iv);
        lazyMapper$iv = KubernetesEntity::NetworkPolice$lambda$0;
        icon$iv = KubernetesIcons.NetworkPolicy;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"NetworkPolicy");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string21 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"toLowerCase(...)");
        KClass kClass10 = Reflection.getOrCreateKotlinClass(V1NetworkPolicy.class);
        String string22 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string21, kClass10, displayableKinds$iv, string22, Reflection.getOrCreateKotlinClass(V1NetworkPolicyList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        NetworkPolice = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Endpoints";
        displayableKinds$iv = "Endpoints";
        lazyMapper$iv = KubernetesEntity::Endpoints$lambda$0;
        icon$iv = KubernetesIcons.Endpoints;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Endpoints");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string23 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"toLowerCase(...)");
        KClass kClass11 = Reflection.getOrCreateKotlinClass(V1Endpoints.class);
        String string24 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string23, kClass11, displayableKinds$iv, string24, Reflection.getOrCreateKotlinClass(V1EndpointsList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Endpoints = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Job";
        displayableKinds$iv = "Jobs";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisBatchIOPathSegments$p();
        lazyMapper$iv = KubernetesEntity::Job$lambda$0;
        icon$iv = KubernetesIcons.CronJobs;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"CronJobs");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string25 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"toLowerCase(...)");
        KClass kClass12 = Reflection.getOrCreateKotlinClass(V1Job.class);
        String string26 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string25, kClass12, displayableKinds$iv, string26, Reflection.getOrCreateKotlinClass(V1JobList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Job = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Node";
        displayableKinds$iv = "Nodes";
        isNamespaced$iv = false;
        lazyMapper$iv = KubernetesEntity::Node$lambda$0;
        icon$iv = KubernetesIcons.Node;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Node");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string27 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string27, (String)"toLowerCase(...)");
        KClass kClass13 = Reflection.getOrCreateKotlinClass(V1Node.class);
        String string28 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string28, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string27, kClass13, displayableKinds$iv, string28, Reflection.getOrCreateKotlinClass(V1NodeList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Node = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Persistent Volume";
        displayableKinds$iv = "Persistent Volumes";
        isNamespaced$iv = false;
        lazyMapper$iv = KubernetesEntity::PersistentVolume$lambda$0;
        icon$iv = KubernetesIcons.PersistentVolume;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"PersistentVolume");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string29 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"toLowerCase(...)");
        KClass kClass14 = Reflection.getOrCreateKotlinClass(V1PersistentVolume.class);
        String string30 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string29, kClass14, displayableKinds$iv, string30, Reflection.getOrCreateKotlinClass(V1PersistentVolumeList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        PersistentVolume = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Persistent Volume Claim";
        displayableKinds$iv = "Persistent Volume Claims";
        lazyMapper$iv = KubernetesEntity::PersistentVolumeClaim$lambda$0;
        icon$iv = KubernetesIcons.PersistentVolumeClaim;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"PersistentVolumeClaim");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string31 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"toLowerCase(...)");
        KClass kClass15 = Reflection.getOrCreateKotlinClass(V1PersistentVolumeClaim.class);
        String string32 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string31, kClass15, displayableKinds$iv, string32, Reflection.getOrCreateKotlinClass(V1PersistentVolumeClaimList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        PersistentVolumeClaim = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Pod";
        displayableKinds$iv = "Pods";
        lazyMapper$iv = KubernetesEntity::Pod$lambda$0;
        icon$iv = KubernetesIcons.Pod;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Pod");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string33 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string33, (String)"toLowerCase(...)");
        KClass kClass16 = Reflection.getOrCreateKotlinClass(V1Pod.class);
        String string34 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string33, kClass16, displayableKinds$iv, string34, Reflection.getOrCreateKotlinClass(V1PodList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Pod = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Replication Controller";
        displayableKinds$iv = "Replication Controllers";
        lazyMapper$iv = KubernetesEntity::ReplicationController$lambda$0;
        icon$iv = KubernetesIcons.ReplicaSets;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"ReplicaSets");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string35 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"toLowerCase(...)");
        KClass kClass17 = Reflection.getOrCreateKotlinClass(V1ReplicationController.class);
        String string36 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string35, kClass17, displayableKinds$iv, string36, Reflection.getOrCreateKotlinClass(V1ReplicationControllerList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ReplicationController = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Replica Set";
        displayableKinds$iv = "Replica Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = KubernetesEntity::ReplicaSet$lambda$0;
        icon$iv = KubernetesIcons.ReplicaSet;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"ReplicaSet");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string37 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string37, (String)"toLowerCase(...)");
        KClass kClass18 = Reflection.getOrCreateKotlinClass(V1ReplicaSet.class);
        String string38 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string38, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string37, kClass18, displayableKinds$iv, string38, Reflection.getOrCreateKotlinClass(V1ReplicaSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ReplicaSet = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Role";
        displayableKinds$iv = "Roles";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisRbacAuthV1Segments$p();
        lazyMapper$iv = KubernetesEntity::Role$lambda$0;
        icon$iv = KubernetesIcons.Role;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Role");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string39 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string39, (String)"toLowerCase(...)");
        KClass kClass19 = Reflection.getOrCreateKotlinClass(V1Role.class);
        String string40 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string40, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string39, kClass19, displayableKinds$iv, string40, Reflection.getOrCreateKotlinClass(V1RoleList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Role = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Secret";
        displayableKinds$iv = "Secrets";
        lazyMapper$iv = KubernetesEntity::Secrets$lambda$0;
        icon$iv = KubernetesIcons.PodSecurityPolicy;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"PodSecurityPolicy");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string41 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string41, (String)"toLowerCase(...)");
        KClass kClass20 = Reflection.getOrCreateKotlinClass(V1Secret.class);
        String string42 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string42, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string41, kClass20, displayableKinds$iv, string42, Reflection.getOrCreateKotlinClass(V1SecretList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Secrets = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Service";
        displayableKinds$iv = "Services";
        lazyMapper$iv = KubernetesEntity::Service$lambda$0;
        icon$iv = AllIcons.Graph.Layout;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"Layout");
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string43 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string43, (String)"toLowerCase(...)");
        KClass kClass21 = Reflection.getOrCreateKotlinClass(V1Service.class);
        String string44 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string44, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string43, kClass21, displayableKinds$iv, string44, Reflection.getOrCreateKotlinClass(V1ServiceList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Service = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Stateful Set";
        displayableKinds$iv = "Stateful Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = KubernetesEntity::StatefulSet$lambda$0;
        icon$iv = KubernetesIcons.StatefulSet;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"StatefulSet");
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string45 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string45, (String)"toLowerCase(...)");
        KClass kClass22 = Reflection.getOrCreateKotlinClass(V1StatefulSet.class);
        String string46 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string46, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string45, kClass22, displayableKinds$iv, string46, Reflection.getOrCreateKotlinClass(V1StatefulSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        StatefulSet = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Storage Class";
        displayableKinds$iv = "Storage Classes";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisStorageV1Segments$p();
        isNamespaced$iv = false;
        lazyMapper$iv = KubernetesEntity::StorageClass$lambda$0;
        icon$iv = KubernetesIcons.StorageClass;
        Intrinsics.checkNotNullExpressionValue((Object)icon$iv, (String)"StorageClass");
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string47 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string47, (String)"toLowerCase(...)");
        KClass kClass23 = Reflection.getOrCreateKotlinClass(V1StorageClass.class);
        String string48 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string48, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv, string47, kClass23, displayableKinds$iv, string48, Reflection.getOrCreateKotlinClass(V1StorageClassList.class), (List)apiPathSegments$iv, isNamespaced$iv, icon$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        StorageClass = entity$iv;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u000b\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007J$\u0010P\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020R0\b2\u0006\u0010S\u001a\u00020\u00152\u0006\u0010T\u001a\u00020UH\u0007J\u008a\u0001\u0010V\u001a\u000e\u0012\u0004\u0012\u0002HW\u0012\u0004\u0012\u0002HX0\b\"\n\b\u0002\u0010W\u0018\u0001*\u00020Y\"\n\b\u0003\u0010X\u0018\u0001*\u00020Z2\u000b\u0010[\u001a\u00070\u0006\u00a2\u0006\u0002\b\\2\u000b\u0010]\u001a\u00070\u0006\u00a2\u0006\u0002\b\\2\u0013\b\u0002\u0010^\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070_2\b\b\u0002\u0010T\u001a\u00020U2\u001a\b\b\u0010`\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HW\u0012\u0004\u0012\u0002HX0b0a2\u0006\u0010c\u001a\u00020dH\u0082\bJ@\u0010e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HW\u0012\u0004\u0012\u0002HX0\b0f\"\u0004\b\u0002\u0010W\"\u0004\b\u0003\u0010X2\f\u0010g\u001a\b\u0012\u0004\u0012\u0002HW0f2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002HX0fR'\u0010\u0004\u001a\u001b\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u0002040\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00105\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002070\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020@0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010A\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020F0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010J\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020L0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010M\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020O0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/intellij/kubernetes/api/KubernetesEntity$Companion;", "", "<init>", "()V", "entities", "", "", "Lorg/jetbrains/annotations/NonNls;", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "findByKind", "kind", "ClusterRole", "Lio/kubernetes/client/openapi/models/V1ClusterRole;", "Lio/kubernetes/client/openapi/models/V1ClusterRoleList;", "ConfigMap", "Lio/kubernetes/client/openapi/models/V1ConfigMap;", "Lio/kubernetes/client/openapi/models/V1ConfigMapList;", "CronJob", "Lio/kubernetes/client/openapi/models/V1CronJob;", "Lio/kubernetes/client/openapi/models/V1CronJobList;", "CustomResourceDefinition", "Lio/kubernetes/client/openapi/models/V1CustomResourceDefinition;", "Lio/kubernetes/client/openapi/models/V1CustomResourceDefinitionList;", "DaemonSet", "Lio/kubernetes/client/openapi/models/V1DaemonSet;", "Lio/kubernetes/client/openapi/models/V1DaemonSetList;", "Deployment", "Lio/kubernetes/client/openapi/models/V1Deployment;", "Lio/kubernetes/client/openapi/models/V1DeploymentList;", "Event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "Lio/kubernetes/client/openapi/models/CoreV1EventList;", "Namespace", "Lio/kubernetes/client/openapi/models/V1Namespace;", "Lio/kubernetes/client/openapi/models/V1NamespaceList;", "Ingress", "Lio/kubernetes/client/openapi/models/V1Ingress;", "Lio/kubernetes/client/openapi/models/V1IngressList;", "NetworkPolice", "Lio/kubernetes/client/openapi/models/V1NetworkPolicy;", "Lio/kubernetes/client/openapi/models/V1NetworkPolicyList;", "Endpoints", "Lio/kubernetes/client/openapi/models/V1Endpoints;", "Lio/kubernetes/client/openapi/models/V1EndpointsList;", "Job", "Lio/kubernetes/client/openapi/models/V1Job;", "Lio/kubernetes/client/openapi/models/V1JobList;", "Node", "Lio/kubernetes/client/openapi/models/V1Node;", "Lio/kubernetes/client/openapi/models/V1NodeList;", "PersistentVolume", "Lio/kubernetes/client/openapi/models/V1PersistentVolume;", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeList;", "PersistentVolumeClaim", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeClaim;", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeClaimList;", "Pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "Lio/kubernetes/client/openapi/models/V1PodList;", "ReplicationController", "Lio/kubernetes/client/openapi/models/V1ReplicationController;", "Lio/kubernetes/client/openapi/models/V1ReplicationControllerList;", "ReplicaSet", "Lio/kubernetes/client/openapi/models/V1ReplicaSet;", "Lio/kubernetes/client/openapi/models/V1ReplicaSetList;", "Role", "Lio/kubernetes/client/openapi/models/V1Role;", "Lio/kubernetes/client/openapi/models/V1RoleList;", "Secrets", "Lio/kubernetes/client/openapi/models/V1Secret;", "Lio/kubernetes/client/openapi/models/V1SecretList;", "Service", "Lio/kubernetes/client/openapi/models/V1Service;", "Lio/kubernetes/client/openapi/models/V1ServiceList;", "StatefulSet", "Lio/kubernetes/client/openapi/models/V1StatefulSet;", "Lio/kubernetes/client/openapi/models/V1StatefulSetList;", "StorageClass", "Lio/kubernetes/client/openapi/models/V1StorageClass;", "Lio/kubernetes/client/openapi/models/V1StorageClassList;", "createCustomResource", "Lcom/intellij/kubernetes/api/KubernetesCustomResource;", "Lcom/intellij/kubernetes/api/KubernetesCustomResourceList;", "definition", "isNamespaced", "", "createStandard", "T", "L", "Lio/kubernetes/client/common/KubernetesObject;", "Lio/kubernetes/client/common/KubernetesListObject;", "displayableKind", "Lcom/intellij/openapi/util/NlsSafe;", "displayableKinds", "apiPathSegments", "", "lazyMapper", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "icon", "Ljavax/swing/Icon;", "serializer", "Lkotlinx/serialization/KSerializer;", "typeSerial0", "typeSerial1", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesEntity<?, ?> findByKind(@NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return (KubernetesEntity)entities.get(kind);
        }

        @JvmStatic
        @NotNull
        public final KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> createCustomResource(@NotNull V1CustomResourceDefinition definition, boolean isNamespaced) {
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            V1CustomResourceDefinitionSpec spec = definition.getSpec();
            V1CustomResourceDefinitionNames names = spec.getNames();
            String kind = names.getKind();
            String string = names.getSingular();
            if (string == null) {
                Intrinsics.checkNotNull((Object)kind);
                String string2 = kind.toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            }
            String resource = string + "." + spec.getGroup();
            Intrinsics.checkNotNull((Object)kind);
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesCustomResource.class);
            String string3 = Strings.pluralize((String)kind);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluralize(...)");
            String string4 = definition.getSpec().getNames().getPlural();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPlural(...)");
            KClass kClass2 = Reflection.getOrCreateKotlinClass(KubernetesCustomResourceList.class);
            Collection collection = KubernetesEntityKt.access$getApis$p();
            Object[] objectArray = new String[2];
            objectArray[0] = definition.getSpec().getGroup();
            List list2 = definition.getSpec().getVersions();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getVersions(...)");
            objectArray[1] = ((V1CustomResourceDefinitionVersion)CollectionsKt.last((List)list2)).getName();
            List list3 = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
            Icon icon = KubernetesIcons.CustomResourceDefinition;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CustomResourceDefinition");
            return new KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList>(kind, kind, resource, kClass, string3, string4, kClass2, list3, isNamespaced, icon, null);
        }

        private final /* synthetic */ <T extends KubernetesObject, L extends KubernetesListObject> KubernetesEntity<T, L> createStandard(String displayableKind, String displayableKinds, List<String> apiPathSegments, boolean isNamespaced, Function0<? extends KubernetesResourceMapper<T, L>> lazyMapper, Icon icon) {
            boolean $i$f$createStandard = false;
            String kind = StringsKt.replace$default((String)displayableKind, (String)" ", (String)"", (boolean)false, (int)4, null);
            String string = kind.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesObject.class);
            String string2 = StringsKt.replace$default((String)displayableKinds, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"L");
            KubernetesEntity entity = new KubernetesEntity(kind, displayableKind, string, kClass, displayableKinds, string2, Reflection.getOrCreateKotlinClass(KubernetesListObject.class), apiPathSegments, isNamespaced, icon, null);
            KubernetesResourceMapper.Companion.registerMapper(entity, lazyMapper);
            return entity;
        }

        static /* synthetic */ KubernetesEntity createStandard$default(Companion $this, String displayableKind, String displayableKinds, List apiPathSegments, boolean isNamespaced, Function0 lazyMapper, Icon icon, int n, Object object) {
            if ((n & 4) != 0) {
                apiPathSegments = KubernetesEntityKt.access$getApiV1PathSegments$p();
            }
            if ((n & 8) != 0) {
                isNamespaced = true;
            }
            boolean $i$f$createStandard = false;
            String kind = StringsKt.replace$default((String)displayableKind, (String)" ", (String)"", (boolean)false, (int)4, null);
            String string = kind.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesObject.class);
            String string2 = StringsKt.replace$default((String)displayableKinds, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"L");
            KubernetesEntity entity = new KubernetesEntity(kind, displayableKind, string, kClass, displayableKinds, string2, Reflection.getOrCreateKotlinClass(KubernetesListObject.class), apiPathSegments, isNamespaced, icon, null);
            KubernetesResourceMapper.Companion.registerMapper(entity, lazyMapper);
            return entity;
        }

        @NotNull
        public final <T, L> KSerializer<KubernetesEntity<T, L>> serializer(@NotNull KSerializer<T> typeSerial0, @NotNull KSerializer<L> typeSerial1) {
            Intrinsics.checkNotNullParameter(typeSerial0, (String)"typeSerial0");
            Intrinsics.checkNotNullParameter(typeSerial1, (String)"typeSerial1");
            return new Serializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0002H\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/api/KubernetesEntity$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "intellij.clouds.kubernetes"})
    public static final class Serializer
    implements KSerializer<KubernetesEntity<?, ?>> {
        @NotNull
        private final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"KubernetesEntity", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull KubernetesEntity<?, ?> value2) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            encoder.encodeString(value2.getKind());
        }

        @NotNull
        public KubernetesEntity<?, ?> deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            String string = decoder.decodeString();
            KubernetesEntity<?, ?> kubernetesEntity = Companion.findByKind(string);
            if (kubernetesEntity == null) {
                throw new IllegalStateException(("Unknown kind: " + string).toString());
            }
            return kubernetesEntity;
        }
    }
}

