/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.splitApi.frontend;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesLogHandler;
import com.intellij.kubernetes.splitApi.KubernetesApiProviderProxy;
import com.intellij.kubernetes.splitApi.KubernetesLogEvent;
import com.intellij.kubernetes.splitApi.KubernetesLogHandlerRemoteTopicKt;
import com.intellij.kubernetes.splitApi.KubernetesLogType;
import com.intellij.kubernetes.view.ui.KubernetesUIUtilitiesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.serviceView.ServiceViewImplementationChooserKt;
import com.intellij.platform.rpc.topics.ProjectRemoteTopic;
import com.intellij.platform.rpc.topics.ProjectRemoteTopicListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/splitApi/frontend/KubernetesLogsRemoteTopicListener;", "Lcom/intellij/platform/rpc/topics/ProjectRemoteTopicListener;", "Lcom/intellij/kubernetes/splitApi/KubernetesLogEvent;", "<init>", "()V", "topic", "Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "getTopic", "()Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "handleEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "intellij.clouds.kubernetes"})
public final class KubernetesLogsRemoteTopicListener
implements ProjectRemoteTopicListener<KubernetesLogEvent> {
    @NotNull
    public ProjectRemoteTopic<KubernetesLogEvent> getTopic() {
        return KubernetesLogHandlerRemoteTopicKt.getKUBERNETES_LOGS_REMOTE_TOPIC();
    }

    public void handleEvent(@NotNull Project project, @NotNull KubernetesLogEvent event2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!ServiceViewImplementationChooserKt.shouldEnableServicesViewInCurrentEnvironment()) {
            return;
        }
        Object object = KubernetesApiProviderProxy.Companion.getInstanceIfCreated(project);
        if (object == null || (object = object.findModel(event2.getContext())) == null) {
            return;
        }
        Object model = object;
        KubernetesLogHandler publisher = (KubernetesLogHandler)project.getMessageBus().syncPublisher(KubernetesLogHandler.TOPIC);
        if (event2.getAllowFocusInterception()) {
            KubernetesUIUtilitiesKt.selectContextInServicesView((KubernetesApiModelInterface)model);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event2.getType().ordinal()]) {
            case 1: {
                publisher.printNormal((KubernetesApiModelInterface)model, event2.getLine());
                break;
            }
            case 2: {
                publisher.printSystem((KubernetesApiModelInterface)model, event2.getLine());
                break;
            }
            case 3: {
                publisher.printError((KubernetesApiModelInterface)model, event2.getLine());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KubernetesLogType.values().length];
            try {
                nArray[KubernetesLogType.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KubernetesLogType.SYSTEM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KubernetesLogType.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

