/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/telepresence/PasswordRequestParser;", "", "<init>", "()V", "sudoPasswordPattern", "Lkotlin/text/Regex;", "pivPattern", "isSudoPasswordRequest", "", "text", "", "tryFindPinForPivRequest", "", "Lcom/intellij/openapi/util/NlsSafe;", "where", "intellij.clouds.kubernetes"})
@VisibleForTesting
public final class PasswordRequestParser {
    @NotNull
    private final Regex sudoPasswordPattern = new Regex("[\\s\\S]*password.*:", RegexOption.IGNORE_CASE);
    @NotNull
    private final Regex pivPattern = new Regex("Enter PIN for 'Certificate For PIV Authentication \\(.*\\)':");

    public final boolean isSudoPasswordRequest(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.sudoPasswordPattern.matches(text);
    }

    @Nullable
    public final String tryFindPinForPivRequest(@NotNull CharSequence where) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        MatchResult matchResult = Regex.find$default((Regex)this.pivPattern, (CharSequence)where, (int)0, (int)2, null);
        return matchResult != null ? matchResult.getValue() : null;
    }
}

