/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.KubernetesContainerHealthCheckTableCellRenderer;
import com.intellij.kubernetes.view.ui.KubernetesContainerStatusTableCellRenderer;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a7\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0019\u0010\u0006\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0007\u00a2\u0006\u0002\b\bH\u0002\u001a\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0012\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0001H\u0002\u001a\u0012\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0001H\u0002\u001a\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u00a8\u0006\u0015"}, d2={"addNameField", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "", "addStringField", "name", "value", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addImageField", "addRestartCountField", "addReadyStatusField", "addHealthCheckField", "addStatusField", "addAgeField", "calculateAge", "creationTimestamp", "Ljava/time/OffsetDateTime;", "addContainerIDField", "addStartedField", "addRunningField", "intellij.clouds.kubernetes"})
public final class KubernetesContainerServiceViewDescriptorKt {
    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addNameField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.nameField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addNameField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addStringField(String name, Function1<? super KubernetesContainerObject, String> value2) {
        return new KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String>(name, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, FileNameComparator.getInstance(), null, null, null, arg_0 -> KubernetesContainerServiceViewDescriptorKt.addStringField$lambda$0(value2, arg_0), 112, null);
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addImageField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Image", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addImageField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addRestartCountField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.v1container.restart.count", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addRestartCountField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addReadyStatusField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Ready", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addReadyStatusField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, ?> addHealthCheckField() {
        String string = KubernetesBundle.message("KubernetesPodMapper.healthCheckField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        int n = JBUI.scale((int)100);
        KubernetesContainerHealthCheckTableCellRenderer kubernetesContainerHealthCheckTableCellRenderer = new KubernetesContainerHealthCheckTableCellRenderer();
        return new KubernetesResourceMapper.ColumnDescriptor(string2, Reflection.getOrCreateKotlinClass(KubernetesContainerObject.class), null, null, kubernetesContainerHealthCheckTableCellRenderer, null, n, KubernetesContainerServiceViewDescriptorKt::addHealthCheckField$lambda$0, 44, null);
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, ?> addStatusField() {
        String string = KubernetesBundle.message("KubernetesPodMapper.containerStatus.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        int n = JBUI.scale((int)100);
        KubernetesContainerStatusTableCellRenderer kubernetesContainerStatusTableCellRenderer = new KubernetesContainerStatusTableCellRenderer();
        return new KubernetesResourceMapper.ColumnDescriptor(string2, Reflection.getOrCreateKotlinClass(KubernetesContainerObject.class), null, null, kubernetesContainerStatusTableCellRenderer, null, n, KubernetesContainerServiceViewDescriptorKt::addStatusField$lambda$0, 44, null);
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addAgeField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.ageField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addAgeField$lambda$0));
    }

    private static final String calculateAge(OffsetDateTime creationTimestamp) {
        if (creationTimestamp == null) {
            return "Unknown";
        }
        Duration duration = Duration.between(creationTimestamp, OffsetDateTime.now());
        String string = "%dd %dh %dm";
        Object[] objectArray = new Object[]{duration.toDays(), duration.toHours() % (long)24, duration.toMinutes() % (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addContainerIDField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Container ID", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addContainerIDField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addStartedField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Started", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addStartedField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addRunningField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Running", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addRunningField$lambda$0));
    }

    private static final String addNameField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return $this$addStringField.getName();
    }

    private static final String addStringField$lambda$0(Function1 $value, KubernetesContainerObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        String string = (String)$value.invoke((Object)$this$ColumnDescriptor);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    private static final String addImageField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return $this$addStringField.getImage();
    }

    private static final String addRestartCountField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.getRestartCount());
    }

    private static final String addReadyStatusField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.isReady());
    }

    private static final KubernetesContainerObject addHealthCheckField$lambda$0(KubernetesContainerObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        return $this$ColumnDescriptor;
    }

    private static final KubernetesContainerObject addStatusField$lambda$0(KubernetesContainerObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        return $this$ColumnDescriptor;
    }

    private static final String addAgeField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        V1ObjectMeta v1ObjectMeta = $this$addStringField.getMetadata();
        return KubernetesContainerServiceViewDescriptorKt.calculateAge(v1ObjectMeta != null ? v1ObjectMeta.getCreationTimestamp() : null);
    }

    private static final String addContainerIDField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        String string = $this$addStringField.getContainerId();
        if (string == null) {
            string = "Not Available";
        }
        return string;
    }

    private static final String addStartedField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.getStarted());
    }

    private static final String addRunningField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.isRunning());
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addNameField() {
        return KubernetesContainerServiceViewDescriptorKt.addNameField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addImageField() {
        return KubernetesContainerServiceViewDescriptorKt.addImageField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addStatusField() {
        return KubernetesContainerServiceViewDescriptorKt.addStatusField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addHealthCheckField() {
        return KubernetesContainerServiceViewDescriptorKt.addHealthCheckField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addRestartCountField() {
        return KubernetesContainerServiceViewDescriptorKt.addRestartCountField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addReadyStatusField() {
        return KubernetesContainerServiceViewDescriptorKt.addReadyStatusField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addAgeField() {
        return KubernetesContainerServiceViewDescriptorKt.addAgeField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addContainerIDField() {
        return KubernetesContainerServiceViewDescriptorKt.addContainerIDField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addStartedField() {
        return KubernetesContainerServiceViewDescriptorKt.addStartedField();
    }

    public static final /* synthetic */ KubernetesResourceMapper.ColumnDescriptor access$addRunningField() {
        return KubernetesContainerServiceViewDescriptorKt.addRunningField();
    }
}

