/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.splitApi.KubernetesActionsRpcServiceKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesNamespaceAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesAllNamespacesAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesNamespaceAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.clouds.kubernetes"})
public final class KubernetesAllNamespacesAction
extends KubernetesModelBasedDumbAwareToggleAction
implements KubernetesNamespaceAction,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final String namespace;

    public KubernetesAllNamespacesAction() {
        this.namespace = "Kubernetes.All.Namespaces.Label";
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
        return kubernetesApiModelInterface != null ? kubernetesApiModelInterface.isAllNamespaces() : false;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            KubernetesUsageTriggerCollector.KubernetesEventWrapper<String> kubernetesEventWrapper = KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT();
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            kubernetesEventWrapper.log(project, "all-namespaces");
            KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
            if (kubernetesApiModelInterface == null) break block0;
            kubernetesApiModelInterface.scheduleSetNamespace("Kubernetes.All.Namespaces.Label");
        }
    }
}

