/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.SelectedKubernetesResourceSerializer;
import io.kubernetes.client.common.KubernetesObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=SelectedKubernetesResourceSerializer.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0001 B)\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource;", "", "resourceKind", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "selectedAll", "", "selectedValue", "Lio/kubernetes/client/common/KubernetesObject;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesEntity;ZLio/kubernetes/client/common/KubernetesObject;)V", "getResourceKind", "()Lcom/intellij/kubernetes/api/KubernetesEntity;", "getSelectedAll", "()Z", "getSelectedValue", "()Lio/kubernetes/client/common/KubernetesObject;", "getCastedValue", "V", "singleSelectedValue", "getSingleSelectedValue$annotations", "()V", "getSingleSelectedValue", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nactionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
public final class SelectedKubernetesResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesEntity<?, ?> resourceKind;
    private final boolean selectedAll;
    @Nullable
    private final KubernetesObject selectedValue;

    public SelectedKubernetesResource(@NotNull KubernetesEntity<?, ?> resourceKind, boolean selectedAll, @Nullable KubernetesObject selectedValue) {
        Intrinsics.checkNotNullParameter(resourceKind, (String)"resourceKind");
        this.resourceKind = resourceKind;
        this.selectedAll = selectedAll;
        this.selectedValue = selectedValue;
        if (this.selectedAll && !(this.selectedValue == null)) {
            boolean $i$a$-check-SelectedKubernetesResource$42 = false;
            String $i$a$-check-SelectedKubernetesResource$42 = "If selectedAll = true, then selectedValues must be empty";
            throw new IllegalStateException($i$a$-check-SelectedKubernetesResource$42.toString());
        }
        if (!this.selectedAll && !(this.selectedValue != null)) {
            boolean $i$a$-check-SelectedKubernetesResource$52 = false;
            String $i$a$-check-SelectedKubernetesResource$52 = "If selectedAll = false, then selectedValues must not be empty";
            throw new IllegalStateException($i$a$-check-SelectedKubernetesResource$52.toString());
        }
        if (!this.selectedAll) {
            KubernetesObject kubernetesObject = this.selectedValue;
            Intrinsics.checkNotNull((Object)kubernetesObject);
            if (!Intrinsics.areEqual((Object)kubernetesObject.getKind(), (Object)this.resourceKind.getKind())) {
                boolean bl = false;
                String string = "Unexpected resource kind: " + this.selectedValue.getKind();
                throw new IllegalStateException(string.toString());
            }
        }
    }

    @NotNull
    public final KubernetesEntity<?, ?> getResourceKind() {
        return this.resourceKind;
    }

    public final boolean getSelectedAll() {
        return this.selectedAll;
    }

    @Nullable
    public final KubernetesObject getSelectedValue() {
        return this.selectedValue;
    }

    @Nullable
    public final <V extends KubernetesObject> V getCastedValue() {
        KubernetesObject kubernetesObject = this.getSingleSelectedValue();
        if (kubernetesObject == null) {
            return null;
        }
        KubernetesObject selectedValue = kubernetesObject;
        KubernetesObject kubernetesObject2 = ActionUtilsKt.access$getCastedValue(selectedValue, this.resourceKind);
        return (V)(kubernetesObject2 instanceof KubernetesObject ? kubernetesObject2 : null);
    }

    @Nullable
    public final KubernetesObject getSingleSelectedValue() {
        if (this.selectedAll || this.selectedValue == null) {
            return null;
        }
        return this.selectedValue;
    }

    public static /* synthetic */ void getSingleSelectedValue$annotations() {
    }

    @NotNull
    public final KubernetesEntity<?, ?> component1() {
        return this.resourceKind;
    }

    public final boolean component2() {
        return this.selectedAll;
    }

    @Nullable
    public final KubernetesObject component3() {
        return this.selectedValue;
    }

    @NotNull
    public final SelectedKubernetesResource copy(@NotNull KubernetesEntity<?, ?> resourceKind, boolean selectedAll, @Nullable KubernetesObject selectedValue) {
        Intrinsics.checkNotNullParameter(resourceKind, (String)"resourceKind");
        return new SelectedKubernetesResource(resourceKind, selectedAll, selectedValue);
    }

    public static /* synthetic */ SelectedKubernetesResource copy$default(SelectedKubernetesResource selectedKubernetesResource, KubernetesEntity kubernetesEntity, boolean bl, KubernetesObject kubernetesObject, int n, Object object) {
        if ((n & 1) != 0) {
            kubernetesEntity = selectedKubernetesResource.resourceKind;
        }
        if ((n & 2) != 0) {
            bl = selectedKubernetesResource.selectedAll;
        }
        if ((n & 4) != 0) {
            kubernetesObject = selectedKubernetesResource.selectedValue;
        }
        return selectedKubernetesResource.copy(kubernetesEntity, bl, kubernetesObject);
    }

    @NotNull
    public String toString() {
        return "SelectedKubernetesResource(resourceKind=" + this.resourceKind + ", selectedAll=" + this.selectedAll + ", selectedValue=" + this.selectedValue + ")";
    }

    public int hashCode() {
        int result = this.resourceKind.hashCode();
        result = result * 31 + Boolean.hashCode(this.selectedAll);
        result = result * 31 + (this.selectedValue == null ? 0 : this.selectedValue.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectedKubernetesResource)) {
            return false;
        }
        SelectedKubernetesResource selectedKubernetesResource = (SelectedKubernetesResource)other;
        if (!Intrinsics.areEqual(this.resourceKind, selectedKubernetesResource.resourceKind)) {
            return false;
        }
        if (this.selectedAll != selectedKubernetesResource.selectedAll) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.selectedValue, (Object)selectedKubernetesResource.selectedValue);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<SelectedKubernetesResource> serializer() {
            return new SelectedKubernetesResourceSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

