/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSetImpl;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInputStream;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ConcurrentBitSet {
    @Contract(value="->new")
    @NotNull
    public static ConcurrentBitSet create() {
        return new ConcurrentBitSetImpl();
    }

    @Contract(value="_->new")
    @NotNull
    public static ConcurrentBitSet create(int estimatedSize) {
        return new ConcurrentBitSetImpl(estimatedSize);
    }

    public boolean set(int var1);

    public void set(int var1, boolean var2);

    public boolean clear(int var1);

    public void clear();

    public boolean get(int var1);

    public int nextSetBit(int var1);

    public int nextClearBit(int var1);

    public int size();

    public int cardinality();

    public int @NotNull [] toIntArray();

    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull DataInputStream input) throws IOException {
        if (input == null) {
            ConcurrentBitSet.$$$reportNull$$$0(0);
        }
        IntArrayList buffer = new IntArrayList();
        int bytesAvailable;
        block0: while ((bytesAvailable = input.available()) != 0) {
            int intsAvailable = bytesAvailable / 4;
            buffer.ensureCapacity(buffer.size() + intsAvailable);
            int i = 0;
            while (true) {
                if (i >= intsAvailable) continue block0;
                buffer.add(input.readInt());
                ++i;
            }
            break;
        }
        return new ConcurrentBitSetImpl(buffer.toIntArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/util/containers/ConcurrentBitSet", "readFrom"));
    }
}

