/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf.tree;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfService;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ShelfTree;
import com.intellij.platform.vcs.impl.shared.rhizome.ShelvedChangeListEntity;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelveDeleteProvider;", "Lcom/intellij/ide/DeleteProvider;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelfTree;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelfTree;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "deleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canDeleteElement", "", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class ShelveDeleteProvider
implements DeleteProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ShelfTree tree;

    public ShelveDeleteProvider(@NotNull Project project, @NotNull ShelfTree tree) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        this.project = project;
        this.tree = tree;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Set<ShelvedChangeListEntity> listsToDelete = this.tree.getExactlySelectedLists();
        Map map = (Map)ShelfTree.Companion.getGROUPED_CHANGES_KEY().getData(dataContext);
        if (map == null) {
            return;
        }
        Map groupedChanges = map;
        ShelfService.Companion.getInstance(this.project).deleteChangeList(listsToDelete, groupedChanges);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return !((Collection)this.tree.getSelectedLists()).isEmpty();
    }
}

