/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class SqlBinaryExpressionCompletionProvider
extends SqlCompletionProviderBase {
    @Override
    protected void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        SqlExpression topExpression;
        if (parameters == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(2);
        }
        if (SqlJoinSmartCompletionProvider.suggestJoinStuff(parameters, result, false) || SqlPsiMiscUtil.isJoinUsingColumn(parameters.getPosition())) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiFile file = parameters.getOriginalFile();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlReferenceExpression reference2 = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
        SqlExpression sqlExpression = topExpression = reference2 == null ? (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlStringLiteralExpression.class) : (SqlExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, SqlReferenceExpression.class);
        if (topExpression == null || topExpression instanceof SqlReferenceExpression && ((SqlReferenceExpression)topExpression).getQualifierExpression() != null) {
            return;
        }
        PsiElement parent = topExpression.getParent();
        if (parent instanceof SqlSetAssignment) {
            SqlElement lValue = ((SqlSetAssignment)parent).getLValue();
            if (!(lValue instanceof SqlExpression)) {
                return;
            }
            SqlExpression expression = (SqlExpression)lValue;
            DasType expectedType = expression.getDasType();
            SqlCompletionUtil.addItemsFromExpectedColumnType((Consumer<? super LookupElement>)result, (PsiElement)topExpression, expectedType, dialect);
            return;
        }
        if (!(parent instanceof SqlBinaryExpression)) {
            return;
        }
        SqlBinaryExpression binary = (SqlBinaryExpression)parent;
        IElementType sign = binary.getOpSign();
        if (sign == SqlCommonKeywords.SQL_OR || sign == SqlCommonKeywords.SQL_AND) {
            return;
        }
        Object leftOperand = binary.getLOperand() == topExpression ? binary.getROperand() : (binary.getROperand() == topExpression ? binary.getLOperand() : null);
        if (leftOperand == null) {
            return;
        }
        DasType expectedType = leftOperand.getDasType();
        SqlCompletionUtil.addItemsFromExpectedColumnType((Consumer<? super LookupElement>)result, (PsiElement)topExpression, expectedType, dialect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/completion/providers/SqlBinaryExpressionCompletionProvider";
        objectArray[2] = "doAddCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

