/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLabelHolder;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlResolveExtension;
import com.intellij.sql.psi.impl.SqlResolveResultImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.OrderedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlReferenceImpl
implements SqlReference {
    public static final Key<Boolean> USE_SQL_DATA_SOURCE_MODEL = Key.create((String)"USE_SQL_DATA_SOURCE_MODEL");
    public static final Key<Boolean> IGNORE_DATA_SOURCES = Key.create((String)"IGNORE_DATA_SOURCES");
    public static final Key<Boolean> LOOK_AT_MINICAT = Key.create((String)"LOOK_AT_MINICAT");
    public static final Key<Boolean> COMPLETION_MODE = Key.create((String)"COMPLETION_MODE");
    @NotNull
    private static final ResolveCache.PolyVariantResolver<SqlReferenceImpl> MY_RESOLVER = (reference2, incompleteCode) -> {
        if (PlatformUtils.isJetBrainsClient()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiFile file = reference2.getElement().getContainingFile();
        if (file instanceof SqlFileImpl && reference2.getQualifier() == null) {
            SqlResolveCache cache = ((SqlFileImpl)file).getResolveCache();
            ResolveResult[] result = cache.getResult((PsiReference)reference2);
            if (result != null) {
                return result;
            }
            ResolveResult[] computed = reference2.resolveInner();
            cache.cacheResult((PsiReference)reference2, computed);
            return computed;
        }
        return reference2.resolveInner();
    };
    @NotNull
    private static final ResolveCache.AbstractResolver<SqlReferenceImpl, DasType> MY_TYPE_RESOLVER = (reference2, incompleteCode) -> reference2.getDasTypeInner();
    private final SqlElement myElement;

    public SqlReferenceImpl(@NotNull SqlElement element) {
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @Nullable
    public SqlExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Nullable
    public abstract SqlExpression getQualifierExpression();

    @NotNull
    public abstract String getReferenceName();

    public boolean isQuoted() {
        return DbSqlUtilCore.isQuoted((SqlNameElement)((SqlNameElement)ObjectUtils.tryCast((Object)this.getElement(), SqlNameElement.class)));
    }

    @NotNull
    public DasType getDasType() {
        DasType type = (DasType)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, MY_TYPE_RESOLVER, true, false);
        Object object = type == null ? DasTypeSystemBase.UNKNOWN : type;
        if (object == null) {
            SqlReferenceImpl.$$$reportNull$$$0(1);
        }
        return object;
    }

    public boolean resolveStrict() {
        if (SqlPsiMiscUtil.isDropTarget((PsiElement)this.myElement) || SqlPsiMiscUtil.isJoinUsingColumn((PsiElement)this.myElement)) {
            return true;
        }
        SqlSetAssignment assignment = (SqlSetAssignment)ObjectUtils.tryCast((Object)this.myElement.getParent(), SqlSetAssignment.class);
        return PsiTreeUtil.getParentOfType((PsiElement)assignment, SqlUpdateStatement.class) != null && assignment.getLValue() == this.myElement;
    }

    @NotNull
    private DasType getDasTypeInner() {
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        ResolveResult result = this.resolveSingle();
        PsiElement element = result != null ? result.getElement() : null;
        DasSymbol symbol = DasSymbolUtil.getSymbol(result);
        DasType dasType = dialect.getTypeSystem().getDasType((SqlReference)this, element, symbol);
        if (dasType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(2);
        }
        return dasType;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (SqlImplUtil.isRefWithDblink((PsiElement)this.myElement)) {
            SqlReferenceExpression nestedRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlReferenceExpression.class);
            ResolveResult[] resolveResultArray = nestedRef != null ? nestedRef.multiResolve(incompleteCode) : ResolveResult.EMPTY_ARRAY;
            if (resolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        SqlExpression qual = this.getQualifier();
        if (SqlImplUtil.isAsteriskRef((PsiElement)this.myElement)) {
            PsiElement qualifier = qual instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qual).resolve() : null;
            DasSymbol symbol = DasSymbolUtil.getInlineSymbol(this);
            DasType dasType = this.getSqlDialect().getTypeSystem().getDasType((SqlReference)this, (PsiElement)this.myElement, symbol);
            Object immediateTarget = this.myElement;
            if (dasType instanceof SqlTableType) {
                SqlTableType tableType2 = (SqlTableType)dasType;
                PsiElement context = tableType2.getTypeElement();
                if (context == null) {
                    context = this.myElement;
                }
                immediateTarget = new SqlAsteriskSymbol(context, tableType2);
            }
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(qualifier, (PsiElement)immediateTarget, (PsiElement)this.myElement, symbol);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(4);
            }
            return sqlResolveResultArray;
        }
        PsiElement parent = this.myElement.getParent();
        if (SqlPsiElementFactory.isROFile(parent)) {
            parent = parent.getContext();
        }
        if (!((Boolean)USE_SQL_DATA_SOURCE_MODEL.get((UserDataHolder)this.getElement(), (Object)false)).booleanValue() && parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == this.myElement) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(null, parent, parent, (DasSymbol)((SqlDefinition)parent));
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(5);
            }
            return sqlResolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            SqlReferenceImpl.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public ResolveResult resolveSingle() {
        ResolveResult[] results;
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (SqlReferenceImpl.isFakeGroup(result) || SqlImplUtil.isMarkedUnresolved(result)) continue;
            return result;
        }
        return results.length == 0 ? null : results[0];
    }

    @Nullable
    public PsiElement resolveImmediate() {
        ResolveResult result = this.resolveSingle();
        PsiElement immediateTarget = result instanceof SqlResolveResult ? ((SqlResolveResult)result).getImmediateTarget() : null;
        return immediateTarget != null ? immediateTarget : this.resolve();
    }

    private static boolean isFakeGroup(ResolveResult res) {
        return SqlFileImpl.isFakeGroup(res.getElement());
    }

    public PsiElement resolve() {
        ResolveResult result = this.resolveSingle();
        return result == null ? null : result.getElement();
    }

    @NotNull
    public Collection<? extends Symbol> resolveReference() {
        List list = SqlImplUtil.resolveVisible((PsiPolyVariantReference)this).map(resolveResult -> PsiSymbolService.getInstance().asSymbol(Objects.requireNonNull(resolveResult.getElement()))).toList();
        if (list == null) {
            SqlReferenceImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public PsiElement getElement() {
        SqlElement sqlElement = this.myElement;
        if (sqlElement == null) {
            SqlReferenceImpl.$$$reportNull$$$0(8);
        }
        return sqlElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            SqlReferenceImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(10);
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)element;
            return this.handleElementRename(namedElement.getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement e1) {
        if (e1 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(11);
        }
        if (SqlReferenceImpl.isEmptyReferenceTo((PsiElement)this.myElement, e1)) {
            return true;
        }
        SqlReferenceElementType refType = this.getReferenceElementType();
        for (ResolveResult result : this.multiResolve(false)) {
            SqlNameElement element;
            PsiElement e2 = result.getElement();
            if (this.myElement.getManager().areElementsEquivalent(e1, e2)) {
                return true;
            }
            if (refType != SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE || !(e2 instanceof SqlDefinition) || (element = ((SqlDefinition)e2).getNameElement()) == null || !SqlReferenceImpl.isEmptyReferenceTo((PsiElement)element, e1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyReferenceTo(PsiElement element, PsiElement e1) {
        PsiElement lastChild;
        PsiElement psiElement = lastChild = element instanceof SqlReferenceExpression ? element.getLastChild() : null;
        if (element.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)lastChild;
            return refExpression.getReference().isReferenceTo(e1);
        }
        return false;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        ASTNode astNode = this.myElement.getNode();
        IElementType elementType = astNode != null ? astNode.getElementType() : null;
        SqlReferenceElementType sqlReferenceElementType = elementType instanceof SqlReferenceElementType ? (SqlReferenceElementType)elementType : SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(12);
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public SqlScopeProcessor createResolveProcessor(final @NotNull TriConsumer<? super DasSymbol, ? super ResolveState, ? super SqlScopeProcessor> consumer) {
        if (consumer == null) {
            SqlReferenceImpl.$$$reportNull$$$0(13);
        }
        String referenceName = this.getReferenceName();
        final SqlLanguageDialectEx dialect = this.getSqlDialect();
        List<DbDataSource> dataSources = SqlImplUtil.getDataSources((PsiElement)this.getTopLevelSqlFile());
        boolean dontCheckName = StringUtil.isEmpty((String)referenceName) && this.getQualifierExpression() != null;
        final NameChecker nameChecker = dontCheckName ? null : new NameChecker(referenceName, this.isQuoted(), SqlImplUtil.getCasingProvider(dialect, dataSources), (SqlLanguageDialect)dialect);
        return new SqlScopeProcessorBase(this, referenceName, dialect, dataSources, (PsiElement)this.myElement){
            boolean isEmpty;
            {
                super(referenceName, dialect2, dataSources, place);
                this.isEmpty = true;
            }

            public boolean isResultEmpty() {
                return this.isEmpty;
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (nameChecker != null && !dialect.shouldSkipResolveNameCheck(symbol, symbol.getKind(), this.getExpectedTypes(), this.getPlace()) && !nameChecker.checkName((DasNamed)symbol, forcedCaseSens)) {
                    return true;
                }
                if (!this.checkType(symbol, dasType)) {
                    return true;
                }
                if (!DasSymbolUtil.isUnresolved(symbol)) {
                    this.isEmpty = false;
                }
                consumer.accept((Object)symbol, (Object)state, (Object)this);
                return dasType == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static SqlResolveResult findConflictingResult(@NotNull Set<SqlResolveResult> result, @NotNull PsiElement newTarget, @NotNull SqlLanguageDialectEx dialect) {
        if (result == null) {
            SqlReferenceImpl.$$$reportNull$$$0(14);
        }
        if (newTarget == null) {
            SqlReferenceImpl.$$$reportNull$$$0(15);
        }
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(16);
        }
        for (SqlResolveResult resolveResult : result) {
            if (!SqlImplUtil.isMarkedUnresolved((ResolveResult)resolveResult)) continue;
            return resolveResult;
        }
        if (newTarget instanceof SqlParameterDefinition) {
            return (SqlResolveResult)ContainerUtil.find(result, r -> r.getElement() instanceof DasColumn);
        }
        Dbms dbms = dialect.getDbms();
        if (newTarget instanceof DasColumn) {
            return dbms.isSnowflake() || dbms.isRedshift() ? (SqlResolveResult)ContainerUtil.find(result, r -> r.getElement() instanceof SqlAsExpression) : null;
        }
        if (newTarget instanceof SqlCreateViewStatement) {
            return dialect.getDbms().isPostgres() ? (SqlResolveResult)ContainerUtil.find(result, r -> r.getElement() instanceof SqlCreateViewStatement) : null;
        }
        if (dbms.isSqlite() && newTarget instanceof DbTable) {
            return (SqlResolveResult)ContainerUtil.find(result, r -> {
                PsiElement element = r.getElement();
                return element instanceof SqlCreateStatement && SqlImplUtil.sqlChildren(element).find(e -> PsiUtilCore.getElementType((PsiElement)e) == SqlCommonKeywords.SQL_VIRTUAL) != null;
            });
        }
        return null;
    }

    @NotNull
    private static ResolveConflictPolicy getPreference(@NotNull SqlResolveResult currentResult, @NotNull SqlResolveResult newResult, @NotNull SqlLanguageDialectEx dialect) {
        if (currentResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(17);
        }
        if (newResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(19);
        }
        if (SqlImplUtil.isMarkedUnresolved((ResolveResult)currentResult)) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(20);
            }
            return resolveConflictPolicy;
        }
        if (SqlImplUtil.isMarkedUnresolved((ResolveResult)newResult)) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(21);
            }
            return resolveConflictPolicy;
        }
        Dbms dbms = dialect.getDbms();
        PsiElement newPsi = newResult.getElement();
        PsiElement currentPsi = currentResult.getElement();
        if (currentPsi instanceof DasColumn && newPsi instanceof SqlParameterDefinition) {
            if (dbms.isOracle() || dbms.isHsqldb() || dbms.isDb2()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.HIDE_NEW;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(22);
                }
                return resolveConflictPolicy;
            }
            if (dbms.isMysql() || dbms.isSnowflake() || dbms.isGreenplum()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(23);
                }
                return resolveConflictPolicy;
            }
            if (dbms == Dbms.POSTGRES) {
                SqlRoutineDefinition routine = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)newPsi, SqlRoutineDefinition.class);
                if (routine == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(24);
                    }
                    return resolveConflictPolicy;
                }
                SqlElement statement = (SqlElement)routine.getBody().first();
                if (statement == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(25);
                    }
                    return resolveConflictPolicy;
                }
                for (PsiElement sibling : SqlImplUtil.revSiblings((PsiElement)statement)) {
                    String valueText;
                    PsiElement kind;
                    PsiElement mark;
                    if (!(sibling instanceof SqlClause) || PsiUtilCore.getElementType((PsiElement)(mark = sibling.getFirstChild())) != SqlCommonTokens.SQL_HASHMARK || (kind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)mark)) == null || !"variable_conflict".equalsIgnoreCase(kind.getText())) continue;
                    PsiElement value = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)kind);
                    String string = valueText = value != null ? value.getText() : null;
                    if ("use_column".equalsIgnoreCase(valueText)) {
                        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
                        if (resolveConflictPolicy == null) {
                            SqlReferenceImpl.$$$reportNull$$$0(26);
                        }
                        return resolveConflictPolicy;
                    }
                    if (!"use_variable".equalsIgnoreCase(valueText)) continue;
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(27);
                    }
                    return resolveConflictPolicy;
                }
            }
        }
        if ((dbms.isSnowflake() || dbms.isRedshift()) && currentPsi instanceof SqlAsExpression && newPsi instanceof DasColumn) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(28);
            }
            return resolveConflictPolicy;
        }
        if (dbms.isPostgres() && currentPsi instanceof SqlCreateViewStatement && newPsi instanceof SqlCreateViewStatement) {
            if (((SqlDefinition)currentPsi).isTemporary()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(29);
                }
                return resolveConflictPolicy;
            }
            if (((SqlDefinition)newPsi).isTemporary()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(30);
                }
                return resolveConflictPolicy;
            }
        }
        if (dbms.isSqlite() && currentPsi instanceof SqlCreateStatement && newPsi instanceof DbTable) {
            ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
            if (resolveConflictPolicy == null) {
                SqlReferenceImpl.$$$reportNull$$$0(31);
            }
            return resolveConflictPolicy;
        }
        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
        if (resolveConflictPolicy == null) {
            SqlReferenceImpl.$$$reportNull$$$0(32);
        }
        return resolveConflictPolicy;
    }

    private List<SqlResolveResult> sortBySearchPath(@NotNull OrderedSet<SqlResolveResult> result) {
        if (result == null) {
            SqlReferenceImpl.$$$reportNull$$$0(33);
        }
        if (result.size() <= 1) {
            return result;
        }
        SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(this.getElement());
        if (!sqlDialect.getDatabaseDialect().supportsSearchPath()) {
            return result;
        }
        PsiElement element = this.getElement();
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        if (vFile == null) {
            return result;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getConsole((Project)element.getProject(), (VirtualFile)vFile);
        if (console == null) {
            return result;
        }
        SearchPath path = console.getSearchPath();
        if (path == null || path.elements.size() <= 1) {
            return result;
        }
        return ContainerUtil.sorted(result, (r1, r2) -> {
            int index1 = SqlReferenceImpl.findInSearchPath(r1, path, sqlDialect);
            int index2 = SqlReferenceImpl.findInSearchPath(r2, path, sqlDialect);
            return Integer.compare(index1, index2);
        });
    }

    private static int findInSearchPath(@NotNull SqlResolveResult r, @NotNull SearchPath searchPath, @NotNull SqlLanguageDialectEx dialect) {
        DasSymbol symbol;
        if (r == null) {
            SqlReferenceImpl.$$$reportNull$$$0(34);
        }
        if (searchPath == null) {
            SqlReferenceImpl.$$$reportNull$$$0(35);
        }
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(36);
        }
        if ((symbol = DasSymbolUtil.getSymbol((ResolveResult)r)) == null) {
            return -1;
        }
        DasObject object = symbol.getDasObject();
        if (object == null) {
            return -1;
        }
        ObjectPath path = ObjectPaths.of((DasObject)object);
        while (path != null && path.kind != ObjectKind.SCHEMA) {
            path = path.parent;
        }
        if (path == null) {
            return -1;
        }
        Casing casing = dialect.getCasing(ObjectKind.SCHEMA, object);
        List elements = searchPath.elements;
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            boolean isCaseSensitive;
            ObjectPath searchPathItem = (ObjectPath)elements.get(i2);
            Case targetCase = casing.choose(!searchPathItem.isQuoted());
            Case sourceCase = casing.choose(!path.isQuoted());
            String targetName = targetCase.apply(searchPathItem.name);
            String sourceName = targetCase.apply(path.name);
            boolean bl = isCaseSensitive = targetCase != Case.MIXED && sourceCase != Case.MIXED;
            if (searchPathItem.kind != path.kind || !Comparing.strEqual((String)targetName, (String)sourceName, (boolean)isCaseSensitive)) continue;
            return i2;
        }
        return -1;
    }

    private ResolveResult[] resolveInner() {
        OrderedSet result = new OrderedSet();
        OrderedSet resultFake = new OrderedSet();
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        SqlScopeProcessor processor = this.createResolveProcessor((TriConsumer<? super DasSymbol, ? super ResolveState, ? super SqlScopeProcessor>)((TriConsumer)(arg_0, arg_1, arg_2) -> this.lambda$resolveInner$9((Set)resultFake, dialect, result, arg_0, arg_1, arg_2)));
        if (!this.initExpectedTargetTypes(processor)) {
            result.add((Object)new SqlResolveResultImpl(null, (PsiElement)this.myElement, null, (PsiElement)this.myElement, DasSymbolUtil.getInlineSymbol(this)));
        } else {
            this.processResolveVariants(processor);
        }
        result.addAll((Collection)resultFake);
        dialect.filterResolveResults((Set)result);
        List<SqlResolveResult> sortedResult = this.sortBySearchPath((OrderedSet<SqlResolveResult>)result);
        if (this.myElement instanceof SqlPositionalReference) {
            return SqlResolveResultImpl.createSqlResults(sortedResult);
        }
        if (processor.isResultEmpty()) {
            processor.getDialect().processReservedEntitiesWithType(processor.getReferenceName(), (PsiElement)this.myElement, true, processor);
        }
        if (processor.isResultEmpty()) {
            SqlElement setLValue;
            PsiElement parent = this.myElement.getParent();
            SqlElement sqlElement = setLValue = parent instanceof SqlSetAssignment ? ((SqlSetAssignment)parent).getLValue() : null;
            if (setLValue instanceof SqlReferenceExpression && ((SqlReferenceExpression)setLValue).getReferenceElementType() == SqlCompositeElementTypes.SQL_SYSTEM_REFERENCE) {
                return SqlResolveResultImpl.createSingleSqlResults(null, this.getElement(), this.getElement(), DasSymbolUtil.getInlineSymbol(this));
            }
        }
        return SqlResolveResultImpl.createSqlResults(sortedResult);
    }

    public boolean isSoft() {
        return false;
    }

    private boolean doProcessResolveVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(37);
        }
        ResolveState state = ResolveState.initial();
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
            return this.processLabelBackRef(processor, state);
        }
        SqlExpression qualifierExpression = this.getQualifierExpression();
        if (qualifierExpression == null || processor.suppressQualifier()) {
            return this.processUnqualifiedResolveVariants(processor, state);
        }
        if (qualifierExpression instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifierExpression, processor, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (!processor.getDialect().processQualifiedResolve(processor, state, (SqlReference)this, qualifierExpression)) {
            return false;
        }
        if (!SqlImplUtil.processDeclarationsInType(qualifierExpression, processor, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (this.myElement.getParent() instanceof SqlFunctionCallExpression && processor.isResultEmpty()) {
            return this.processFunctionVariants(processor);
        }
        return true;
    }

    public boolean processResolveVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(38);
        }
        if (!this.doProcessResolveVariants(processor)) {
            return false;
        }
        return ContainerUtil.process((Iterable)SqlResolveExtension.EP_NAME.getIterable(), it -> it.process(this, processor));
    }

    protected boolean processLabelBackRef(@NotNull SqlScopeProcessor processor, ResolveState state) {
        SqlElement labeled;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(39);
        }
        if ((labeled = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{SqlProcedureDefinitionImpl.class, SqlStatement.class})) == null) {
            return true;
        }
        if (labeled instanceof DasSymbol) {
            return processor.execute((DasSymbol)labeled, state);
        }
        for (SqlLabelDefinitionImpl def : SqlImplUtil.sqlChildren((PsiElement)labeled).takeWhile(c -> !(c instanceof SqlStatement)).filter(SqlLabelDefinitionImpl.class)) {
            if (processor.execute((DasSymbol)def, state)) continue;
            return false;
        }
        DasSymbol parentDef = (DasSymbol)ObjectUtils.tryCast((Object)labeled.getParent(), DasSymbol.class);
        return parentDef == null || processor.execute(parentDef, state);
    }

    public Set<ObjectKind> getExpectedTargetTypes(boolean forResolve, boolean strict) {
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = forResolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        return this.getExpectedTargetTypes(forResolve, SqlImplUtil.getSqlDialectSafe((PsiElement)containingFile), -1, maxLev, strict);
    }

    public boolean initExpectedTargetTypes(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(40);
        }
        boolean strict = this.resolveStrict();
        Set<ObjectKind> set = this.getExpectedTargetTypes(processor.getReferenceName() != null, strict);
        if (this.shouldNotBeChecked(set)) {
            return false;
        }
        processor.setExpectedKinds(set);
        processor.setStrict(strict);
        return true;
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes(boolean resolve) {
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = resolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        return this.getExpectedTargetTypes(resolve, this.getSqlDialect(), -1, maxLev, this.resolveStrict());
    }

    private boolean shouldNotBeChecked(@NotNull Set<ObjectKind> expectedTypes) {
        Dbms dbms;
        if (expectedTypes == null) {
            SqlReferenceImpl.$$$reportNull$$$0(41);
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement parent = this.myElement.getParent();
        if (expectedTypes.contains(ObjectKind.ROUTINE) && parent != null && parent.getParent() instanceof JdbcProcedureCall) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.OBJECT_TYPE) && parent instanceof SqlTypeElement && this.getQualifierExpression() == null && PsiTreeUtil.getDeepestFirst((PsiElement)this.myElement).getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED && ((dbms = dialect.getDbms()).isTransactSql() || dbms.isPostgres())) {
            String name = this.getReferenceName();
            return !dialect.shouldQuotedTypeReferenceBeChecked(name);
        }
        return false;
    }

    @Nullable
    private static SqlLanguageDialectEx.BuiltinFunctions getGlobalBuiltins(SqlLanguageDialect dialect) {
        SqlLanguageDialectEx.BuiltinFunctions builtins = dialect instanceof SqlLanguageDialectEx ? ((SqlLanguageDialectEx)dialect).getSupportedFunctions() : null;
        return builtins;
    }

    public SqlLanguageDialectEx.BuiltinFunctions getRelevantBuiltins(SqlLanguageDialect dialect) {
        boolean isInstance;
        String typeName;
        SqlLanguageDialectEx.BuiltinFunctions builtins = SqlReferenceImpl.getGlobalBuiltins(dialect);
        SqlExpression qualifier = this.getQualifier();
        if (qualifier != null) {
            DasSymbol symbol;
            DasType qualifyingDasType = qualifier.getDasType();
            typeName = qualifyingDasType == DasTypeSystemBase.UNKNOWN && qualifier instanceof SqlReferenceExpression ? ((symbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) != null ? symbol.getKind().name() : null) : qualifyingDasType.getDescription();
            isInstance = true;
        } else {
            DasType qualifyingType = SqlImplUtil.getScopingType(this.getElement());
            typeName = qualifyingType != null ? qualifyingType.getDescription() : null;
            isInstance = false;
        }
        if (builtins != null && typeName != null) {
            builtins = builtins.typeMethods(typeName, isInstance);
        }
        return builtins;
    }

    private boolean processFunctionVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(42);
        }
        SqlLanguageDialect dialect = processor.getDialect();
        if (processor.getReferenceName() == null || !this.shouldProcessFunctionVariants()) {
            return true;
        }
        SqlLanguageDialectEx.BuiltinFunctions builtins = this.getRelevantBuiltins(dialect);
        BuiltinFunction builtin = null;
        if (builtins != null) {
            builtin = builtins.get(this.getReferenceName());
        } else if (this.getQualifier() != null) {
            SqlLanguageDialectEx.BuiltinFunctions globalBuiltins = SqlReferenceImpl.getGlobalBuiltins(dialect);
            BuiltinFunction candidate = globalBuiltins != null ? globalBuiltins.get(this.getReferenceName()) : null;
            BuiltinFunction builtinFunction = builtin = candidate != null && candidate.getPostfixType() != null ? candidate : null;
        }
        return builtin == null || !SqlImplUtil.hasLocationOf(builtin, ((SqlLanguageDialectEx)dialect).getExpectedFunctionLocations((SqlExpression)ObjectUtils.tryCast((Object)this.myElement, SqlExpression.class))) || processor.executeTarget((DasSymbol)builtin, null, dialect.getDbms().isMysql() ? Boolean.valueOf(false) : null, ResolveState.initial());
    }

    private SqlLanguageDialectEx getSqlDialect() {
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this.myElement);
    }

    protected boolean shouldProcessFunctionVariants() {
        return false;
    }

    @NotNull
    public PsiFile getTopLevelSqlFile() {
        PsiFile psiFile = SqlImplUtil.getTopLevelSqlFile(this.myElement.getContainingFile());
        if (psiFile == null) {
            SqlReferenceImpl.$$$reportNull$$$0(43);
        }
        return psiFile;
    }

    @Nullable
    public SqlImportState getImportChecker() {
        PsiFile topContainingFile = this.getTopLevelSqlFile();
        PsiFile topOriginalFile = topContainingFile.getOriginalFile();
        return topOriginalFile instanceof SqlFile ? SqlDialectImplUtilCore.getImportCheckerAt((SqlFile)topOriginalFile, (PsiElement)this.myElement) : null;
    }

    public boolean processUnqualifiedResolveVariants(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(44);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(45);
        }
        if (!this.myElement.isValid()) {
            return true;
        }
        PsiFile topContainingFile = this.getTopLevelSqlFile();
        PsiFile topOriginalFile = topContainingFile.getOriginalFile();
        if (!processor.getDialect().processUnqualifiedResolve(processor, state, (PsiReference)this)) {
            return false;
        }
        PsiElement maxScope = SqlImplUtil.getResolveScope(topContainingFile);
        boolean callableExpected = processor.mayAccept(ObjectKind.ROUTINE);
        if (callableExpected && !this.processFunctionVariants(processor)) {
            return false;
        }
        if (!SqlImplUtil.treeWalkUp((DasScopeProcessor)processor, (PsiElement)this.myElement, maxScope, state)) {
            return false;
        }
        ObjectKind targetType = this.getReferenceElementType().getTargetKind();
        if (targetType == SqlDbElementType.LABEL && !processor.getDialect().getDbms().isMysql() && !this.processLabels(processor)) {
            return false;
        }
        if (targetType == ObjectKind.VARIABLE || targetType == SqlDbElementType.LABEL) {
            return true;
        }
        if (!(callableExpected || processor.getReferenceName() != null && !(this.myElement.getParent() instanceof SqlFunctionCallExpression) || this.processFunctionVariants(processor))) {
            return false;
        }
        if (Boolean.TRUE.equals(IGNORE_DATA_SOURCES.get((UserDataHolder)topOriginalFile))) {
            PsiElement context = topOriginalFile.getContext();
            if (context instanceof DbElement) {
                DbDataSource dataSource2 = ((DbElement)context).getDataSource();
                return this.processUnqualifiedResolveInDataSource(processor, state, topContainingFile, null, false, dataSource2);
            }
            return true;
        }
        SqlImportState importChecker = this.getImportChecker();
        boolean includeAllTopLevelNamespaces = processor.shouldIncludeAllNamespaces();
        Ref resolvesToLocalDataSource = Ref.create((Object)false);
        if (!SqlImplUtil.traverseDataSources(processor.getDataSources(), importChecker, dataSource -> {
            resolvesToLocalDataSource.set((Object)((Boolean)resolvesToLocalDataSource.get() != false || DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource) != null ? 1 : 0));
            return this.processUnqualifiedResolveInDataSource(processor, state, topContainingFile, importChecker, includeAllTopLevelNamespaces, (DbDataSource)dataSource);
        })) {
            return false;
        }
        if ((!((Boolean)resolvesToLocalDataSource.get()).booleanValue() || Boolean.TRUE.equals((Boolean)LOOK_AT_MINICAT.get((UserDataHolder)this.myElement.getContainingFile(), (Object)false) != false || processor.getDialect().getAdditionalExpandCondition(processor, (PsiElement)this.myElement) != null) && processor.isResultEmpty()) && !this.processMiniCatalog(processor, state, topContainingFile, importChecker, includeAllTopLevelNamespaces)) {
            return false;
        }
        return SqlReferenceImpl.processContextObject(processor, state, topOriginalFile);
    }

    private static boolean processContextObject(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiFile topOriginalFile) {
        DasObject context;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(46);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(47);
        }
        if ((context = SqlReferenceImpl.getContextObject(topOriginalFile)) == null) {
            return true;
        }
        DasObject parent = context.getDasParent();
        JBIterable objects = (parent == null ? JBIterable.of((Object)context) : DasUtil.dasParents((DasObject)parent).append((Iterable)parent.getDasChildren(null))).append((Iterable)context.getDasChildren(null));
        return SqlFileImpl.processCandidateObjects(processor, state, (JBIterable<DasObject>)objects, (Function<? super DasObject, ? extends DasSymbol>)((Function)o -> DasSymbolUtil.wrapObjectToSymbol(o, processor)));
    }

    @Nullable
    private static DasObject getContextObject(PsiFile topOriginalFile) {
        Supplier supplier = (Supplier)DatabaseDataKeysCore.CONTEXT_OBJECT_SUPPLIER_KEY.get((UserDataHolder)topOriginalFile);
        return supplier == null ? null : (DasObject)supplier.get();
    }

    public boolean processUnqualifiedResolveInDataSource(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiFile topContainingFile, SqlImportState importChecker, boolean includeAllTopLevelNamespaces, DbDataSource dataSource) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(48);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(49);
        }
        return this.processUnqualifiedResolveInDataSource(processor, state, topContainingFile, dataSource, ds -> {
            Condition<DasObject> condition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, (DasDataSource)ds.getDelegate(), includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
            return SqlFileImpl.processDeclarationsImpl(processor, state, (DasSymbol)dataSource, condition, true, (PsiElement)this.myElement);
        });
    }

    public boolean processUnqualifiedResolveInDataSource(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiFile topContainingFile, DbDataSource dataSource, @NotNull Predicate<DbDataSource> consumer) {
        RawDataSource d;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(50);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(51);
        }
        if (consumer == null) {
            SqlReferenceImpl.$$$reportNull$$$0(52);
        }
        if ((d = dataSource.getDelegate()) instanceof SqlDataSource) {
            SqlDataSource sqlDataSource = (SqlDataSource)d;
            if (!((Boolean)USE_SQL_DATA_SOURCE_MODEL.get((UserDataHolder)processor.getPlace(), (Object)false)).booleanValue()) {
                SqlFileImpl.GroupImpl root = (SqlFileImpl.GroupImpl)((Object)CachedValuesManager.getCachedValue((PsiElement)dataSource, () -> {
                    List files = sqlDataSource.getSqlFiles();
                    SqlFileImpl.GroupImpl res = SqlFileImpl.mergeRoots((JBIterable<SqlFile>)JBIterable.from((Iterable)files), (PsiElement)dataSource);
                    Object[] objectArray = new Object[2];
                    objectArray[0] = () -> ((SqlDataSource)sqlDataSource).getModelModificationCount();
                    objectArray[1] = () -> res != null && res.isValid() ? 0L : -1L;
                    return CachedValueProvider.Result.create((Object)((Object)res), (Object[])objectArray);
                }));
                if (root == null) {
                    return true;
                }
                SqlFile sqlFile = (SqlFile)ObjectUtils.tryCast((Object)topContainingFile, SqlFile.class);
                Condition<DasObject> importedCondition = sqlFile == null ? Conditions.alwaysTrue() : SqlFileImpl.importedCondition(SqlDialectImplUtilCore.getImportCheckerAt(sqlFile, (PsiElement)this.myElement), null, processor.shouldIncludeAllNamespaces());
                return SqlFileImpl.processDeclarationsImpl(processor, state, (DasSymbol)root, importedCondition, false, (PsiElement)this.myElement);
            }
        }
        return consumer.test(dataSource);
    }

    public boolean processMiniCatalog(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiFile topContainingFile, SqlImportState importChecker, boolean includeAllTopLevelNamespaces) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(53);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(54);
        }
        Condition expandCondition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, null, includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
        Condition dialectCondition = processor.getDialect().getAdditionalExpandCondition(processor, (PsiElement)this.myElement);
        Condition dialectFilter = processor.getDialect().getAdditionalExpandFilter(processor, (PsiElement)this.myElement);
        if (dialectCondition != null) {
            expandCondition = Conditions.or(expandCondition, (Condition)dialectCondition);
        }
        if (dialectFilter != null) {
            expandCondition = Conditions.and((Condition)expandCondition, (Condition)dialectFilter);
        }
        Project project = topContainingFile.getProject();
        Function mapper = o -> DasSymbolUtil.wrapObjectToSymbol(o, project);
        Dbms dbms = processor.getDialect().getDbms();
        if (processor.getReferenceName() != null) {
            ModelNameIndex miniCatIndex = DataSourceSnapshotManager.getInstance().getSnapshotModelIndex(dbms, Version.INFINITY);
            if (miniCatIndex == null) {
                return true;
            }
            return SqlFileImpl.processNameIndex(processor, state, miniCatIndex, (Condition<? super DasObject>)expandCondition, (Function<? super DasObject, ? extends DasSymbol>)mapper);
        }
        BasicModel miniCatModel = DataSourceSnapshotManager.getInstance().getSnapshotModel(dbms, Version.INFINITY, true);
        if (miniCatModel == null) {
            return true;
        }
        JBIterable candidates = ((JBTreeTraverser)miniCatModel.traverser().expand(expandCondition)).bfsTraversal();
        return SqlFileImpl.processCandidateObjects(processor, state, (JBIterable<DasObject>)candidates, (Function<? super DasObject, ? extends DasSymbol>)mapper);
    }

    private boolean processLabels(@NotNull SqlScopeProcessor processor) {
        SqlLabelHolder block;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(55);
        }
        if ((block = (SqlLabelHolder)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, SqlLabelHolder.class)) != null) {
            for (SqlDefinition label : block.getLabels()) {
                if (processor.execute((DasSymbol)label, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypes(boolean resolve, SqlLanguageDialectEx dialect, int minLev, int maxLev, boolean strict) {
        Set<ObjectKind> expectedStrict = this.getExpectedTargetTypesStrict(dialect);
        Dbms dbms = dialect.getDbms();
        if (dbms.isMicrosoft()) {
            SqlElement e = this.myElement;
            while (e instanceof SqlReferenceExpression) {
                e = e.getParent();
            }
            if (e instanceof SqlFunctionCallExpression) {
                e = e.getParent();
            }
            if (e instanceof SqlCallStatement) {
                Set<ObjectKind> set = expectedStrict;
                if (set == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(56);
                }
                return set;
            }
        }
        boolean addCallable = false;
        PsiElement parent = this.myElement.getParent();
        if (!strict && dbms.isPostgres() && parent instanceof SqlExpressionList && parent.getParent() instanceof SqlFunctionCallExpression && expectedStrict.contains(ObjectKind.COLUMN)) {
            expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
            expectedStrict.add(ObjectKind.TABLE);
        }
        if (!resolve && !strict && (expectedStrict.contains(ObjectKind.COLUMN) || expectedStrict.contains(ObjectKind.TABLE))) {
            PsiElement info = this.myElement.getNextSibling();
            while (info instanceof PsiWhiteSpace || info instanceof PsiComment) {
                info = info.getNextSibling();
            }
            boolean bl = addCallable = SqlInfoElementType.getValue(info, BuiltinFunction.ReferenceParameter.class) == null;
        }
        if (maxLev == 0) {
            if (addCallable) {
                expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
                expectedStrict.add(ObjectKind.ROUTINE);
            }
        } else {
            HashSet<ObjectKind> parents = new HashSet<ObjectKind>();
            if (addCallable) {
                parents.add(ObjectKind.ROUTINE);
            }
            for (ObjectKind type : expectedStrict) {
                this.getParentTypes(dialect, type, minLev, maxLev, parents);
            }
            expectedStrict = parents;
        }
        Set<ObjectKind> set = expectedStrict;
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(57);
        }
        return set;
    }

    @NotNull
    private static Set<ObjectKind> makeMutable(Set<ObjectKind> expectedStrict) {
        if (!(expectedStrict instanceof HashSet)) {
            expectedStrict = new HashSet<ObjectKind>(expectedStrict);
        }
        Set<ObjectKind> set = expectedStrict;
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(58);
        }
        return set;
    }

    private int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, Set<ObjectKind> result) {
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(59);
        }
        Set<ObjectKind> ignored = dialect.getIgnoredParentKinds((PsiElement)this.myElement, this.getReferenceElementType().getTargetKind());
        return SqlImplUtil.getParentTypes(dialect, type, minLevel, maxLevel, ignored, result);
    }

    @NotNull
    public Set<ObjectKind> getExpectedTargetTypesStrict(@NotNull SqlLanguageDialectEx dialect) {
        ObjectKind realLastRefType;
        ObjectKind thisTargetType;
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(60);
        }
        if ((thisTargetType = this.getReferenceElementType().getTargetKind()) != SqlDbElementType.ANY) {
            Set set = JBIterable.of((Object)thisTargetType).append(dialect.getExtraKindsStrict(this)).toSet();
            if (set == null) {
                SqlReferenceImpl.$$$reportNull$$$0(61);
            }
            return set;
        }
        SqlElement lastRefElement = this.myElement;
        SqlReferenceImpl lastRef = this;
        int inParentLevel = 0;
        int starCount = 0;
        boolean linkReached = false;
        PsiElement parent = this.myElement.getParent();
        while (parent instanceof SqlElement && parent.getReference() instanceof SqlReferenceImpl) {
            lastRefElement = (SqlElement)parent;
            lastRef = (SqlReferenceImpl)parent.getReference();
            if (!linkReached) {
                ++inParentLevel;
                if (Objects.equals("*", lastRef.getReferenceName())) {
                    ++starCount;
                }
            }
            linkReached |= TreeUtil.findSibling((ASTNode)lastRefElement.getNode(), (IElementType)SqlCompositeElementTypes.SQL_GENERIC_AT_REFERENCE) != null;
            parent = parent.getParent();
        }
        ObjectKind lastRefType = lastRef != this ? lastRef.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
        ObjectKind objectKind = realLastRefType = lastRefType != SqlDbElementType.ANY || !(parent instanceof SqlCompositeElementImpl) ? lastRefType : ((SqlCompositeElementImpl)parent).getExpectedReferenceTargetType(lastRefElement);
        if (lastRefType != SqlDbElementType.ANY) {
            HashSet<ObjectKind> curType = new HashSet<ObjectKind>();
            this.getParentTypes(dialect, realLastRefType, inParentLevel - starCount, inParentLevel, curType);
            for (ObjectKind extraKind : dialect.getExtraKindsStrict(lastRef)) {
                this.getParentTypes(dialect, extraKind, inParentLevel - starCount, inParentLevel, curType);
            }
            HashSet<ObjectKind> hashSet = curType;
            if (hashSet == null) {
                SqlReferenceImpl.$$$reportNull$$$0(62);
            }
            return hashSet;
        }
        Set<ObjectKind> set = Collections.singleton(SqlDbElementType.ANY);
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(63);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlReferenceImpl that = (SqlReferenceImpl)o;
        return this.myElement.equals((Object)that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private /* synthetic */ void lambda$resolveInner$9(Set resultFake, SqlLanguageDialectEx dialect, OrderedSet result, DasSymbol symbol, ResolveState state, SqlScopeProcessor p2) {
        PsiElement psi = DasSymbolUtil.getSinglePsiSource(symbol);
        if (psi == null) {
            psi = this.myElement;
        }
        SqlResolveResultImpl newResult = new SqlResolveResultImpl(SqlImplUtil.getQualifier(state), SqlImplUtil.getImmediateTarget(state), SqlImplUtil.getImmediateQualifier(state), psi, symbol);
        if (symbol instanceof SqlFileImpl.GroupImpl) {
            resultFake.add(newResult);
            return;
        }
        SqlResolveResult currentResult = null;
        ResolveConflictPolicy preference = dialect.shouldHide(symbol, (PsiElement)this.myElement) ? ResolveConflictPolicy.HIDE_NEW : ((currentResult = SqlReferenceImpl.findConflictingResult((Set<SqlResolveResult>)result, psi, dialect)) != null ? SqlReferenceImpl.getPreference(currentResult, newResult, dialect) : ResolveConflictPolicy.KEEP_BOTH);
        switch (preference.ordinal()) {
            case 0: {
                result.remove((Object)currentResult);
                result.add((Object)newResult);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                result.add((Object)newResult.hide());
                break;
            }
            case 3: {
                result.add((Object)newResult);
            }
        }
        dialect.addExtraResolveTargets(p2, state, this, symbol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 43, 56, 57, 58, 61, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 13: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 16: 
            case 19: 
            case 36: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentResult";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResult";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeInner";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreference";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSqlFile";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypes";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutable";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createResolveProcessor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findConflictingResult";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPreference";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sortBySearchPath";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findInSearchPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doProcessResolveVariants";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processLabelBackRef";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "initExpectedTargetTypes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "shouldNotBeChecked";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionVariants";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveVariants";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processContextObject";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveInDataSource";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processMiniCatalog";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processLabels";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 43, 56, 57, 58, 61, 62, 63 -> new IllegalStateException(string);
        };
    }

    private static enum ResolveConflictPolicy {
        DROP_EXISTING,
        DROP_NEW,
        HIDE_NEW,
        KEEP_BOTH;

    }
}

