/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssPsiColorUtilsCommon;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorPickerListenerFactory;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssColorUtil {
    @NotNull
    public static String formatHexColorAccordingToCodeStyle(@NotNull String colorString, @NotNull PsiElement context) {
        Language language;
        CssSupportedFileTypesProvider provider;
        if (colorString == null) {
            CssColorUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssColorUtil.$$$reportNull$$$0(1);
        }
        CssSupportedFileTypesProvider cssSupportedFileTypesProvider = provider = (language = CssPsiUtilCore.getStylesheetLanguage((PsiElement)context)) == null ? null : CssSupportedFileTypesProvider.findProvider((Language)language);
        if (provider == null) {
            String string = colorString;
            if (string == null) {
                CssColorUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        CssCodeStyleSettings cssCodeStyleSettings = (CssCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), (Class)provider.getCustomCodeStyleSettingsClass());
        String newColorText = colorString;
        if (cssCodeStyleSettings.HEX_COLOR_LONG_FORMAT && colorString.length() == 4) {
            newColorText = CssPsiColorUtilsCommon.Companion.normalizeHexColor(colorString);
        } else if (cssCodeStyleSettings.HEX_COLOR_SHORT_FORMAT && colorString.length() == 7) {
            newColorText = CssPsiColorUtilsCommon.Companion.toShortHexColor(colorString);
        }
        if (cssCodeStyleSettings.HEX_COLOR_UPPER_CASE) {
            newColorText = StringUtil.toUpperCase((String)newColorText);
        } else if (cssCodeStyleSettings.HEX_COLOR_LOWER_CASE) {
            newColorText = StringUtil.toLowerCase((String)newColorText);
        }
        String string = newColorText;
        if (string == null) {
            CssColorUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void changeColorWithPicker(@Nullable Editor editor, @NotNull Color color, @NotNull ColorDeclarationType type, @Nullable PsiElement element) {
        if (color == null) {
            CssColorUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            CssColorUtil.$$$reportNull$$$0(5);
        }
        if (editor == null || element == null || !element.isValid()) {
            return;
        }
        List listeners = ColorPickerListenerFactory.createListenersFor((PsiElement)element);
        Project project = editor.getProject();
        if (Registry.is((String)"ide.new.color.picker")) {
            Ref psi = Ref.create((Object)element);
            ColorChooserService.getInstance().showPopup(project, color, editor, (c, l) -> psi.set((Object)CssColorUtil.changeColor(editor, CssPsiColorUtil.convertTo(type, c), (PsiElement)psi.get())), true, true);
        } else {
            Color newColor = ColorChooserService.getInstance().showDialog(project, (Component)editor.getComponent(), CssBundle.message((String)"css.choose.color.dialog.title", (Object[])new Object[0]), color, true, listeners, true);
            if (newColor != null) {
                CssColorUtil.changeColor(editor, CssPsiColorUtil.convertTo(type, newColor), element);
            }
        }
    }

    private static PsiElement changeColor(@NotNull Editor editor, @NotNull String hexColor, @Nullable PsiElement element) {
        if (editor == null) {
            CssColorUtil.$$$reportNull$$$0(6);
        }
        if (hexColor == null) {
            CssColorUtil.$$$reportNull$$$0(7);
        }
        if (element != null && element.isValid()) {
            Project project = element.getProject();
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element);
            WriteCommandAction.runWriteCommandAction((Project)project, (String)CssBundle.message((String)"command.name.update.css.color", (Object[])new Object[0]), null, () -> {
                if (project.isDisposed() || editor.isDisposed()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                if (!element.isValid()) {
                    return;
                }
                CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
                CssTermList termList = elementFactory.createPropertyValue(hexColor, CssPsiUtilCore.getStylesheetLanguage((PsiElement)element));
                if (element instanceof CssTermList) {
                    element.replace((PsiElement)termList);
                } else if (element instanceof CssTerm) {
                    element.replace(termList.getFirstChild());
                } else {
                    PsiElement term = termList.getFirstChild();
                    element.replace(term.getFirstChild());
                }
            }, (PsiFile[])new PsiFile[]{element.getContainingFile()});
            return pointer.getElement();
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssColorUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hexColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssColorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHexColorAccordingToCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatHexColorAccordingToCodeStyle";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeColorWithPicker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

