/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.text;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.text.Hyperlink;
import org.jetbrains.letsPlot.core.plot.base.render.text.RenderState;
import org.jetbrains.letsPlot.core.plot.base.render.text.RichText;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Hyperlink;", "", "()V", "anchorTagRegex", "Lkotlin/text/Regex;", "parse", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "text", "", "HyperlinkElement", "plot-base"})
public final class Hyperlink {
    @NotNull
    public static final Hyperlink INSTANCE = new Hyperlink();
    @NotNull
    private static final Regex anchorTagRegex = new Regex("<a\\s+[^>]*href=\"(?<href>[^\"]*)\"[^>]*>(?<text>[^<]*)</a>");

    private Hyperlink() {
    }

    @NotNull
    public final List<RichText.RichTextNode> parse(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List links2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)anchorTagRegex, (CharSequence)text2, (int)0, (int)2, null), (Function1)parse.links.1.INSTANCE));
        return RichText.INSTANCE.fillTextTermGaps$plot_base(text2, links2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Hyperlink$HyperlinkElement;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "text", "", "href", "(Ljava/lang/String;Ljava/lang/String;)V", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "plot-base"})
    public static final class HyperlinkElement
    implements RichText.RichTextNode.Span {
        @NotNull
        private final String text;
        @NotNull
        private final String href;
        private final int visualCharCount;

        public HyperlinkElement(@NotNull String text2, @NotNull String href2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)href2, (String)"href");
            this.text = text2;
            this.href = href2;
            this.visualCharCount = this.text.length();
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return ((Number)widthCalculator.invoke((Object)this.text, (Object)font)).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            void $this$render_u24lambda_u241_u24lambda_u240;
            SvgTSpanElement svgTSpanElement;
            SvgAElement svgAElement;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SvgAElement $this$render_u24lambda_u241 = svgAElement = new SvgAElement();
            boolean bl = false;
            $this$render_u24lambda_u241.href().set(this.href);
            $this$render_u24lambda_u241.xlinkHref().set(this.href);
            SvgTSpanElement svgTSpanElement2 = svgTSpanElement = new SvgTSpanElement(this.text);
            ObservableList<SvgNode> observableList = $this$render_u24lambda_u241.children();
            boolean bl2 = false;
            $this$render_u24lambda_u241_u24lambda_u240.addClass("hyperlink-element");
            observableList.add(svgTSpanElement);
            return CollectionsKt.listOf((Object)svgAElement);
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }
    }
}

