/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormatUtil;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.time.interval.NiceTimeInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.BreaksHelperBase;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DummyBreaksFormatterKt;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.LinearBreaksHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/DateTimeBreaksHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "providedFormatter", "Lkotlin/Function1;", "", "", "minInterval", "Lorg/jetbrains/letsPlot/core/commons/time/interval/NiceTimeInterval;", "maxInterval", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(DDILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/core/commons/time/interval/NiceTimeInterval;Lorg/jetbrains/letsPlot/core/commons/time/interval/NiceTimeInterval;Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "pattern", "getPattern", "()Ljava/lang/String;", "timeZone", "getTimeZone", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "plot-base"})
public final class DateTimeBreaksHelper
extends BreaksHelperBase {
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @Nullable
    private final TimeZone tz;
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;
    @NotNull
    private final String pattern;

    public DateTimeBreaksHelper(double rangeStart, double rangeEnd, int count2, @Nullable Function1<Object, String> providedFormatter, @Nullable NiceTimeInterval minInterval, @Nullable NiceTimeInterval maxInterval, @Nullable TimeZone tz) {
        super(rangeStart, rangeEnd, count2);
        Function1<Object, String> function1;
        String string;
        this.providedFormatter = providedFormatter;
        this.tz = tz;
        double step2 = this.getTargetStep();
        DateTimeBreaksHelper dateTimeBreaksHelper = this;
        if (step2 < 1000.0) {
            this.breaks = new LinearBreaksHelper(rangeStart, rangeEnd, count2, DummyBreaksFormatterKt.getDUMMY_FORMATTER(), StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT(), false, 32, null).getBreaks();
            string = minInterval != null ? minInterval.getTickFormatPattern() : TimeInterval.Companion.milliseconds(1).getTickFormatPattern();
        } else {
            String pattern2;
            String string2;
            double start2 = this.getNormalStart();
            double end = this.getNormalEnd();
            List ticks = null;
            if (minInterval != null) {
                ticks = CollectionsKt.toMutableList((Collection)minInterval.range(start2, end, this.tz));
            }
            if (ticks != null && ticks.size() <= count2) {
                Intrinsics.checkNotNull((Object)minInterval, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval");
                string2 = ((TimeInterval)minInterval).getTickFormatPattern();
            } else if (step2 > 3.1536E10) {
                int startYear;
                ticks = new ArrayList();
                DateTime startDateTime = DateTime.Companion.ofEpochMilliseconds(start2, this.getTimeZone());
                if (startDateTime.compareTo(DateTime.Companion.ofYearStart(startYear = startDateTime.getYear())) > 0) {
                    ++startYear;
                }
                int endYear = DateTime.Companion.ofEpochMilliseconds(end, this.getTimeZone()).getYear();
                double d = startYear;
                double d2 = endYear;
                StringFormat.ExponentFormat exponentFormat = StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT();
                Function1<Object, String> function12 = DummyBreaksFormatterKt.getDUMMY_FORMATTER();
                LinearBreaksHelper helper2 = new LinearBreaksHelper(d, d2, count2, function12, exponentFormat, false, 32, null);
                Iterator<Double> iterator2 = helper2.getBreaks().iterator();
                DateTimeBreaksHelper dateTimeBreaksHelper2 = dateTimeBreaksHelper;
                while (iterator2.hasNext()) {
                    double tickYear = ((Number)iterator2.next()).doubleValue();
                    DateTime tickDate = DateTime.Companion.ofYearStart((int)Math.rint(tickYear));
                    ((ArrayList)ticks).add(Double.valueOf(tickDate.toEpochMilliseconds(this.getTimeZone())));
                }
                dateTimeBreaksHelper = dateTimeBreaksHelper2;
                string2 = maxInterval != null ? ((TimeInterval)maxInterval).getTickFormatPattern() : "%Y";
            } else {
                NiceTimeInterval interval = NiceTimeInterval.Companion.forMillis(step2, minInterval, maxInterval);
                ticks = CollectionsKt.toMutableList((Collection)interval.range(start2, end, this.tz));
                string2 = pattern2 = interval.getTickFormatPattern();
            }
            if (this.isReversed()) {
                CollectionsKt.reverse((List)ticks);
            }
            this.breaks = ticks;
            string = dateTimeBreaksHelper.pattern = pattern2;
        }
        if ((function1 = this.providedFormatter) == null) {
            function1 = DateTimeFormatUtil.INSTANCE.createInstantFormatter(this.pattern, this.getTimeZone());
        }
        this.formatter = function1;
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    private final TimeZone getTimeZone() {
        TimeZone timeZone = this.tz;
        if (timeZone == null) {
            timeZone = TimeZone.Companion.getUTC();
        }
        return timeZone;
    }
}

