/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.IdeaInstallationLibrary;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a0\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u001a,\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\fH\u0002\"2\u0010\u0015\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\n0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"notifyLibraryIfNeeded", "", "library", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "ideaHome", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "sortOutJars", "Lkotlin/Pair;", "", "detectMavenArtifactByJars", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "ideaJars", "notifyLibrary", "details", "", "fix", "Lcom/intellij/notification/NotificationAction;", "convertToRepositoryLibraryAction", "artifact", "knownIdeaLibraries", "", "Lcom/intellij/codeInsight/daemon/impl/IdeaInstallationLibrary;", "kotlin.jvm.PlatformType", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nIdeaLibDependencyNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaLibDependencyNotifier.kt\ncom/intellij/codeInsight/daemon/impl/IdeaLibDependencyNotifierKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1342#2,2:190\n1342#2,2:202\n1586#3:192\n1661#3,3:193\n1807#3,3:196\n1786#3,3:199\n1#4:204\n*S KotlinDebug\n*F\n+ 1 IdeaLibDependencyNotifier.kt\ncom/intellij/codeInsight/daemon/impl/IdeaLibDependencyNotifierKt\n*L\n90#1:190,2\n162#1:202,2\n103#1:192\n103#1:193,3\n105#1:196,3\n109#1:199,3\n*E\n"})
public final class IdeaLibDependencyNotifierKt {
    private static final List<IdeaInstallationLibrary> knownIdeaLibraries;

    private static final void notifyLibraryIfNeeded(LibraryEntity library, Path ideaHome, Project project2) {
        Pair<List<Path>, List<Path>> pair = IdeaLibDependencyNotifierKt.sortOutJars(library, ideaHome);
        List ideaJars = (List)pair.component1();
        List nonIdeaJars = (List)pair.component2();
        if (ideaJars.isEmpty()) {
            return;
        }
        if (nonIdeaJars.isEmpty()) {
            JpsMavenRepositoryLibraryDescriptor artifact = IdeaLibDependencyNotifierKt.detectMavenArtifactByJars(ideaJars);
            if (artifact == null) {
                String string = JavaUiBundle.message("library.depends.on.ide.message.replacement.not.found", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                IdeaLibDependencyNotifierKt.notifyLibrary$default(library, string, project2, null, 8, null);
            } else {
                Object[] objectArray = new Object[]{artifact.getMavenId()};
                String string = JavaUiBundle.message("library.depends.on.ide.message.can.be.replaced", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                IdeaLibDependencyNotifierKt.notifyLibrary(library, string, project2, IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction(project2, library, artifact));
            }
        } else {
            String string = JavaUiBundle.message("library.depends.on.ide.message.jar.mixture", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            IdeaLibDependencyNotifierKt.notifyLibrary$default(library, string, project2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<List<Path>, List<Path>> sortOutJars(LibraryEntity library, Path ideaHome) {
        void $this$forEach$iv;
        ArrayList<Path> ideaJars = new ArrayList<Path>();
        ArrayList<Path> nonIdeaJars = new ArrayList<Path>();
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)library.getRoots()), IdeaLibDependencyNotifierKt::sortOutJars$lambda$0), IdeaLibDependencyNotifierKt::sortOutJars$lambda$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            boolean bl2 = path.startsWith(ideaHome) ? ideaJars.add(path) : nonIdeaJars.add(path);
        }
        return new Pair(ideaJars, nonIdeaJars);
    }

    /*
     * WARNING - void declaration
     */
    private static final JpsMavenRepositoryLibraryDescriptor detectMavenArtifactByJars(List<? extends Path> ideaJars) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ideaJars;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = PathsKt.getName((Path)it).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        List jarNames = (List)destination$iv$iv;
        for (IdeaInstallationLibrary lib : knownIdeaLibraries) {
            boolean bl;
            block10: {
                String it;
                boolean bl2;
                block9: {
                    Iterable $this$any$iv = jarNames;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)lib.getMarkerJarName(), (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                Iterable $this$all$iv = jarNames;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        if (lib.withinAssociates(it)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return lib.getMavenSubstituteId();
            }
            return null;
        }
        return null;
    }

    private static final void notifyLibrary(LibraryEntity library, String details, Project project2, NotificationAction fix) {
        if (fix == null) {
            return;
        }
        Object[] objectArray = new Object[]{library.getName(), details};
        Notification notification = new Notification("Legacy Library", JavaUiBundle.message("library.depends.on.ide.title", new Object[0]), JavaUiBundle.message("library.depends.on.ide.message", objectArray), NotificationType.WARNING);
        notification.addAction((AnAction)fix);
        Notifications.Bus.notify((Notification)notification, (Project)project2);
    }

    static /* synthetic */ void notifyLibrary$default(LibraryEntity libraryEntity, String string, Project project2, NotificationAction notificationAction, int n, Object object) {
        if ((n & 8) != 0) {
            notificationAction = null;
        }
        IdeaLibDependencyNotifierKt.notifyLibrary(libraryEntity, string, project2, notificationAction);
    }

    private static final NotificationAction convertToRepositoryLibraryAction(Project project2, LibraryEntity library, JpsMavenRepositoryLibraryDescriptor artifact) {
        Object[] objectArray = new Object[]{library.getName()};
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)JavaUiBundle.message("library.depends.on.ide.fix.convert.to.repo", objectArray), () -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0(project2, artifact, library));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        return notificationAction;
    }

    private static final boolean sortOutJars$lambda$0(LibraryRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED());
    }

    private static final Path sortOutJars$lambda$1(LibraryRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)root.getUrl());
    }

    private static final Unit convertToRepositoryLibraryAction$lambda$0$0$0$0$0(JpsMavenRepositoryLibraryDescriptor $artifact, LibraryPropertiesEntityBuilder $this$LibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$LibraryPropertiesEntity, (String)"$this$LibraryPropertiesEntity");
        $this$LibraryPropertiesEntity.setPropertiesXmlTag("<properties maven-id=\"" + $artifact.getMavenId() + "\" />");
        return Unit.INSTANCE;
    }

    private static final VirtualFileUrl convertToRepositoryLibraryAction$lambda$0$0$0$0$1(VirtualFileUrlManager $urlManager, String urlString) {
        Intrinsics.checkNotNull((Object)urlString);
        return $urlManager.getOrCreateFromUrl(urlString);
    }

    private static final LibraryRoot convertToRepositoryLibraryAction$lambda$0$0$0$0$2(VirtualFileUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new LibraryRoot(url, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit convertToRepositoryLibraryAction$lambda$0$0$0$0(LibraryEntity $library, WorkspaceModel $workspaceModel, NewLibraryEditor $libraryEditor, JpsMavenRepositoryLibraryDescriptor $artifact, LibraryEntityBuilder $this$LibraryEntity) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$LibraryEntity, (String)"$this$LibraryEntity");
        $this$LibraryEntity.setTypeId(RepositoryLibraryType.LIBRARY_TYPE_ID);
        LibraryEntityModifications.setLibraryProperties((LibraryEntityBuilder)$this$LibraryEntity, (LibraryPropertiesEntityBuilder)LibraryPropertiesEntityModifications.createLibraryPropertiesEntity((EntitySource)$library.getEntitySource(), arg_0 -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0$0$0$0$0($artifact, arg_0)));
        VirtualFileUrlManager urlManager = $workspaceModel.getVirtualFileUrlManager();
        String[] stringArray = $libraryEditor.getUrls(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])stringArray), arg_0 -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0$0$0$0$1(urlManager, arg_0)), IdeaLibDependencyNotifierKt::convertToRepositoryLibraryAction$lambda$0$0$0$0$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryRoot root = (LibraryRoot)element$iv;
            boolean bl = false;
            $this$LibraryEntity.getRoots().add(root);
        }
        return Unit.INSTANCE;
    }

    private static final Unit convertToRepositoryLibraryAction$lambda$0$0$0(NewLibraryConfiguration $newLibraryConfig, LibraryEntity $library, WorkspaceModel $workspaceModel, JpsMavenRepositoryLibraryDescriptor $artifact, MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        NewLibraryEditor libraryEditor = new NewLibraryEditor();
        NewLibraryConfiguration newLibraryConfiguration = $newLibraryConfig;
        if (newLibraryConfiguration != null) {
            newLibraryConfiguration.addRoots((LibraryEditor)libraryEditor);
        }
        String string = $library.getName();
        LibraryTableId libraryTableId = $library.getTableId();
        List list2 = List.of();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"of(...)");
        LibraryEntityBuilder newLibrary = LibraryEntityModifications.createLibraryEntity((String)string, (LibraryTableId)libraryTableId, list2, (EntitySource)$library.getEntitySource(), arg_0 -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0$0$0$0($library, $workspaceModel, libraryEditor, $artifact, arg_0));
        LibraryEntity libraryEntity = (LibraryEntity)builder.resolve((SymbolicEntityId)$library.getSymbolicId());
        if (libraryEntity != null) {
            WorkspaceEntity p0 = (WorkspaceEntity)libraryEntity;
            boolean bl = false;
            builder.removeEntity(p0);
        }
        builder.addEntity((WorkspaceEntity.Builder)newLibrary);
        return Unit.INSTANCE;
    }

    private static final void convertToRepositoryLibraryAction$lambda$0$0(Project $project, LibraryEntity $library, NewLibraryConfiguration $newLibraryConfig, JpsMavenRepositoryLibraryDescriptor $artifact) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance($project);
        workspaceModel.updateProjectModel("Converting library '" + $library.getName() + "' to repository type", arg_0 -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0$0$0($newLibraryConfig, $library, workspaceModel, $artifact, arg_0));
    }

    private static final void convertToRepositoryLibraryAction$lambda$0(Project $project, JpsMavenRepositoryLibraryDescriptor $artifact, LibraryEntity $library) {
        NewLibraryConfiguration newLibraryConfig = JarRepositoryManager.resolveAndDownload($project, $artifact, SetsKt.setOf((Object)ArtifactKind.ARTIFACT), null, null);
        WriteAction.run(() -> IdeaLibDependencyNotifierKt.convertToRepositoryLibraryAction$lambda$0$0($project, $library, newLibraryConfig, $artifact));
        $project.scheduleSave();
    }

    public static final /* synthetic */ void access$notifyLibraryIfNeeded(LibraryEntity library, Path ideaHome, Project project2) {
        IdeaLibDependencyNotifierKt.notifyLibraryIfNeeded(library, ideaHome, project2);
    }

    static {
        Object[] objectArray = new String[]{"junit", "hamcrest"};
        IdeaInstallationLibrary ideaInstallationLibrary = new IdeaInstallationLibrary("junit4", CollectionsKt.listOf((Object[])objectArray), new JpsMavenRepositoryLibraryDescriptor("junit:junit:4.13.1"));
        objectArray = new String[]{"junit", "hamcrest"};
        knownIdeaLibraries = List.of(ideaInstallationLibrary, new IdeaInstallationLibrary("junit-4", CollectionsKt.listOf((Object[])objectArray), new JpsMavenRepositoryLibraryDescriptor("junit:junit:4.13.1")), new IdeaInstallationLibrary("junit.jar", CollectionsKt.listOf((Object)"junit"), new JpsMavenRepositoryLibraryDescriptor("junit:junit:3.8.2")));
    }
}

