/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTreeModel {
    private static final Logger LOG = Logger.getInstance(FacetTreeModel.class);
    private static final FacetInfo ROOT = new FacetInfo(null, "", null, null);
    private final List<FacetInfo> myFacetInfos = new ArrayList<FacetInfo>();
    private final BidirectionalMap<FacetInfo, FacetInfo> myParents = new BidirectionalMap();

    public void addFacetInfo(FacetInfo info) {
        this.myFacetInfos.add(info);
        this.myParents.put((Object)info, (Object)FacetTreeModel.null2Root(info.getUnderlyingFacet()));
    }

    @NotNull
    private static FacetInfo null2Root(@Nullable FacetInfo info) {
        FacetInfo facetInfo = info == null ? ROOT : info;
        if (facetInfo == null) {
            FacetTreeModel.$$$reportNull$$$0(0);
        }
        return facetInfo;
    }

    @Nullable
    private static FacetInfo root2Null(@NotNull FacetInfo info) {
        if (info == null) {
            FacetTreeModel.$$$reportNull$$$0(1);
        }
        return info == ROOT ? null : info;
    }

    public FacetInfo[] getFacetInfos() {
        return this.myFacetInfos.toArray(FacetInfo.EMPTY_ARRAY);
    }

    public void removeFacetInfo(@NotNull FacetInfo info) {
        if (info == null) {
            FacetTreeModel.$$$reportNull$$$0(2);
        }
        boolean removed = this.myFacetInfos.remove(info);
        LOG.assertTrue(removed);
        this.myParents.remove((Object)info);
    }

    @Nullable
    public FacetInfo getParent(@NotNull FacetInfo info) {
        if (info == null) {
            FacetTreeModel.$$$reportNull$$$0(3);
        }
        return FacetTreeModel.root2Null((FacetInfo)this.myParents.get((Object)info));
    }

    @NotNull
    public List<FacetInfo> getChildren(@Nullable FacetInfo info) {
        List list2 = this.myParents.getKeysByValue((Object)FacetTreeModel.null2Root(info));
        if (list2 == null) {
            List<FacetInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                FacetTreeModel.$$$reportNull$$$0(4);
            }
            return list3;
        }
        List<FacetInfo> list4 = Collections.unmodifiableList(list2);
        if (list4 == null) {
            FacetTreeModel.$$$reportNull$$$0(5);
        }
        return list4;
    }

    public List<FacetInfo> getTopLevelFacets() {
        return this.getChildren(null);
    }

    @Nullable
    public FacetInfo findNearestFacet(@NotNull FacetInfo info) {
        FacetInfo parent;
        List<FacetInfo> children;
        int index;
        if (info == null) {
            FacetTreeModel.$$$reportNull$$$0(6);
        }
        if ((index = (children = this.getChildren(parent = this.getParent(info))).indexOf(info)) < children.size() - 1) {
            return children.get(index + 1);
        }
        if (index > 0) {
            return children.get(index - 1);
        }
        return parent;
    }

    public boolean hasFacetOfType(@Nullable FacetInfo parent, FacetTypeId typeId) {
        List<FacetInfo> list2 = this.getChildren(parent);
        for (FacetInfo info : list2) {
            if (info.getFacetType().getId() != typeId) continue;
            return true;
        }
        return false;
    }

    public Collection<FacetInfo> getFacetInfos(FacetType<?, ?> type) {
        FacetInfo[] facetInfos = this.getFacetInfos();
        ArrayList<FacetInfo> infos = new ArrayList<FacetInfo>();
        for (FacetInfo facetInfo : facetInfos) {
            if (!facetInfo.getFacetType().equals(type)) continue;
            infos.add(facetInfo);
        }
        return infos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/FacetTreeModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "null2Root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetTreeModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "root2Null";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeFacetInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNearestFacet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6 -> new IllegalArgumentException(string);
        };
    }
}

