/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.impl.AddSupportForSingleFrameworkDialog;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFrameworkSupportInProjectStructureAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AddFrameworkSupportInProjectStructureAction.class);
    private final FrameworkTypeEx myFrameworkType;
    private final FrameworkSupportInModuleProvider myProvider;
    @NotNull
    private final ModuleStructureConfigurable myModuleStructureConfigurable;

    public AddFrameworkSupportInProjectStructureAction(@NotNull FrameworkTypeEx frameworkType, @NotNull FrameworkSupportInModuleProvider provider, @NotNull ModuleStructureConfigurable moduleStructureConfigurable) {
        if (frameworkType == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(1);
        }
        if (moduleStructureConfigurable == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(2);
        }
        super(frameworkType.getPresentableName(), JavaUiBundle.message("action.description.add.0.support", frameworkType.getPresentableName()), frameworkType.getIcon());
        this.myFrameworkType = frameworkType;
        this.myProvider = provider;
        this.myModuleStructureConfigurable = moduleStructureConfigurable;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setVisible(this.isVisible(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    private boolean isVisible(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(5);
        }
        if ((module = AddFrameworkSupportInProjectStructureAction.getSelectedModule(e)) == null || !this.myProvider.isEnabledForModuleType(ModuleType.get((Module)module))) {
            return false;
        }
        ProjectFacetsConfigurator facetsProvider = this.myModuleStructureConfigurable.getFacetConfigurator();
        if (!this.myProvider.canAddSupport(module, facetsProvider)) {
            return false;
        }
        String underlyingFrameworkTypeId = this.myFrameworkType.getUnderlyingFrameworkTypeId();
        if (underlyingFrameworkTypeId == null) {
            return true;
        }
        FrameworkSupportInModuleProvider underlyingProvider = FrameworkSupportUtil.findProvider(underlyingFrameworkTypeId, FrameworkSupportUtil.getAllProviders());
        if (underlyingProvider == null) {
            LOG.error("framework not found by id " + underlyingFrameworkTypeId);
            return false;
        }
        return underlyingProvider.isSupportAlreadyAdded(module, facetsProvider);
    }

    @Nullable
    private static Module getSelectedModule(@NotNull AnActionEvent e) {
        Object selected;
        if (e == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(6);
        }
        if ((selected = e.getData(PlatformCoreDataKeys.SELECTED_ITEM)) instanceof Module) {
            return (Module)selected;
        }
        if (selected instanceof Facet) {
            return ((Facet)selected).getModule();
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            AddFrameworkSupportInProjectStructureAction.$$$reportNull$$$0(7);
        }
        if ((module = AddFrameworkSupportInProjectStructureAction.getSelectedModule(e)) == null) {
            return;
        }
        LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer(this.myModuleStructureConfigurable.getContext());
        new AddSupportForSingleFrameworkDialog(module, this.myFrameworkType, this.myProvider, librariesContainer, new IdeaModifiableModelsProvider()).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStructureConfigurable";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/addSupport/impl/AddFrameworkSupportInProjectStructureAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/addSupport/impl/AddFrameworkSupportInProjectStructureAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

