/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.CreateLibraryFromFilesDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MarkLibraryRootAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            MarkLibraryRootAction.$$$reportNull$$$0(0);
        }
        if ((project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        List<VirtualFile> jars = MarkLibraryRootAction.getRoots(e);
        if (jars.isEmpty()) {
            return;
        }
        List roots = RootDetectionUtil.detectRoots(jars, null, (Project)project2, (LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor());
        new CreateLibraryFromFilesDialog(project2, roots).show();
    }

    @NotNull
    private static List<VirtualFile> getRoots(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkLibraryRootAction.$$$reportNull$$$0(1);
        }
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null || files == null || files.length == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MarkLibraryRootAction.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                roots.add(file);
                continue;
            }
            VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
            if (root == null) continue;
            roots.add(root);
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            MarkLibraryRootAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkLibraryRootAction.$$$reportNull$$$0(4);
        }
        Project project2 = MarkLibraryRootAction.getEventProject((AnActionEvent)e);
        boolean visible = false;
        if (project2 != null && ModuleManager.getInstance((Project)project2).getModules().length > 0) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            block0: for (VirtualFile root : MarkLibraryRootAction.getRoots(e)) {
                if (!root.isInLocalFileSystem() && FileUtilRt.extensionEquals((String)root.getName(), (String)"jar") && !fileIndex.isInLibraryClasses(root)) {
                    visible = true;
                    break;
                }
                if (!root.isInLocalFileSystem() || !root.isDirectory()) continue;
                for (VirtualFile child : root.getChildren()) {
                    VirtualFile jarRoot;
                    if (!FileUtilRt.extensionEquals((String)child.getName(), (String)"jar") || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child)) == null || fileIndex.isInLibraryClasses(child)) continue;
                    visible = true;
                    continue block0;
                }
            }
        }
        e.getPresentation().setEnabledAndVisible(visible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MarkLibraryRootAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/actions/MarkLibraryRootAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/actions/MarkLibraryRootAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

