/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.Library;
import com.intellij.ide.starters.local.LibraryCategory;
import com.intellij.ide.starters.local.Starter;
import com.intellij.ide.starters.local.StarterContext;
import com.intellij.ide.starters.local.StarterContextProvider;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.local.StarterPack;
import com.intellij.ide.starters.local.wizard.StarterLibrariesStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.LibraryInfo;
import com.intellij.ide.starters.shared.StarterWizardSettings;
import com.intellij.ide.starters.shared.ui.LibraryDescriptionPanel;
import com.intellij.ide.starters.shared.ui.SelectedLibrariesPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.UIWizardUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002082\u0006\u0010=\u001a\u00020>H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010$2\u0006\u0010@\u001a\u00020AH\u0003J\b\u0010B\u001a\u00020;H\u0016J\b\u0010C\u001a\u000203H\u0002J\b\u0010D\u001a\u00020\u0013H\u0002J\b\u0010E\u001a\u00020\u001eH\u0002J\b\u0010F\u001a\u000208H\u0002J\n\u0010G\u001a\u0004\u0018\u00010HH\u0002J\b\u0010I\u001a\u000208H\u0016J\u0018\u0010J\u001a\u0002082\u0006\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020>H\u0002J:\u0010M\u001a\u0002082\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q0O2\u0006\u0010R\u001a\u00020H2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020P0T2\u0006\u0010U\u001a\u00020>H\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020P0TH\u0002J\u0018\u0010W\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0006\u0010X\u001a\u00020HH\u0002J\"\u0010Y\u001a\u0002082\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010@\u001a\u00020A2\u0006\u0010X\u001a\u00020HH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b\u001f\u0010 R'\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0017\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0017\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u0002038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0017\u001a\u0004\b4\u00105\u00a8\u0006\\"}, d2={"Lcom/intellij/ide/starters/local/wizard/StarterLibrariesStep;", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "<init>", "(Lcom/intellij/ide/starters/local/StarterContextProvider;)V", "starterContext", "Lcom/intellij/ide/starters/local/StarterContext;", "getStarterContext", "()Lcom/intellij/ide/starters/local/StarterContext;", "starterSettings", "Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "moduleBuilder", "Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "getModuleBuilder", "()Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "topLevelPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "contentPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getContentPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "contentPanel$delegate", "Lkotlin/Lazy;", "libraryDescriptionPanel", "Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel;", "getLibraryDescriptionPanel", "()Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel;", "libraryDescriptionPanel$delegate", "selectedLibrariesPanel", "Lcom/intellij/ide/starters/shared/ui/SelectedLibrariesPanel;", "getSelectedLibrariesPanel", "()Lcom/intellij/ide/starters/shared/ui/SelectedLibrariesPanel;", "selectedLibrariesPanel$delegate", "dependencyConfig", "", "", "Lcom/intellij/ide/starters/local/DependencyConfig;", "getDependencyConfig", "()Ljava/util/Map;", "dependencyConfig$delegate", "selectedLibraryIds", "", "selectedStarterId", "startersComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/ide/starters/local/Starter;", "getStartersComboBox", "()Lcom/intellij/openapi/ui/ComboBox;", "startersComboBox$delegate", "librariesList", "Lcom/intellij/ui/CheckboxTreeBase;", "getLibrariesList", "()Lcom/intellij/ui/CheckboxTreeBase;", "librariesList$delegate", "updateDataModel", "", "onStepLeaving", "getComponent", "Ljavax/swing/JComponent;", "_commit", "finishChosen", "", "getLibraryVersion", "library", "Lcom/intellij/ide/starters/local/Library;", "getPreferredFocusedComponent", "createLibrariesList", "createComponent", "createSelectedLibrariesPanel", "updateSelectedLibraries", "getLibrariesRoot", "Lcom/intellij/ui/CheckedTreeNode;", "_init", "updateLibrariesList", "starter", "init", "expandCategories", "categoryNodes", "", "Lcom/intellij/ide/starters/local/LibraryCategory;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "librariesRoot", "expandedCategories", "", "isInitial", "getExpandedCategories", "updateIncludedLibraries", "node", "updateNodeIncluded", "child", "", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nStarterLibrariesStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarterLibrariesStep.kt\ncom/intellij/ide/starters/local/wizard/StarterLibrariesStep\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,436:1\n37#2,2:437\n1#3:439\n1#3:465\n383#4,7:440\n1586#5:447\n1661#5,3:448\n777#5:451\n873#5,2:452\n1642#5,10:454\n1915#5:464\n1916#5:466\n1652#5:467\n*S KotlinDebug\n*F\n+ 1 StarterLibrariesStep.kt\ncom/intellij/ide/starters/local/wizard/StarterLibrariesStep\n*L\n293#1:437,2\n406#1:465\n341#1:440,7\n355#1:447\n355#1:448,3\n405#1:451\n405#1:452,2\n406#1:454,10\n406#1:464\n406#1:466\n406#1:467\n*E\n"})
public class StarterLibrariesStep
extends ModuleWizardStep {
    @NotNull
    private final StarterContext starterContext;
    @NotNull
    private final StarterWizardSettings starterSettings;
    @NotNull
    private final StarterModuleBuilder moduleBuilder;
    @NotNull
    private final BorderLayoutPanel topLevelPanel;
    @NotNull
    private final Lazy contentPanel$delegate;
    @NotNull
    private final Lazy libraryDescriptionPanel$delegate;
    @NotNull
    private final Lazy selectedLibrariesPanel$delegate;
    @NotNull
    private final Lazy dependencyConfig$delegate;
    @NotNull
    private final Set<String> selectedLibraryIds;
    @Nullable
    private String selectedStarterId;
    @NotNull
    private final Lazy startersComboBox$delegate;
    @NotNull
    private final Lazy librariesList$delegate;

    public StarterLibrariesStep(@NotNull StarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        this.starterContext = contextProvider.getStarterContext();
        this.starterSettings = contextProvider.getSettings();
        this.moduleBuilder = contextProvider.getModuleBuilder();
        this.topLevelPanel = new BorderLayoutPanel();
        this.contentPanel$delegate = LazyKt.lazy(() -> StarterLibrariesStep.contentPanel_delegate$lambda$0(this));
        this.libraryDescriptionPanel$delegate = LazyKt.lazy(StarterLibrariesStep::libraryDescriptionPanel_delegate$lambda$0);
        this.selectedLibrariesPanel$delegate = LazyKt.lazy(() -> StarterLibrariesStep.selectedLibrariesPanel_delegate$lambda$0(this));
        this.dependencyConfig$delegate = LazyKt.lazy(() -> StarterLibrariesStep.dependencyConfig_delegate$lambda$0(this));
        this.selectedLibraryIds = new LinkedHashSet();
        this.startersComboBox$delegate = LazyKt.lazy(StarterLibrariesStep::startersComboBox_delegate$lambda$0);
        this.librariesList$delegate = LazyKt.lazy(() -> StarterLibrariesStep.librariesList_delegate$lambda$0(this));
    }

    @NotNull
    protected final StarterContext getStarterContext() {
        return this.starterContext;
    }

    @NotNull
    protected final StarterModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    private final DialogPanel getContentPanel() {
        Lazy lazy = this.contentPanel$delegate;
        return (DialogPanel)lazy.getValue();
    }

    private final LibraryDescriptionPanel getLibraryDescriptionPanel() {
        Lazy lazy = this.libraryDescriptionPanel$delegate;
        return (LibraryDescriptionPanel)((Object)lazy.getValue());
    }

    private final SelectedLibrariesPanel getSelectedLibrariesPanel() {
        Lazy lazy = this.selectedLibrariesPanel$delegate;
        return (SelectedLibrariesPanel)((Object)lazy.getValue());
    }

    private final Map<String, DependencyConfig> getDependencyConfig() {
        Lazy lazy = this.dependencyConfig$delegate;
        return (Map)lazy.getValue();
    }

    private final ComboBox<Starter> getStartersComboBox() {
        Lazy lazy = this.startersComboBox$delegate;
        return (ComboBox)lazy.getValue();
    }

    private final CheckboxTreeBase getLibrariesList() {
        Lazy lazy = this.librariesList$delegate;
        return (CheckboxTreeBase)lazy.getValue();
    }

    public void updateDataModel() {
        Map<String, DependencyConfig> map = this.getStartersComboBox().getSelectedItem();
        this.starterContext.setStarter(map instanceof Starter ? (Starter)((Object)map) : null);
        this.starterContext.getLibraryIds().clear();
        this.starterContext.getLibraryIds().addAll((Collection<String>)this.selectedLibraryIds);
        map = this.getDependencyConfig();
        Starter starter = this.starterContext.getStarter();
        this.starterContext.setStarterDependencyConfig(map.get(starter != null ? starter.getId() : null));
    }

    public void onStepLeaving() {
        super.onStepLeaving();
        this.updateDataModel();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.topLevelPanel;
    }

    public void _commit(boolean finishChosen) {
        super._commit(finishChosen);
        try {
            if (finishChosen) {
                this.updateDataModel();
                this.moduleBuilder.validateConfigurationInternal$intellij_java_ui();
            }
        }
        catch (ConfigurationException e) {
            throw new CommitStepException(e.getMessage());
        }
    }

    @NlsSafe
    private final String getLibraryVersion(Library library) {
        if (library.getGroup() == null || library.getArtifact() == null) {
            return null;
        }
        Object object = this.getStartersComboBox().getSelectedItem();
        Starter starter = object instanceof Starter ? (Starter)object : null;
        if (starter == null) {
            return null;
        }
        Starter selectedStarter = starter;
        DependencyConfig dependencyConfig = this.getDependencyConfig().get(selectedStarter.getId());
        return dependencyConfig != null ? dependencyConfig.getVersion(library.getGroup(), library.getArtifact()) : null;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.getLibrariesList();
    }

    private final CheckboxTreeBase createLibrariesList() {
        CheckboxTreeBase list2 = new CheckboxTreeBase((CheckboxTreeBase.CheckboxTreeCellRendererBase)new CheckboxTree.CheckboxTreeCellRenderer(this){
            final /* synthetic */ StarterLibrariesStep this$0;
            {
                this.this$0 = $receiver;
            }

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                this.setBorder(JBUI.Borders.empty((int)2));
                ColoredTreeCellRenderer renderer = this.getTextRenderer();
                Object item = ((DefaultMutableTreeNode)value).getUserObject();
                if (item instanceof LibraryCategory) {
                    Icon icon = ((LibraryCategory)item).getIcon();
                    if (icon == null) {
                        Icon icon2 = AllIcons.Nodes.PpLibFolder;
                        icon = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PpLibFolder");
                    }
                    renderer.setIcon(icon);
                    renderer.append(((LibraryCategory)item).getTitle(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else if (item instanceof Library) {
                    Icon icon = ((Library)item).getIcon();
                    if (icon == null) {
                        Icon icon3 = AllIcons.Nodes.PpLib;
                        icon = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PpLib");
                    }
                    renderer.setIcon(icon);
                    renderer.append(((Library)item).getTitle(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String version = StarterLibrariesStep.access$getLibraryVersion(this.this$0, (Library)item);
                    if (version != null) {
                        renderer.append(" (" + version + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        }, null);
        FormUiUtilKt.enableEnterKeyHandling(list2);
        list2.setRowHeight(0);
        list2.setRootVisible(false);
        list2.getSelectionModel().setSelectionMode(1);
        list2.addCheckboxTreeListener(new CheckboxTreeListener(this, list2){
            final /* synthetic */ StarterLibrariesStep this$0;
            final /* synthetic */ CheckboxTreeBase $list;
            {
                this.this$0 = $receiver;
                this.$list = $list;
            }

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getUserObject();
                Library library = object instanceof Library ? (Library)object : null;
                if (library == null) {
                    return;
                }
                Library library2 = library;
                String libraryId = library2.getId();
                if (node.isChecked()) {
                    StarterLibrariesStep.access$getSelectedLibraryIds$p(this.this$0).add(libraryId);
                    v1 = StarterLibrariesStep.access$getSelectedLibraryIds$p(this.this$0).removeAll((Collection)library2.getIncludesLibraries());
                } else {
                    v1 = StarterLibrariesStep.access$getSelectedLibraryIds$p(this.this$0).remove(libraryId);
                }
                StarterLibrariesStep.access$updateIncludedLibraries(this.this$0, library2, node);
                StarterLibrariesStep.access$updateSelectedLibraries(this.this$0);
                this.$list.repaint();
            }
        });
        return list2;
    }

    private final DialogPanel createComponent() {
        this.getStartersComboBox().setMinimumAndPreferredWidth(200);
        this.getStartersComboBox().setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> StarterLibrariesStep.createComponent$lambda$0((Function1)createComponent.1.INSTANCE, arg_0)));
        this.getStartersComboBox().addItemListener(arg_0 -> StarterLibrariesStep.createComponent$lambda$1(this, arg_0));
        TreeSpeedSearch.installOn((JTree)((JTree)this.getLibrariesList()), (boolean)false, arg_0 -> StarterLibrariesStep.createComponent$lambda$3(StarterLibrariesStep::createComponent$lambda$2, arg_0));
        this.getLibrariesList().getSelectionModel().addTreeSelectionListener(arg_0 -> StarterLibrariesStep.createComponent$lambda$4(this, arg_0));
        CustomizedMessages messages = this.starterSettings.getCustomizedMessages();
        return UIWizardUtil.withVisualPadding$default((DialogPanel)BuilderKt.panel(arg_0 -> StarterLibrariesStep.createComponent$lambda$5(this, messages, arg_0)), (boolean)false, (int)1, null);
    }

    private final SelectedLibrariesPanel createSelectedLibrariesPanel() {
        SelectedLibrariesPanel panel2 = new SelectedLibrariesPanel();
        CustomizedMessages messages = this.starterSettings.getCustomizedMessages();
        StatusText statusText = panel2.getEmptyText();
        Object object = messages;
        if (object == null || (object = ((CustomizedMessages)object).getNoDependenciesSelectedLabel()) == null) {
            object = JavaStartersBundle.message("hint.dependencies.not.selected", new Object[0]);
        }
        statusText.setText((String)object);
        panel2.setLibraryRemoveListener((Function1<? super LibraryInfo, Unit>)((Function1)arg_0 -> StarterLibrariesStep.createSelectedLibrariesPanel$lambda$0(this, arg_0)));
        return panel2;
    }

    private final void updateSelectedLibraries() {
        List selected = new ArrayList();
        FormUiUtilKt.walkCheckedTree(this.getLibrariesRoot(), (Function1<? super CheckedTreeNode, Unit>)((Function1)arg_0 -> StarterLibrariesStep.updateSelectedLibraries$lambda$0(selected, arg_0)));
        this.getSelectedLibrariesPanel().update(selected);
    }

    private final CheckedTreeNode getLibrariesRoot() {
        Object object = this.getLibrariesList().getModel().getRoot();
        return object instanceof CheckedTreeNode ? (CheckedTreeNode)object : null;
    }

    public void _init() {
        Starter selectedStarter;
        Starter starter;
        Object object;
        Object object22;
        String previouslySelectedStarter;
        super._init();
        if (this.topLevelPanel.getComponentCount() == 0) {
            this.topLevelPanel.addToCenter((Component)this.getContentPanel());
        }
        StarterPack starterPack = this.starterContext.getStarterPack();
        Collection $this$toTypedArray$iv = starterPack.getStarters();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.getStartersComboBox().setModel((ComboBoxModel)new DefaultComboBoxModel<Starter>(thisCollection$iv.toArray(new Starter[0])));
        boolean initial = this.selectedStarterId == null;
        Starter starter2 = this.starterContext.getStarter();
        String string = previouslySelectedStarter = starter2 != null ? starter2.getId() : null;
        if (previouslySelectedStarter == null) {
            Object v2;
            block9: {
                Iterable iterable = starterPack.getStarters();
                object22 = iterable.iterator();
                while (object22.hasNext()) {
                    object = object22.next();
                    Starter it = (Starter)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)starterPack.getDefaultStarterId())) continue;
                    v2 = object;
                    break block9;
                }
                v2 = null;
            }
            if ((starter = (Starter)v2) == null) {
                starter = (Starter)CollectionsKt.firstOrNull(starterPack.getStarters());
            }
        } else {
            Iterator<Object> iterator;
            block10: {
                Iterable iterable = starterPack.getStarters();
                for (Object object22 : iterable) {
                    Starter it = (Starter)object22;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)previouslySelectedStarter)) continue;
                    iterator = object22;
                    break block10;
                }
                iterator = null;
            }
            starter = (Starter)((Object)iterator);
        }
        if ((selectedStarter = starter) != null) {
            this.getStartersComboBox().setSelectedItem((Object)selectedStarter);
            this.selectedStarterId = selectedStarter.getId();
            this.selectedLibraryIds.clear();
            for (String libraryId : this.starterContext.getLibraryIds()) {
                Library lib;
                Object v5;
                block11: {
                    object22 = selectedStarter.getLibraries();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Library it = (Library)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)libraryId)) continue;
                        v5 = e;
                        break block11;
                    }
                    v5 = null;
                }
                if ((lib = (Library)v5) == null) continue;
                this.selectedLibraryIds.add(libraryId);
                this.selectedLibraryIds.removeAll((Collection)lib.getIncludesLibraries());
            }
            this.updateLibrariesList(selectedStarter, initial);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLibrariesList(Starter starter, boolean init) {
        Iterable $this$mapTo$iv$iv;
        Object categoryNode;
        List<LibraryCategory> previouslyExpandedGroups = this.getExpandedCategories();
        CheckedTreeNode librariesRoot = new CheckedTreeNode();
        Map categoryNodes = new LinkedHashMap();
        List selectedLibraries = new ArrayList();
        List libraryNodes = new ArrayList();
        for (Library library : starter.getLibraries()) {
            if (!this.moduleBuilder.isDependencyAvailableInternal$intellij_java_ui(starter, library)) continue;
            CheckedTreeNode libraryNode = new CheckedTreeNode((Object)library);
            if (library.isRequired() || library.isDefault() && init) {
                this.selectedLibraryIds.add(library.getId());
            }
            libraryNode.setChecked(this.selectedLibraryIds.contains(library.getId()));
            libraryNode.setEnabled(!library.isRequired());
            if (library.getCategory() == null) {
                librariesRoot.add((MutableTreeNode)libraryNode);
            } else {
                Object object;
                void $this$getOrPut$iv;
                Map map = categoryNodes;
                LibraryCategory key$iv = library.getCategory();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DefaultMutableTreeNode newCategoryNode = new DefaultMutableTreeNode(library.getCategory(), true);
                    librariesRoot.add((MutableTreeNode)newCategoryNode);
                    DefaultMutableTreeNode answer$iv = newCategoryNode;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                categoryNode = (DefaultMutableTreeNode)object;
                ((DefaultMutableTreeNode)categoryNode).add((MutableTreeNode)libraryNode);
            }
            libraryNodes.add(libraryNode);
            if (!libraryNode.isChecked()) continue;
            selectedLibraries.add(TuplesKt.to((Object)library, (Object)libraryNode));
        }
        Iterable $this$map$iv = starter.getLibraries();
        boolean $i$f$map = false;
        categoryNode = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Library bl = (Library)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        Set starterLibraryIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.selectedLibraryIds.removeIf(arg_0 -> StarterLibrariesStep.updateLibrariesList$lambda$3(arg_0 -> StarterLibrariesStep.updateLibrariesList$lambda$2(starterLibraryIds, arg_0), arg_0));
        this.getLibrariesList().setModel((TreeModel)new DefaultTreeModel((TreeNode)librariesRoot));
        this.expandCategories(categoryNodes, librariesRoot, previouslyExpandedGroups, init);
        if (!((Collection)libraryNodes).isEmpty()) {
            Object v1;
            block11: {
                $this$mapTo$iv$iv = libraryNodes;
                for (Object e : $this$mapTo$iv$iv) {
                    CheckedTreeNode it = (CheckedTreeNode)e;
                    boolean bl = false;
                    if (!this.getLibrariesList().isExpanded(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)it.getParent()))) continue;
                    v1 = e;
                    break block11;
                }
                v1 = null;
            }
            CheckedTreeNode toExpand = v1;
            if (toExpand != null) {
                this.getLibrariesList().getSelectionModel().addSelectionPath(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)((TreeNode)toExpand)));
            }
        }
        for (Pair pair : selectedLibraries) {
            Library library = (Library)pair.component1();
            CheckedTreeNode node = (CheckedTreeNode)pair.component2();
            this.updateIncludedLibraries(library, node);
        }
        this.updateSelectedLibraries();
    }

    private final void expandCategories(Map<LibraryCategory, DefaultMutableTreeNode> categoryNodes, CheckedTreeNode librariesRoot, List<LibraryCategory> expandedCategories, boolean isInitial) {
        if (isInitial) {
            List<String> collapsedCategories = this.moduleBuilder.getCollapsedDependencyCategoriesInternal$intellij_java_ui();
            Iterator<Map.Entry<LibraryCategory, DefaultMutableTreeNode>> iterator = categoryNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                TreePath path;
                DefaultMutableTreeNode node = iterator.next().getValue();
                Object object = node.getUserObject();
                LibraryCategory libraryCategory = object instanceof LibraryCategory ? (LibraryCategory)object : null;
                String categoryId = libraryCategory != null ? libraryCategory.getId() : null;
                Intrinsics.checkNotNullExpressionValue((Object)TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)node), (String)"getPath(...)");
                if (!CollectionsKt.contains((Iterable)collapsedCategories, (Object)categoryId)) {
                    this.getLibrariesList().expandPath(path);
                    continue;
                }
                this.getLibrariesList().collapsePath(path);
            }
        } else {
            for (LibraryCategory group : expandedCategories) {
                TreePath path;
                Map.Entry newGroup;
                Object v1;
                block6: {
                    Iterable iterable = categoryNodes.entrySet();
                    for (Object t : iterable) {
                        Map.Entry it = (Map.Entry)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getKey(), (Object)group)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                if ((newGroup = (Map.Entry)v1) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)((TreeNode)newGroup.getValue())), (String)"getPath(...)");
                this.getLibrariesList().expandPath(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryCategory> getExpandedCategories() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        CheckedTreeNode checkedTreeNode = this.getLibrariesRoot();
        if (checkedTreeNode == null) {
            return CollectionsKt.emptyList();
        }
        CheckedTreeNode librariesRoot = checkedTreeNode;
        Enumeration enumeration = librariesRoot.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$filter$iv = arrayList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TreeNode it = (TreeNode)element$iv$iv;
            boolean bl = false;
            if (!this.getLibrariesList().isExpanded(TreeUtil.getPath((TreeNode)((TreeNode)librariesRoot), (TreeNode)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LibraryCategory it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TreeNode it = (TreeNode)element$iv$iv;
            boolean bl2 = false;
            DefaultMutableTreeNode defaultMutableTreeNode = it instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)it : null;
            Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
            if ((object instanceof LibraryCategory ? (LibraryCategory)object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void updateIncludedLibraries(Library library, CheckedTreeNode node) {
        if (!((Collection)library.getIncludesLibraries()).isEmpty()) {
            CheckedTreeNode rootNode;
            Object object = this.getLibrariesList().getModel().getRoot();
            CheckedTreeNode checkedTreeNode = rootNode = object instanceof CheckedTreeNode ? (CheckedTreeNode)object : null;
            if (rootNode != null) {
                Enumeration enumeration = rootNode.children();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
                object = CollectionsKt.iterator((Enumeration)enumeration);
                while (object.hasNext()) {
                    TreeNode child = (TreeNode)object.next();
                    if (child instanceof CheckedTreeNode) {
                        this.updateNodeIncluded(child, library, node);
                        continue;
                    }
                    if (!(child instanceof DefaultMutableTreeNode)) continue;
                    Enumeration<TreeNode> enumeration2 = ((DefaultMutableTreeNode)child).children();
                    Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"children(...)");
                    Iterator iterator = CollectionsKt.iterator(enumeration2);
                    while (iterator.hasNext()) {
                        TreeNode groupChild = (TreeNode)iterator.next();
                        this.updateNodeIncluded(groupChild, library, node);
                    }
                }
            }
        }
    }

    private final void updateNodeIncluded(Object child, Library library, CheckedTreeNode node) {
        CheckedTreeNode checkedNode;
        CheckedTreeNode checkedTreeNode = checkedNode = child instanceof CheckedTreeNode ? (CheckedTreeNode)child : null;
        Object object = checkedTreeNode != null ? checkedTreeNode.getUserObject() : null;
        Library library2 = object instanceof Library ? (Library)object : null;
        if (library2 == null) {
            return;
        }
        Library nodeLibrary = library2;
        if (library.getIncludesLibraries().contains(nodeLibrary.getId())) {
            checkedNode.setChecked(node.isChecked());
            checkedNode.setEnabled(!node.isChecked());
        }
    }

    private static final DialogPanel contentPanel_delegate$lambda$0(StarterLibrariesStep this$0) {
        return this$0.createComponent();
    }

    private static final LibraryDescriptionPanel libraryDescriptionPanel_delegate$lambda$0() {
        return new LibraryDescriptionPanel();
    }

    private static final SelectedLibrariesPanel selectedLibrariesPanel_delegate$lambda$0(StarterLibrariesStep this$0) {
        return this$0.createSelectedLibrariesPanel();
    }

    private static final Map dependencyConfig_delegate$lambda$0(StarterLibrariesStep this$0) {
        return this$0.moduleBuilder.loadDependencyConfigInternal$intellij_java_ui();
    }

    private static final ComboBox startersComboBox_delegate$lambda$0() {
        return new ComboBox();
    }

    private static final CheckboxTreeBase librariesList_delegate$lambda$0(StarterLibrariesStep this$0) {
        return this$0.createLibrariesList();
    }

    private static final Unit createComponent$lambda$5$0(StarterLibrariesStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getStartersComboBox());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$5$1(CustomizedMessages $messages, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object object = $messages;
        if (object == null || (object = ((CustomizedMessages)object).getDependenciesLabel()) == null) {
            String string = JavaStartersBundle.message("title.project.dependencies.label", new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        $this$row.label((String)object);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createComponent$lambda$5$2(StarterLibrariesStep this$0, CustomizedMessages $messages, Row $this$row) {
        void $this$createComponent_u24lambda_u245_u242_u240_u241_u241_u240;
        JBLabel jBLabel;
        void $this$createComponent_u24lambda_u245_u242_u240_u241_u241;
        LibraryDescriptionPanel $this$createComponent_u24lambda_u245_u242_u240_u241_u240;
        LibraryDescriptionPanel libraryDescriptionPanel;
        void $this$createComponent_u24lambda_u245_u242_u240_u241;
        JComponent $this$createComponent_u24lambda_u245_u242_u240_u240;
        void $this$createComponent_u24lambda_u245_u242_u240;
        JComponent jComponent;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel2 = jPanel = new JPanel(new GridBagLayout());
        Row row = $this$row;
        boolean bl = false;
        JScrollPane jScrollPane = jComponent = ScrollPaneFactory.createScrollPane((Component)((Component)this$0.getLibrariesList()));
        void var8_9 = $this$createComponent_u24lambda_u245_u242_u240;
        boolean bl2 = false;
        $this$createComponent_u24lambda_u245_u242_u240_u240.setPreferredSize(new Dimension(0, 0));
        var8_9.add((Component)jComponent, FormUiUtilKt.gridConstraint(0, 0));
        $this$createComponent_u24lambda_u245_u242_u240_u240 = jComponent = new JPanel(new GridBagLayout());
        var8_9 = $this$createComponent_u24lambda_u245_u242_u240;
        boolean bl3 = false;
        $this$createComponent_u24lambda_u245_u242_u240_u241.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        $this$createComponent_u24lambda_u245_u242_u240_u241.setPreferredSize(new Dimension(0, 0));
        LibraryDescriptionPanel libraryDescriptionPanel2 = libraryDescriptionPanel = this$0.getLibraryDescriptionPanel();
        void var12_13 = $this$createComponent_u24lambda_u245_u242_u240_u241;
        boolean bl4 = false;
        $this$createComponent_u24lambda_u245_u242_u240_u241_u240.setPreferredSize(new Dimension(0, 0));
        var12_13.add((Component)((Object)libraryDescriptionPanel), FormUiUtilKt.gridConstraint(0, 0));
        $this$createComponent_u24lambda_u245_u242_u240_u241_u240 = libraryDescriptionPanel = new BorderLayoutPanel();
        var12_13 = $this$createComponent_u24lambda_u245_u242_u240_u241;
        boolean bl5 = false;
        $this$createComponent_u24lambda_u245_u242_u240_u241_u241.setPreferredSize(new Dimension(0, 0));
        Object object = $messages;
        if (object == null || (object = ((CustomizedMessages)object).getSelectedDependenciesLabel()) == null) {
            String string = JavaStartersBundle.message("title.project.dependencies.selected.label", new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        JBLabel jBLabel2 = jBLabel = new JBLabel((String)object);
        void var16_17 = $this$createComponent_u24lambda_u245_u242_u240_u241_u241;
        boolean bl6 = false;
        $this$createComponent_u24lambda_u245_u242_u240_u241_u241_u240.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        var16_17.addToTop((Component)jBLabel);
        $this$createComponent_u24lambda_u245_u242_u240_u241_u241.addToCenter((Component)((Object)this$0.getSelectedLibrariesPanel()));
        var12_13.add((Component)((Object)libraryDescriptionPanel), FormUiUtilKt.gridConstraint(0, 1));
        var8_9.add((Component)jComponent, FormUiUtilKt.gridConstraint(1, 0));
        row.cell((JComponent)jPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final String createComponent$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createComponent$lambda$1(StarterLibrariesStep this$0, ItemEvent e) {
        if (e.getStateChange() == 1) {
            Starter newValue;
            Object object = e.getItem();
            Starter starter = newValue = object instanceof Starter ? (Starter)object : null;
            if (newValue != null) {
                this$0.selectedStarterId = newValue.getId();
                this$0.updateLibrariesList(newValue, false);
            }
        }
    }

    private static final String createComponent$lambda$2(TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        Object object = treePath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        Object dataObject = ((DefaultMutableTreeNode)object).getUserObject();
        return dataObject instanceof LibraryCategory ? ((LibraryCategory)dataObject).getTitle() : (dataObject instanceof Library ? ((Library)dataObject).getTitle() : "");
    }

    private static final String createComponent$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createComponent$lambda$4(StarterLibrariesStep this$0, TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path != null && e.isAddedPath()) {
            Object item;
            Object object = path.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            Object object2 = item = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
            if (item instanceof LibraryCategory) {
                this$0.getLibraryDescriptionPanel().update(((LibraryCategory)item).getTitle(), ((LibraryCategory)item).getDescription());
            } else if (item instanceof Library) {
                this$0.getLibraryDescriptionPanel().update((LibraryInfo)item, null);
            }
        } else {
            this$0.getLibraryDescriptionPanel().reset();
        }
    }

    private static final Unit createComponent$lambda$5(StarterLibrariesStep this$0, CustomizedMessages $messages, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (this$0.starterContext.getStarterPack().getStarters().size() > 1) {
            Object object = $messages;
            if (object == null || (object = ((CustomizedMessages)object).getFrameworkVersionLabel()) == null) {
                String string = JavaStartersBundle.message("title.project.version.label", new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            $this$panel.row((String)object, arg_0 -> StarterLibrariesStep.createComponent$lambda$5$0(this$0, arg_0)).bottomGap(BottomGap.SMALL);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> StarterLibrariesStep.createComponent$lambda$5$1($messages, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> StarterLibrariesStep.createComponent$lambda$5$2(this$0, $messages, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createSelectedLibrariesPanel$lambda$0$0(LibraryInfo $libraryInfo, StarterLibrariesStep this$0, CheckedTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getUserObject(), (Object)$libraryInfo) && it.isEnabled()) {
            this$0.getLibrariesList().setNodeState(it, false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createSelectedLibrariesPanel$lambda$0(StarterLibrariesStep this$0, LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        FormUiUtilKt.walkCheckedTree(this$0.getLibrariesRoot(), (Function1<? super CheckedTreeNode, Unit>)((Function1)arg_0 -> StarterLibrariesStep.createSelectedLibrariesPanel$lambda$0$0(libraryInfo, this$0, arg_0)));
        this$0.updateSelectedLibraries();
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedLibraries$lambda$0(List $selected, CheckedTreeNode it) {
        Library library;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getUserObject();
        Library library2 = library = object instanceof Library ? (Library)object : null;
        if (library != null && it.isChecked()) {
            $selected.add(library);
        }
        return Unit.INSTANCE;
    }

    private static final boolean updateLibrariesList$lambda$2(Set $starterLibraryIds, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$starterLibraryIds.contains(it);
    }

    private static final boolean updateLibrariesList$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getLibraryVersion(StarterLibrariesStep $this, Library library) {
        return $this.getLibraryVersion(library);
    }

    public static final /* synthetic */ Set access$getSelectedLibraryIds$p(StarterLibrariesStep $this) {
        return $this.selectedLibraryIds;
    }

    public static final /* synthetic */ void access$updateIncludedLibraries(StarterLibrariesStep $this, Library library, CheckedTreeNode node) {
        $this.updateIncludedLibraries(library, node);
    }

    public static final /* synthetic */ void access$updateSelectedLibraries(StarterLibrariesStep $this) {
        $this.updateSelectedLibraries();
    }
}

