/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.remote;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.remote.DownloadResult;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.wizard.WebStarterInitialStep;
import com.intellij.ide.starters.remote.wizard.WebStarterLibrariesStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.DependencyAvailable;
import com.intellij.ide.starters.shared.DependencyState;
import com.intellij.ide.starters.shared.PluginRecommendation;
import com.intellij.ide.starters.shared.StarterAppPackaging;
import com.intellij.ide.starters.shared.StarterAppType;
import com.intellij.ide.starters.shared.StarterConfigFileFormat;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.ide.starters.shared.StarterWizardSettings;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.GitRepositoryInitializer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.JdkComboBoxKt;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H&J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\b\u0010\u001c\u001a\u00020\u0018H&J\b\u0010\u001d\u001a\u00020\u0018H&J\b\u0010\u001e\u001a\u00020\u0018H&J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H$J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 H$J\b\u0010$\u001a\u00020\u0018H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 H\u0014J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0 H\u0014J\n\u0010,\u001a\u0004\u0018\u00010+H\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0 H\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000 H\u0014J\u000e\u00101\u001a\b\u0012\u0004\u0012\u0002020 H\u0014J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0014J\b\u00104\u001a\u00020&H\u0014J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\tH\u0002J\u001a\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J#\u0010?\u001a\b\u0012\u0004\u0012\u00020:0@2\u0006\u0010;\u001a\u00020<2\u0006\u0010A\u001a\u00020BH\u0016\u00a2\u0006\u0002\u0010CJ\u0016\u0010D\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020:0E0 H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010:2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0014J\u0010\u0010M\u001a\u00020N2\u0006\u0010K\u001a\u00020LH\u0014J\n\u0010O\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010P\u001a\u0004\u0018\u00010\u0018H\u0014J\n\u0010Q\u001a\u0004\u0018\u00010RH\u0014J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0018H\u0007J\u0010\u0010V\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0018H%J\u001d\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0000\u00a2\u0006\u0002\b]J\u0015\u0010^\u001a\u00020&2\u0006\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b_J\u0018\u0010`\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0014J\u0010\u0010a\u001a\u00020&2\u0006\u0010Y\u001a\u00020ZH\u0014J\u0018\u0010b\u001a\u00020c2\u0006\u0010U\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010d\u001a\u00020c2\u0006\u0010U\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0018\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020hH$J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020k0 H\u0014J\u0010\u0010l\u001a\u00020&2\u0006\u0010m\u001a\u00020nH\u0014J\u001a\u0010o\u001a\u0004\u0018\u00010n2\u0006\u0010p\u001a\u00020\u00182\u0006\u0010q\u001a\u00020\u0018H\u0016J\u0010\u0010r\u001a\u00020f2\u0006\u0010s\u001a\u00020tH\u0014J\u0010\u0010u\u001a\u00020f2\u0006\u0010v\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020f2\u0006\u0010s\u001a\u00020tH\u0002J\u0010\u0010y\u001a\u00020f2\u0006\u0010s\u001a\u00020tH\u0002J\b\u0010z\u001a\u00020fH\u0002J\u0010\u0010{\u001a\u00020f2\u0006\u0010m\u001a\u00020nH\u0002J\u0018\u0010|\u001a\u00020f2\u0006\u0010}\u001a\u00020h2\u0006\u0010~\u001a\u00020\u0018H\u0002J\u001f\u0010\u007f\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\u00182\u000b\b\u0002\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0018H\u0005J\u001a\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0001\u00a2\u0006\u0003\b\u0087\u0001J\u001d\u0010\u0088\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0089\u0001\u001a\u00020hH\u0015J'\u0010\u008a\u0001\u001a\u00030\u0084\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0089\u0001\u001a\u00020h2\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0004J\u0014\u0010\u008d\u0001\u001a\u00020\u00182\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0018H\u0003J\u0018\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0080\u0001*\u00030\u0080\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0091\u0001"}, d2={"Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder;", "<init>", "()V", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "getStarterContext", "()Lcom/intellij/ide/starters/remote/WebStarterContext;", "starterSettings", "Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "getStarterSettings", "()Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "starterSettings$delegate", "Lkotlin/Lazy;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "getModuleType", "Lcom/intellij/openapi/module/ModuleType;", "getWeight", "", "getHelpId", "", "getBuilderId", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getDescription", "getDefaultServerUrl", "getLanguages", "", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getDefaultVersion", "isPackageNameEditable", "", "isExampleCodeProvided", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "getLanguageLevels", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultLanguageLevel", "getApplicationTypes", "Lcom/intellij/ide/starters/shared/StarterAppType;", "getPackagingTypes", "Lcom/intellij/ide/starters/shared/StarterAppPackaging;", "getConfigurationFileFormats", "Lcom/intellij/ide/starters/shared/StarterConfigFileFormat;", "getFilePathsToOpen", "isShowProjectTypes", "isSuitableSdkType", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "createSettings", "getCustomOptionsStep", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "createWizardSteps", "", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "getIgnoredSteps", "Ljava/lang/Class;", "modifyProjectTypeStep", "settingsStep", "Lcom/intellij/ide/util/projectWizard/SettingsStep;", "createOptionsStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/remote/WebStarterContextProvider;", "createLibrariesStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "getUserAgentInternal", "getUserAgent", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getServerOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "serverUrl", "loadServerOptions", "getDependencyStateInternal", "Lcom/intellij/ide/starters/shared/DependencyState;", "frameworkVersion", "Lcom/intellij/ide/starters/remote/WebStarterFrameworkVersion;", "dependency", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "getDependencyStateInternal$intellij_java_ui", "isVersionAvailableInternal", "isVersionAvailableInternal$intellij_java_ui", "getDependencyState", "isVersionAvailable", "getGeneratorUrlInternal", "Lcom/intellij/util/Url;", "composeGeneratorUrl", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "getPluginRecommendations", "Lcom/intellij/ide/starters/shared/PluginRecommendation;", "isReformatAfterCreation", "project", "Lcom/intellij/openapi/project/Project;", "createProject", "name", "path", "setupModule", "module", "Lcom/intellij/openapi/module/Module;", "setupRootModel", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "runImport", "doImport", "extractTemplate", "verifyIdePlugins", "fixExecutableFlag", "containingDir", "relativePath", "loadJsonData", "Lcom/fasterxml/jackson/databind/JsonNode;", "url", "accept", "downloadResultInternal", "Lcom/intellij/ide/starters/remote/DownloadResult;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadResultInternal$intellij_java_ui", "downloadResult", "tempFile", "handleDownloadResponse", "request", "Lcom/intellij/util/io/HttpRequests$Request;", "getFilename", "contentDisposition", "getNullable", "field", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nWebStarterModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebStarterModuleBuilder.kt\ncom/intellij/ide/starters/remote/WebStarterModuleBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,464:1\n1#2:465\n23#3:466\n23#3:481\n23#3:482\n23#3:483\n23#3:484\n23#3:485\n42#4,10:467\n1586#5:477\n1661#5,3:478\n*S KotlinDebug\n*F\n+ 1 WebStarterModuleBuilder.kt\ncom/intellij/ide/starters/remote/WebStarterModuleBuilder\n*L\n238#1:466\n401#1:481\n420#1:482\n425#1:483\n377#1:484\n385#1:485\n300#1:467,10\n328#1:477\n328#1:478,3\n*E\n"})
public abstract class WebStarterModuleBuilder
extends ModuleBuilder {
    @NotNull
    private final WebStarterContext starterContext = new WebStarterContext();
    @NotNull
    private final Lazy starterSettings$delegate = LazyKt.lazy(() -> WebStarterModuleBuilder.starterSettings_delegate$lambda$0(this));
    @NotNull
    private final Lazy objectMapper$delegate = LazyKt.lazy(WebStarterModuleBuilder::objectMapper_delegate$lambda$0);

    @NotNull
    protected final WebStarterContext getStarterContext() {
        return this.starterContext;
    }

    @NotNull
    protected final StarterWizardSettings getStarterSettings() {
        Lazy lazy = this.starterSettings$delegate;
        return (StarterWizardSettings)lazy.getValue();
    }

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        ModuleType moduleType = JavaModuleType.getModuleType();
        Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"getModuleType(...)");
        return moduleType;
    }

    public int getWeight() {
        return 2000;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @NotNull
    public abstract String getBuilderId();

    @Nullable
    public abstract Icon getNodeIcon();

    @NotNull
    public abstract String getPresentableName();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract String getDefaultServerUrl();

    @NotNull
    protected abstract List<StarterLanguage> getLanguages();

    @NotNull
    protected abstract List<StarterProjectType> getProjectTypes();

    @NotNull
    protected String getDefaultVersion() {
        return "1.0-SNAPSHOT";
    }

    protected boolean isPackageNameEditable() {
        return false;
    }

    protected boolean isExampleCodeProvided() {
        return false;
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return null;
    }

    @NotNull
    protected List<StarterAppType> getApplicationTypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<StarterAppPackaging> getPackagingTypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<StarterConfigFileFormat> getConfigurationFileFormats() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.emptyList();
    }

    protected boolean isShowProjectTypes() {
        return true;
    }

    public boolean isSuitableSdkType(@NotNull SdkTypeId sdkType) {
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        return sdkType instanceof JavaSdkType && !((JavaSdkType)sdkType).isDependent();
    }

    private final StarterWizardSettings createSettings() {
        return new StarterWizardSettings(this.getProjectTypes(), this.getLanguages(), this.isExampleCodeProvided(), this.isPackageNameEditable(), this.getLanguageLevels(), this.getDefaultLanguageLevel(), this.getPackagingTypes(), this.getApplicationTypes(), this.getTestFrameworks(), this.getCustomizedMessages(), this.isShowProjectTypes(), this.getConfigurationFileFormats());
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(@NotNull WizardContext context, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.starterContext.setServerUrl(this.getDefaultServerUrl());
        this.starterContext.setVersion(this.getDefaultVersion());
        this.starterContext.setLanguage((StarterLanguage)CollectionsKt.first(this.getStarterSettings().getLanguages()));
        this.starterContext.setProjectType((StarterProjectType)CollectionsKt.firstOrNull(this.getStarterSettings().getProjectTypes()));
        this.starterContext.setCreatingNewProject(context.isCreatingNewProject());
        this.starterContext.setApplicationType((StarterAppType)CollectionsKt.firstOrNull(this.getStarterSettings().getApplicationTypes()));
        StarterLanguageLevel starterLanguageLevel = this.getStarterSettings().getDefaultLanguageLevel();
        if (starterLanguageLevel == null) {
            starterLanguageLevel = (StarterLanguageLevel)CollectionsKt.firstOrNull(this.getStarterSettings().getLanguageLevels());
        }
        this.starterContext.setLanguageLevel(starterLanguageLevel);
        this.starterContext.setPackaging((StarterAppPackaging)CollectionsKt.firstOrNull(this.getStarterSettings().getPackagingTypes()));
        this.starterContext.setTestFramework((StarterTestRunner)CollectionsKt.firstOrNull(this.getStarterSettings().getTestFrameworks()));
        this.starterContext.setConfigFileFormat((StarterConfigFileFormat)CollectionsKt.firstOrNull(this.getStarterSettings().getConfigurationFileFormats()));
        return this.createOptionsStep(new WebStarterContextProvider(this, context, this.starterContext, this.getStarterSettings(), parentDisposable));
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modulesProvider, (String)"modulesProvider");
        ModuleWizardStep[] moduleWizardStepArray = new ModuleWizardStep[1];
        StarterWizardSettings starterWizardSettings = this.getStarterSettings();
        Disposable disposable = context.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        moduleWizardStepArray[0] = this.createLibrariesStep(new WebStarterContextProvider(this, context, this.starterContext, starterWizardSettings, disposable));
        return moduleWizardStepArray;
    }

    @NotNull
    public List<Class<? extends ModuleWizardStep>> getIgnoredSteps() {
        return CollectionsKt.listOf(ProjectSettingsStep.class);
    }

    @Nullable
    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        Intrinsics.checkNotNullParameter((Object)settingsStep, (String)"settingsStep");
        return null;
    }

    @NotNull
    protected WebStarterInitialStep createOptionsStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterInitialStep(contextProvider);
    }

    @NotNull
    protected WebStarterLibrariesStep createLibrariesStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterLibrariesStep(contextProvider);
    }

    private final String getUserAgentInternal() {
        return this.getUserAgent();
    }

    @Nullable
    protected String getUserAgent() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
    }

    @Nullable
    protected CustomizedMessages getCustomizedMessages() {
        return null;
    }

    @RequiresBackgroundThread
    @NotNull
    public final WebStarterServerOptions getServerOptions(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        return this.loadServerOptions(serverUrl);
    }

    @RequiresBackgroundThread
    @NotNull
    protected abstract WebStarterServerOptions loadServerOptions(@NotNull String var1);

    @NotNull
    public final DependencyState getDependencyStateInternal$intellij_java_ui(@NotNull WebStarterFrameworkVersion frameworkVersion, @NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return this.getDependencyState(frameworkVersion, dependency);
    }

    public final boolean isVersionAvailableInternal$intellij_java_ui(@NotNull WebStarterFrameworkVersion frameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        return this.isVersionAvailable(frameworkVersion);
    }

    @NotNull
    protected DependencyState getDependencyState(@NotNull WebStarterFrameworkVersion frameworkVersion, @NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return DependencyAvailable.INSTANCE;
    }

    protected boolean isVersionAvailable(@NotNull WebStarterFrameworkVersion frameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        return true;
    }

    private final Url getGeneratorUrlInternal(String serverUrl, WebStarterContext starterContext) {
        return this.composeGeneratorUrl(serverUrl, starterContext);
    }

    @NotNull
    protected abstract Url composeGeneratorUrl(@NotNull String var1, @NotNull WebStarterContext var2);

    protected abstract void extractGeneratorResult(@NotNull File var1, @NotNull File var2);

    @NotNull
    protected List<PluginRecommendation> getPluginRecommendations() {
        return CollectionsKt.emptyList();
    }

    protected boolean isReformatAfterCreation(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return true;
    }

    @Nullable
    public Project createProject(@NotNull String name, @NotNull String path) {
        Project project2;
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Project project3 = project2 = super.createProject(name, path);
            if (project3 == null) break block0;
            Project it = project3;
            boolean bl = false;
            StarterModuleBuilder.Companion.setupProject(it);
        }
        return project2;
    }

    protected void setupModule(@NotNull Module module) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.setupModule(module);
        Object object = this.starterContext.getProjectType();
        boolean isMavenProject = object != null && (object = ((StarterProjectType)object).getId()) != null ? StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)"Maven", (boolean)true) : false;
        ExternalSystemUtil.configureNewModule((Module)module, (boolean)this.starterContext.isCreatingNewProject(), (boolean)isMavenProject);
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        try {
            this.extractTemplate();
        }
        catch (Exception e) {
            WebStarterModuleBuilder $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WebStarterModuleBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info((Throwable)e);
            StartupManager.getInstance((Project)project3).runAfterOpened(() -> WebStarterModuleBuilder.setupModule$lambda$0(e, this));
            return;
        }
        WebStarterFrameworkVersion webStarterFrameworkVersion = this.starterContext.getFrameworkVersion();
        StarterModuleBuilder.Companion.preprocessModuleCreated(module, this, webStarterFrameworkVersion != null ? webStarterFrameworkVersion.getId() : null);
        StartupManager.getInstance((Project)project3).runAfterOpened(() -> WebStarterModuleBuilder.setupModule$lambda$1(module, this));
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        StarterLanguageLevel languageLevel;
        Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
        Sdk sdk = JdkComboBoxKt.setupNewModuleJdk(modifiableRootModel, this.getModuleJdk(), this.starterContext.isCreatingNewProject());
        LanguageLevelModuleExtension moduleExt = (LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class);
        if (moduleExt != null && sdk != null && (languageLevel = this.starterContext.getLanguageLevel()) != null) {
            JavaSdkVersion selectedVersion = JavaSdkVersion.Companion.fromVersionString(languageLevel.getId());
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(sdk);
            if (selectedVersion != null && sdkVersion != null && sdkVersion.isAtLeast(selectedVersion)) {
                moduleExt.setLanguageLevel(selectedVersion.getMaxLanguageLevel());
            }
        }
        this.doAddContentEntry(modifiableRootModel);
    }

    private final void runImport(Module module) {
        LocalFileSystem.getInstance().refresh(false);
        WebStarterFrameworkVersion webStarterFrameworkVersion = this.starterContext.getFrameworkVersion();
        StarterModuleBuilder.Companion.preprocessModuleOpened(module, this, webStarterFrameworkVersion != null ? webStarterFrameworkVersion.getId() : null);
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (this.isReformatAfterCreation(project2)) {
            ReformatCodeProcessor processor = new ReformatCodeProcessor(module.getProject(), module, false);
            processor.setPostRunnable(() -> WebStarterModuleBuilder.runImport$lambda$0(this, module));
            processor.runBackground();
        } else {
            this.doImport(module);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doImport(Module module) {
        StarterModuleBuilder.Companion.openSampleFiles(module, this.getFilePathsToOpen());
        if (this.starterContext.getGitIntegration() && this.starterContext.isCreatingNewProject()) {
            void title$iv;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            String string = this.getContentEntryPath();
            Intrinsics.checkNotNull((Object)string);
            VirtualFile virtualFile = localFileSystem.refreshAndFindFileByPath(StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null));
            if (virtualFile == null) {
                throw new IllegalStateException("Module root not found");
            }
            VirtualFile moduleContentRoot = virtualFile;
            String string2 = IdeBundle.message((String)"progress.title.creating.git.repository", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = string2;
            Project project$iv = module.getProject();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, module, moduleContentRoot){
                final /* synthetic */ Module $module$inlined;
                final /* synthetic */ VirtualFile $moduleContentRoot$inlined;
                {
                    this.$module$inlined = module;
                    this.$moduleContentRoot$inlined = virtualFile;
                    super($project, $title, $cancellable);
                }

                public void run(ProgressIndicator indicator) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        GitRepositoryInitializer gitRepositoryInitializer = GitRepositoryInitializer.getInstance();
                        if (gitRepositoryInitializer == null) break block0;
                        gitRepositoryInitializer.initRepository(this.$module$inlined.getProject(), this.$moduleContentRoot$inlined, true);
                    }
                }
            });
        }
        StarterModuleBuilder.Companion.importModule(module);
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.verifyIdePlugins(project2);
    }

    private final void extractTemplate() {
        DownloadResult downloadResult = this.starterContext.getResult();
        Intrinsics.checkNotNull((Object)downloadResult);
        DownloadResult downloadResult2 = downloadResult;
        File tempFile = downloadResult2.getTempFile();
        String string = this.getContentEntryPath();
        Intrinsics.checkNotNull((Object)string);
        String path = string;
        File contentEntryDir = new File(path);
        if (downloadResult2.isZip()) {
            this.extractGeneratorResult(tempFile, contentEntryDir);
            this.fixExecutableFlag(contentEntryDir, "gradlew");
            this.fixExecutableFlag(contentEntryDir, "mvnw");
        } else {
            FileUtil.copy((File)tempFile, (File)new File(contentEntryDir, downloadResult2.getFilename()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyIdePlugins(Project project2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.starterContext.getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WebStarterDependency webStarterDependency = (WebStarterDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set selectedDependenciesIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set requiredPluginIds = new HashSet();
        block1: for (PluginRecommendation pluginRecommendation : this.getPluginRecommendations()) {
            for (String dependencyId : pluginRecommendation.getDependencyIds()) {
                if (!selectedDependenciesIds.contains(dependencyId)) continue;
                requiredPluginIds.add(PluginId.Companion.getId(pluginRecommendation.getPluginId()));
                continue block1;
            }
        }
        Set toInstallOrEnable = new HashSet();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) continue;
            toInstallOrEnable.add(pluginId);
        }
        if (toInstallOrEnable.isEmpty()) {
            return;
        }
        NotificationGroup notificationGroup = PluginsAdvertiser.getPluginSuggestionNotificationGroup();
        String string = IdeBundle.message((String)"plugins.advertiser.plugins.suggestions.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = IdeBundle.message((String)"plugins.advertiser.plugins.suggestions.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.create((String)IdeBundle.message((String)"plugins.advertiser.action.enable.plugins", (Object[])new Object[0]), (arg_0, arg_1) -> WebStarterModuleBuilder.verifyIdePlugins$lambda$2((arg_0, arg_1) -> WebStarterModuleBuilder.verifyIdePlugins$lambda$1(project2, toInstallOrEnable, arg_0, arg_1), arg_0, arg_1))).notify(project2);
    }

    private final void fixExecutableFlag(File containingDir, String relativePath) {
        File toFix = new File(containingDir, relativePath);
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }

    @RequiresBackgroundThread
    @NotNull
    protected final JsonNode loadJsonData(@NotNull String url, @Nullable String accept) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = HttpRequests.request((String)url).userAgent(this.getUserAgent()).accept(accept).connectTimeout(10000).connect(arg_0 -> WebStarterModuleBuilder.loadJsonData$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (JsonNode)object;
    }

    public static /* synthetic */ JsonNode loadJsonData$default(WebStarterModuleBuilder webStarterModuleBuilder, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadJsonData");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return webStarterModuleBuilder.loadJsonData(string, string2);
    }

    @RequiresBackgroundThread
    @NotNull
    public final DownloadResult downloadResultInternal$intellij_java_ui(@NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        File file = FileUtil.createTempFile((String)this.getBuilderId(), (String)".tmp", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempFile = file;
        return this.downloadResult(progressIndicator, tempFile);
    }

    @RequiresBackgroundThread
    @NotNull
    protected DownloadResult downloadResult(@NotNull ProgressIndicator progressIndicator, @NotNull File tempFile) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
        String string = this.getGeneratorUrlInternal(this.starterContext.getServerUrl(), this.starterContext).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        String url = string;
        WebStarterModuleBuilder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(WebStarterModuleBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Loading project from " + url);
        Object object = HttpRequests.request((String)url).userAgent(this.getUserAgentInternal()).connectTimeout(10000).isReadResponseOnError(true).connect(arg_0 -> WebStarterModuleBuilder.downloadResult$lambda$0(this, tempFile, progressIndicator, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (DownloadResult)object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final DownloadResult handleDownloadResponse(@NotNull HttpRequests.Request request, @NotNull File tempFile, @NotNull ProgressIndicator progressIndicator) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            try {
                var5_4 = request.getConnection();
                Intrinsics.checkNotNull((Object)var5_4);
            }
            catch (IOException e) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                v0 = Logger.getInstance(WebStarterModuleBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                v0.warn("Can't download project. Message (with headers info): " + HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)true));
                throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
            }
            catch (UnknownHostException he) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                v1 = Logger.getInstance(WebStarterModuleBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                v1.warn("Can't download project: " + he.getMessage());
                throw new IOException(HttpRequests.createErrorMessage((IOException)he, (HttpRequests.Request)request, (boolean)false), he);
            }
            connection = var5_4;
            contentType = connection.getContentType();
            contentDisposition = connection.getHeaderField("Content-Disposition");
            filename = this.getFilename(contentDisposition);
            if (!StringUtil.isNotEmpty((String)contentType)) break block5;
            Intrinsics.checkNotNull((Object)contentType);
            if (StringsKt.startsWith$default((String)contentType, (String)"application/zip", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        }
        if (StringsKt.endsWith$default((String)filename, (String)".zip", (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        isZip = v2;
        request.saveToFile(tempFile, progressIndicator);
        return new DownloadResult(isZip, tempFile, filename);
    }

    @NlsSafe
    private final String getFilename(String contentDisposition) {
        String filenameField = "filename=";
        if (StringUtil.isEmpty((String)contentDisposition)) {
            return "unknown";
        }
        String string = contentDisposition;
        Intrinsics.checkNotNull((Object)string);
        int startIdx = StringsKt.indexOf$default((CharSequence)string, (String)filenameField, (int)0, (boolean)false, (int)6, null);
        int endIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (char)';', (int)startIdx, (boolean)false, (int)4, null);
        String string2 = contentDisposition.substring(startIdx + filenameField.length(), endIdx > 0 ? endIdx : contentDisposition.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String fileName = string2;
        if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
            String string3 = fileName.substring(1, fileName.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            fileName = string3;
        }
        return fileName;
    }

    @Nullable
    public final JsonNode getNullable(@NotNull JsonNode $this$getNullable, @NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)$this$getNullable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        JsonNode jsonNode = $this$getNullable.get(field);
        if (jsonNode == null) {
            return null;
        }
        JsonNode element = jsonNode;
        if (element.isNull()) {
            return null;
        }
        return element;
    }

    private static final StarterWizardSettings starterSettings_delegate$lambda$0(WebStarterModuleBuilder this$0) {
        return this$0.createSettings();
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }

    private static final void setupModule$lambda$0$0(Exception $e, WebStarterModuleBuilder this$0) {
        Object[] objectArray = new Object[]{$e.getMessage()};
        String string = JavaStartersBundle.message("error.text.with.error.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        String string2 = StringUtil.shortenTextWithEllipsis((String)message, (int)1024, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
        message = string2;
        Messages.showErrorDialog((String)message, (String)this$0.getPresentableName());
    }

    private static final void setupModule$lambda$1$0(WebStarterModuleBuilder this$0, Module $module) {
        this$0.runImport($module);
    }

    private static final void setupModule$lambda$0(Exception $e, WebStarterModuleBuilder this$0) {
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> WebStarterModuleBuilder.setupModule$lambda$0$0($e, this$0), 3L, TimeUnit.SECONDS);
    }

    private static final void setupModule$lambda$1(Module $module, WebStarterModuleBuilder this$0) {
        ApplicationManager.getApplication().invokeLater(() -> WebStarterModuleBuilder.setupModule$lambda$1$0(this$0, $module), ModalityState.nonModal(), $module.getDisposed());
    }

    private static final void runImport$lambda$0(WebStarterModuleBuilder this$0, Module $module) {
        this$0.doImport($module);
    }

    private static final void verifyIdePlugins$lambda$1$0(Notification $notification) {
        $notification.expire();
    }

    private static final Unit verifyIdePlugins$lambda$1(Project $project, Set $toInstallOrEnable, AnActionEvent anActionEvent, Notification notification) {
        PluginsAdvertiser.installAndEnable$default((Project)$project, (Set)$toInstallOrEnable, (boolean)false, (boolean)false, null, () -> WebStarterModuleBuilder.verifyIdePlugins$lambda$1$0(notification), (int)28, null);
        return Unit.INSTANCE;
    }

    private static final void verifyIdePlugins$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final JsonNode loadJsonData$lambda$0(WebStarterModuleBuilder this$0, HttpRequests.Request request) {
        BufferedReader jsonRootElement;
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            bufferedReader = request.getReader();
        }
        catch (IOException e) {
            WebStarterModuleBuilder $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WebStarterModuleBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("IOException loading JSON response from " + request.getURL(), (Throwable)e);
            throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
        }
        BufferedReader bufferedReader2 = bufferedReader;
        Intrinsics.checkNotNull((Object)bufferedReader2);
        BufferedReader reader = bufferedReader2;
        try {
            bufferedReader = this$0.getObjectMapper().readTree((Reader)reader);
        }
        catch (Throwable e) {
            WebStarterModuleBuilder $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(WebStarterModuleBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Unable to read JSON response from " + request.getURL(), e);
            throw new IOException("Error parsing JSON response", e);
        }
        BufferedReader bufferedReader3 = jsonRootElement = bufferedReader;
        if (bufferedReader3 == null) {
            throw new IOException("Error parsing JSON response: empty document");
        }
        return bufferedReader3;
    }

    private static final DownloadResult downloadResult$lambda$0(WebStarterModuleBuilder this$0, File $tempFile, ProgressIndicator $progressIndicator, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this$0.handleDownloadResponse(request, $tempFile, $progressIndicator);
    }
}

