/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.shared;

import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.psi.impl.PsiNameHelperImpl;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public final class ValidationFunctions {
    public static final TextValidationFunction CHECK_PACKAGE_NAME = fieldText -> {
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(fieldText)) {
            return JavaStartersBundle.message("message.some.string.is.not.a.valid.package.name", fieldText);
        }
        return null;
    };
    public static final TextValidationFunction CHECK_SIMPLE_NAME_FORMAT = new TextValidationFunction(){
        private final Pattern myPattern = Pattern.compile("[a-zA-Z0-9-._ ]*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myPattern.matcher(fieldText).matches()) {
                return JavaStartersBundle.message("message.only.latin.characters.digits.spaces.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            return null;
        }
    };
    public static final TextValidationFunction CHECK_NOT_EMPTY = fieldText -> {
        if (fieldText.isEmpty()) {
            return JavaStartersBundle.message("message.field.must.be.set", new Object[0]);
        }
        return null;
    };
    public static final TextValidationFunction CHECK_NO_WHITESPACES = fieldText -> {
        if (fieldText.contains(" ")) {
            return JavaStartersBundle.message("message.whitespaces.are.not.allowed.here", new Object[0]);
        }
        return null;
    };
    public static final TextValidationFunction CHECK_NO_RESERVED_WORDS = new TextValidationFunction(){
        private final Pattern myPattern = Pattern.compile("(^|[ .])(con|prn|aux|nul|com\\d|lpt\\d)($|[ .])", 2);

        @Override
        public String checkText(String fieldText) {
            if (this.myPattern.matcher(fieldText).find()) {
                return JavaStartersBundle.message("message.some.parts.are.not.allowed.here", new Object[0]);
            }
            return null;
        }
    };
    public static final TextValidationFunction CHECK_GROUP_FORMAT = new TextValidationFunction(){
        private final Pattern myPatternForEntireText = Pattern.compile("[a-zA-Z\\d_.-]*");
        private final Pattern myPatternForOneWord = Pattern.compile("[a-zA-Z_].*");

        @Override
        public String checkText(String fieldText) {
            String[] wordsBetweenDots;
            if (!this.myPatternForEntireText.matcher(fieldText).matches()) {
                return JavaStartersBundle.message("message.only.latin.characters.digits.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            char firstSymbol = fieldText.charAt(0);
            char lastSymbol = fieldText.charAt(fieldText.length() - 1);
            if (firstSymbol == '.' || lastSymbol == '.') {
                return JavaStartersBundle.message("message.must.not.start.or.end.with.dot", new Object[0]);
            }
            if (fieldText.contains("..")) {
                return JavaStartersBundle.message("message.must.not.contain.double.dot.sequences", new Object[0]);
            }
            for (String word : wordsBetweenDots = fieldText.split("\\.")) {
                if (this.myPatternForOneWord.matcher(word).matches()) continue;
                return JavaStartersBundle.message("message.part.is.incorrect.and.must.start.with.latin.character.or.some.other.symbols", word);
            }
            return null;
        }
    };
    public static final TextValidationFunction CHECK_ARTIFACT_SIMPLE_FORMAT = new TextValidationFunction(){
        private final Pattern myUsedSymbolsCheckPattern = Pattern.compile("[a-zA-Z0-9-_]*");
        private final Pattern myFirstSymbolCheckPattern = Pattern.compile("[a-zA-Z0-9_].*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myUsedSymbolsCheckPattern.matcher(fieldText).matches()) {
                return JavaStartersBundle.message("message.allowed.symbols.for.check.artifact.simple.format", new Object[0]);
            }
            if (!this.myFirstSymbolCheckPattern.matcher(fieldText).matches()) {
                return JavaStartersBundle.message("message.allows.first.symbol.for.check.artifact.simple.format", new Object[0]);
            }
            return null;
        }
    };
    public static final TextValidationFunction CHECK_LOCATION_FOR_ERROR = fieldText -> {
        Path locationPath;
        try {
            locationPath = Paths.get(OSAgnosticPathUtil.expandUserHome((String)fieldText), new String[0]);
        }
        catch (InvalidPathException e) {
            return JavaStartersBundle.message("message.specified.path.is.illegal", new Object[0]);
        }
        File file = locationPath.toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return JavaStartersBundle.message("message.directory.not.writable.error", new Object[0]);
            }
            String[] children = file.list();
            if (children == null) {
                return JavaStartersBundle.message("message.file.not.directory.error", new Object[0]);
            }
        }
        return null;
    };
    public static final TextValidationFunction CHECK_ARTIFACT_FORMAT_FOR_WEB = new TextValidationFunction(){
        private final Pattern myPattern = Pattern.compile("[a-z0-9-._]*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myPattern.matcher(fieldText).matches()) {
                return JavaStartersBundle.message("message.only.lowercase.latin.characters.digits.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            if (fieldText.charAt(0) < 'a' || fieldText.charAt(0) > 'z') {
                return JavaStartersBundle.message("message.must.start.with.lowercase.latin.character", new Object[0]);
            }
            return null;
        }
    };

    public static TextValidationFunction createLocationWarningValidator(GraphProperty<String> locationProperty2) {
        return fieldText -> {
            try {
                String[] children;
                File file = Paths.get(OSAgnosticPathUtil.expandUserHome((String)FileUtil.join((String[])new String[]{(String)locationProperty2.get(), fieldText})), new String[0]).toFile();
                if (file.exists() && (children = file.list()) != null && children.length > 0) {
                    return JavaStartersBundle.message("message.directory.0.not.empty.warning", file.getAbsolutePath());
                }
            }
            catch (InvalidPathException ipe) {
                return null;
            }
            return null;
        };
    }
}

