/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.Dependency;
import com.intellij.openapi.util.NlsSafe;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public final class LibraryDescriptor
implements Dependency {
    @NlsSafe
    private String myName;
    private final Collection<File> myJars;

    public LibraryDescriptor(String name, Collection<File> jars) {
        this.myName = name;
        this.myJars = jars;
    }

    @NlsSafe
    public String getName() {
        return this.myName != null ? this.myName : "";
    }

    public void setName(String name) {
        this.myName = name;
    }

    public Collection<File> getJars() {
        return Collections.unmodifiableCollection(this.myJars);
    }

    public void addJars(Collection<? extends File> jars) {
        this.myJars.addAll(jars);
    }

    public void removeJars(Collection<? extends File> jars) {
        this.myJars.removeAll(jars);
    }

    public String toString() {
        return "Lib[" + this.myName + "]";
    }

    @Override
    public int getWeight() {
        return this.myJars.size() > 1 ? 30 : 40;
    }
}

