/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.projectImport.ImportChooserStep;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AddModuleWizard
extends AbstractProjectWizard {
    @NotNull
    private final List<ProjectImportProvider> myImportProviders;
    @NotNull
    private final StepSequence myStepSequence;

    public AddModuleWizard(@Nullable Project project2, @NotNull String filePath, ProjectImportProvider ... importProviders) {
        if (filePath == null) {
            AddModuleWizard.$$$reportNull$$$0(0);
        }
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, filePath);
        this.myImportProviders = Arrays.asList(importProviders);
        this.myStepSequence = AddModuleWizard.createStepSequence(this.myImportProviders, this.myWizardContext);
        this.initModuleWizard(filePath);
    }

    public AddModuleWizard(@Nullable Project project2, @NotNull Component dialogParent, @NotNull String filePath, ProjectImportProvider ... importProviders) {
        if (dialogParent == null) {
            AddModuleWizard.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            AddModuleWizard.$$$reportNull$$$0(2);
        }
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, dialogParent);
        this.myImportProviders = Arrays.asList(importProviders);
        this.myStepSequence = AddModuleWizard.createStepSequence(this.myImportProviders, this.myWizardContext);
        this.initModuleWizard(filePath);
    }

    @NlsContexts.DialogTitle
    private static String getImportWizardTitle(Project project2, ProjectImportProvider ... providers) {
        int isProject;
        int n = isProject = project2 == null ? 0 : 1;
        if (providers.length != 1) {
            return JavaUiBundle.message("module.wizard.dialog.title", isProject, 0, null);
        }
        return JavaUiBundle.message("module.wizard.dialog.title", isProject, 1, providers[0].getName());
    }

    private void initModuleWizard(@NotNull String defaultPath) {
        if (defaultPath == null) {
            AddModuleWizard.$$$reportNull$$$0(3);
        }
        this.myWizardContext.addContextListener(new WizardContext.Listener(){

            public void buttonsUpdateRequested() {
                AddModuleWizard.this.updateButtons();
            }

            public void nextStepRequested() {
                AddModuleWizard.this.proceedToNextStep();
            }
        });
        for (ModuleWizardStep step : this.myStepSequence.getAllSteps()) {
            this.addStep((Step)step);
        }
        for (ProjectImportProvider provider : this.myImportProviders) {
            provider.getBuilder().setFileToImport(defaultPath);
        }
        if (this.myImportProviders.size() == 1) {
            ProjectImportBuilder builder = this.myImportProviders.get(0).getBuilder();
            this.myWizardContext.setProjectBuilder((ProjectBuilder)builder);
            builder.setUpdate(this.getWizardContext().getProject() != null);
        }
        this.init();
    }

    @NotNull
    private static StepSequence createStepSequence(@NotNull List<ProjectImportProvider> importProviders, @NotNull WizardContext context) {
        if (importProviders == null) {
            AddModuleWizard.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AddModuleWizard.$$$reportNull$$$0(5);
        }
        StepSequence stepSequence = new StepSequence(new ModuleWizardStep[0]);
        if (importProviders.size() > 1) {
            stepSequence.addCommonStep(new ImportChooserStep(importProviders, stepSequence, context));
        }
        for (ProjectImportProvider provider : importProviders) {
            provider.addSteps(stepSequence, context, provider.getId());
        }
        if (importProviders.size() == 1) {
            stepSequence.setType(importProviders.get(0).getId());
        }
        StepSequence stepSequence2 = stepSequence;
        if (stepSequence2 == null) {
            AddModuleWizard.$$$reportNull$$$0(6);
        }
        return stepSequence2;
    }

    @Override
    public StepSequence getSequence() {
        return this.myStepSequence;
    }

    @Nullable
    public static Sdk getMostRecentSuitableSdk(WizardContext context) {
        if (context.getProject() == null) {
            Map sdksByType;
            Map.Entry pair;
            List sdks = Arrays.asList(ProjectJdkTable.getInstance().getAllJdks());
            ProjectBuilder builder = context.getProjectBuilder();
            if (builder != null) {
                sdks = ContainerUtil.filter(sdks, sdk -> builder.isSuitableSdkType(sdk.getSdkType()));
            }
            if ((pair = (Map.Entry)ContainerUtil.getFirstItem((sdksByType = sdks.stream().collect(Collectors.groupingBy(Sdk::getSdkType, Collectors.mapping(Function.identity(), Collectors.toList())))).entrySet())) != null) {
                return ((List)pair.getValue()).stream().max(((SdkTypeId)pair.getKey()).versionComparator()).orElse(null);
            }
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return "NewModule_or_Project.wizard";
    }

    @TestOnly
    public void commit() {
        this.commitStepData((ModuleWizardStep)this.getCurrentStepObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogParent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importProviders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/newProjectWizard/AddModuleWizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/newProjectWizard/AddModuleWizard";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initModuleWizard";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStepSequence";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

