/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSourceRootDetectionUtil<F> {
    public static final CommonSourceRootDetectionUtil<File> IO_FILE = new CommonSourceRootDetectionUtil<File>(){

        @Override
        protected String getName(File file) {
            return file.getName();
        }

        @Override
        protected boolean isCaseSensitive(@NotNull File file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            FileAttributes.CaseSensitivity sensitivity = FileSystemUtil.readParentCaseSensitivity((File)file);
            return sensitivity.toBooleanWithDefault(SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        protected File getParentFile(File file) {
            return file.getParentFile();
        }

        @Override
        protected CharSequence loadText(File file) throws IOException {
            try (InputStream stream = CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(file)));){
                String string;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    string = StreamUtil.readText((Reader)reader);
                }
                return string;
            }
        }

        @Override
        protected boolean isFile(File file) {
            return file.isFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/projectWizard/importSources/util/CommonSourceRootDetectionUtil$1", "isCaseSensitive"));
        }
    };
    public static final CommonSourceRootDetectionUtil<VirtualFile> VIRTUAL_FILE = new CommonSourceRootDetectionUtil<VirtualFile>(){

        @Override
        protected String getName(VirtualFile file) {
            return file.getName();
        }

        @Override
        protected boolean isCaseSensitive(@NotNull VirtualFile file) {
            VirtualFile parent;
            if (file == null) {
                2.$$$reportNull$$$0(0);
            }
            return (parent = file.getParent()) != null ? parent.isCaseSensitive() : SystemInfo.isFileSystemCaseSensitive;
        }

        @Override
        protected VirtualFile getParentFile(VirtualFile file) {
            return file.getParent();
        }

        @Override
        protected CharSequence loadText(VirtualFile file) throws IOException {
            return VfsUtilCore.loadText((VirtualFile)file);
        }

        @Override
        protected boolean isFile(VirtualFile file) {
            return !file.isDirectory();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/projectWizard/importSources/util/CommonSourceRootDetectionUtil$2", "isCaseSensitive"));
        }
    };

    protected CommonSourceRootDetectionUtil() {
    }

    @Nullable
    public Pair<F, String> suggestRootForFileWithPackageStatement(F file, F topmostPossibleRoot, NullableFunction<? super CharSequence, String> packageNameFetcher, boolean packagePrefixSupported) {
        CharSequence chars;
        if (!this.isFile(file)) {
            return null;
        }
        try {
            chars = this.loadText(file);
        }
        catch (IOException e) {
            return null;
        }
        String packageName = (String)packageNameFetcher.fun((Object)chars);
        if (packageName == null) {
            return null;
        }
        F root = this.getParentFile(file);
        if (root == null) {
            return null;
        }
        int index = packageName.length();
        while (index > 0) {
            boolean equalsToToken;
            int nextIndex = packageName.lastIndexOf(46, index - 1);
            String token = packageName.substring(nextIndex + 1, index);
            String dirName = this.getName(root);
            boolean bl = equalsToToken = this.isCaseSensitive(root) ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
            if (!equalsToToken || root.equals(topmostPossibleRoot)) {
                return !packagePrefixSupported ? null : new Pair(root, (Object)packageName.substring(0, index));
            }
            if ((root = this.getParentFile(root)) == null) {
                return null;
            }
            index = nextIndex;
        }
        return new Pair(root, (Object)"");
    }

    protected abstract String getName(F var1);

    protected abstract boolean isCaseSensitive(@NotNull F var1);

    @Nullable
    protected abstract F getParentFile(F var1);

    protected abstract CharSequence loadText(F var1) throws IOException;

    protected abstract boolean isFile(F var1);
}

