/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.BuildElementsEditorUi;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildElementsEditor
extends ModuleElementsEditor {
    private final BuildElementsEditorUi myUi = new BuildElementsEditorUi(this.getModel().getModule(), this::enableCompilerSettings, this::commitCompilerOutputPath, this::commitTestsOutputPath, this::commitExcludeOutput);

    protected BuildElementsEditor(ModuleConfigurationState state) {
        super(state);
    }

    public JComponent createComponentImpl() {
        boolean outputPathInherited = this.getCompilerExtension().isCompilerOutputPathInherited();
        this.myUi.inheritCompilerOutput.setSelected(outputPathInherited);
        this.myUi.perModuleCompilerOutput.setSelected(!outputPathInherited);
        this.myUi.excludeOutput.setSelected(this.getCompilerExtension().isExcludeOutput());
        this.updateOutputPathPresentation();
        return this.myUi.getPanel();
    }

    private void fireModuleConfigurationChanged() {
        this.fireConfigurationChanged();
    }

    private void updateOutputPathPresentation() {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            ProjectConfigurable projectConfig = ((ModulesConfigurator)this.getState().getModulesProvider()).getProjectStructureConfigurable().getProjectConfig();
            if (projectConfig == null) {
                return;
            }
            String baseUrl = projectConfig.getCompilerOutputUrl();
            this.moduleCompileOutputChanged(baseUrl, this.getModel().getModule().getName());
        } else {
            VirtualFile compilerOutputPath = this.getCompilerExtension().getCompilerOutputPath();
            if (compilerOutputPath != null) {
                this.myUi.compilerOutputPath.setText(FileUtil.toSystemDependentName((String)compilerOutputPath.getPath()));
            } else {
                String compilerOutputUrl = this.getCompilerExtension().getCompilerOutputUrl();
                if (compilerOutputUrl != null) {
                    this.myUi.compilerOutputPath.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)compilerOutputUrl)));
                }
            }
            VirtualFile testsOutputPath = this.getCompilerExtension().getCompilerOutputPathForTests();
            if (testsOutputPath != null) {
                this.myUi.testCompilerOutputPath.setText(FileUtil.toSystemDependentName((String)testsOutputPath.getPath()));
            } else {
                String testsOutputUrl = this.getCompilerExtension().getCompilerOutputUrlForTests();
                if (testsOutputUrl != null) {
                    this.myUi.testCompilerOutputPath.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)testsOutputUrl)));
                }
            }
        }
    }

    @Nullable
    private static String resolveCanonicalPath(@NotNull String path) {
        String canonicalPath;
        if (path == null) {
            BuildElementsEditor.$$$reportNull$$$0(0);
        }
        if (path.isEmpty()) {
            return null;
        }
        try {
            canonicalPath = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            canonicalPath = path;
        }
        return VfsUtilCore.pathToUrl((String)canonicalPath);
    }

    private void enableCompilerSettings(boolean enabled) {
        this.getCompilerExtension().inheritCompilerOutputPath(!enabled);
        this.updateOutputPathPresentation();
        this.fireModuleConfigurationChanged();
    }

    private void commitCompilerOutputPath() {
        if (!this.getModel().isWritable()) {
            return;
        }
        String path = this.myUi.compilerOutputPath.getText();
        this.getCompilerExtension().setCompilerOutputPath(BuildElementsEditor.resolveCanonicalPath(path));
        this.fireModuleConfigurationChanged();
    }

    private void commitTestsOutputPath() {
        if (!this.getModel().isWritable()) {
            return;
        }
        String path = this.myUi.testCompilerOutputPath.getText();
        this.getCompilerExtension().setCompilerOutputPathForTests(BuildElementsEditor.resolveCanonicalPath(path));
        this.fireModuleConfigurationChanged();
    }

    private void commitExcludeOutput(boolean excludeOutput) {
        this.getCompilerExtension().setExcludeOutput(excludeOutput);
        this.fireModuleConfigurationChanged();
    }

    public void saveData() {
        this.commitCompilerOutputPath();
        this.commitTestsOutputPath();
    }

    public String getDisplayName() {
        return JavaUiBundle.message("output.tab.title", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "project.structureModulesPage.outputJavadoc";
    }

    public void moduleStateChanged() {
        this.myUi.excludeOutput.setSelected(this.getCompilerExtension().isExcludeOutput());
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            if (baseUrl != null) {
                this.myUi.compilerOutputPath.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(baseUrl + "/production/" + moduleName))));
                this.myUi.testCompilerOutputPath.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(baseUrl + "/test/" + moduleName))));
            } else {
                this.myUi.compilerOutputPath.setText(null);
                this.myUi.testCompilerOutputPath.setText(null);
            }
        }
    }

    public CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.getModel().getModuleExtension(CompilerModuleExtension.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/BuildElementsEditor", "resolveCanonicalPath"));
    }
}

