/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorPaneConfigurable
extends JPanel
implements Configurable,
Disposable,
ConfigurationErrors {
    private final Alarm myAlarm;
    private final List<ConfigurationError> myErrors = new ArrayList<ConfigurationError>();
    private int myComputedErrorsStamp;
    private int myShownErrorsStamp;
    private final Object myLock = new Object();
    private final MergingUpdateQueue myContentUpdateQueue;
    private final JTextPane myContent = new JTextPane();
    private final Runnable myOnErrorsChanged;
    @NlsSafe
    private static final String myStyleText = "body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";  font-family: '" + StartupUiUtil.getLabelFont().getName() + ",serif';  font-size: " + StartupUiUtil.getLabelFont().getSize() + ";}li {  margin-bottom: 5;}ol {}a { text-decoration: none;}";

    public ErrorPaneConfigurable(Project project2, StructureConfigurableContext context, Runnable onErrorsChanged) {
        super(new BorderLayout());
        this.myOnErrorsChanged = onErrorsChanged;
        this.myContent.setEditorKit(HTMLEditorKitBuilder.simple());
        this.myContent.setEditable(false);
        this.myContent.setBackground(UIUtil.getListBackground());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myContent, (boolean)true);
        pane.setHorizontalScrollBarPolicy(31);
        this.add(pane);
        this.myContentUpdateQueue = new MergingUpdateQueue("ErrorPaneConfigurable Content Updates", 300, false, (JComponent)pane, (Disposable)this, (JComponent)pane);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        project2.getMessageBus().connect((Disposable)this).subscribe(ConfigurationErrors.TOPIC, (Object)this);
        this.myContent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                URL url = e.getURL();
                AWTEvent awtEvent = EventQueue.getCurrentEvent();
                if (!(awtEvent instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)awtEvent;
                if (url != null) {
                    ConfigurationError error = null;
                    for (Element element = e.getSourceElement(); element != null; element = element.getParentElement()) {
                        if (!"li".equals(element.getName())) continue;
                        Element ol = element.getParentElement();
                        for (int i = 0; i < ol.getElementCount(); ++i) {
                            if (ol.getElement(i) != element) continue;
                            error = ErrorPaneConfigurable.this.getError(i, ErrorPaneConfigurable.this.myShownErrorsStamp);
                        }
                        break;
                    }
                    if (error == null) {
                        return;
                    }
                    String host = url.getHost();
                    String path = url.getPath();
                    if (path != null && path.startsWith("/")) {
                        path = StringUtil.unescapeXmlEntities((String)path.substring(1));
                    }
                    if (path != null) {
                        if ("fix".equals(host)) {
                            MouseEvent mouseEvent = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX() - 15, me.getY() + 10, me.getClickCount(), me.isPopupTrigger());
                            error.fix(ErrorPaneConfigurable.this.myContent, new RelativePoint(mouseEvent));
                        } else {
                            error.navigate();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable$1", "hyperlinkActivated"));
            }
        });
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationError getError(int i, int expectedStamp) {
        Object object = this.myLock;
        synchronized (object) {
            return expectedStamp == this.myComputedErrorsStamp ? this.myErrors.get(i) : null;
        }
    }

    public void refresh() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            int currentStamp;
            ConfigurationError[] errors;
            Object object = this.myLock;
            synchronized (object) {
                errors = this.myErrors.toArray(new ConfigurationError[0]);
                currentStamp = this.myComputedErrorsStamp;
            }
            HtmlChunk[] liTags = ErrorPaneConfigurable.getErrorDescriptions(errors);
            HtmlChunk.Element ol = HtmlChunk.tag((String)"ol").children(liTags);
            HtmlChunk.Element style = HtmlChunk.tag((String)"style").attr("type", "text/css").addText(myStyleText);
            HtmlChunk.Element headerTag = new HtmlBuilder().append((HtmlChunk)style).wrapWith("header");
            HtmlChunk.Element result = new HtmlBuilder().append((HtmlChunk)headerTag).append((HtmlChunk)HtmlChunk.body().child((HtmlChunk)ol)).wrapWith(HtmlChunk.html());
            this.myContentUpdateQueue.queue((Update)new ShowErrorsUpdate(currentStamp, result.toString()));
            if (this.myOnErrorsChanged != null) {
                this.myOnErrorsChanged.run();
            }
        }, 100);
    }

    @Contract(pure=true)
    private static HtmlChunk @NotNull [] getErrorDescriptions(ConfigurationError @NotNull [] errors) {
        if (errors == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(0);
        }
        int limit = Math.min(errors.length, 100);
        HtmlChunk[] htmlChunkArray = (HtmlChunk[])StreamEx.of((Object[])errors).zipWith((BaseStream)IntStream.range(0, limit), ConfigurationErrorWithIndex::new).map(ErrorPaneConfigurable::getErrorDescriptionTag).toArray(HtmlChunk[]::new);
        if (htmlChunkArray == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(1);
        }
        return htmlChunkArray;
    }

    @Contract(pure=true)
    @NotNull
    private static HtmlChunk getErrorDescriptionTag(@NotNull ConfigurationErrorWithIndex errorIndex) {
        if (errorIndex == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(2);
        }
        int index = errorIndex.myIdx;
        ConfigurationError error = errorIndex.myError;
        HtmlChunk description = ErrorPaneConfigurable.getErrorDescription(index, error);
        if (!error.canBeFixed()) {
            HtmlChunk.Element element = description.wrapWith("li");
            if (element == null) {
                ErrorPaneConfigurable.$$$reportNull$$$0(3);
            }
            return element;
        }
        String text = "[" + JavaUiBundle.message("fix.link.text", new Object[0]) + "]";
        HtmlChunk.Element element = new HtmlBuilder().append(description).append(HtmlChunk.nbsp()).append((HtmlChunk)HtmlChunk.link((String)("http://fix/" + index), (String)text)).wrapWith("li");
        if (element == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(4);
        }
        return element;
    }

    @Contract(pure=true)
    @NotNull
    private static HtmlChunk getErrorDescription(int index, @NotNull ConfigurationError error) {
        if (error == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(5);
        }
        if (!(error instanceof ProjectConfigurationProblem)) {
            HtmlChunk htmlChunk = error.getDescription();
            if (htmlChunk == null) {
                ErrorPaneConfigurable.$$$reportNull$$$0(6);
            }
            return htmlChunk;
        }
        ProjectStructureProblemDescription problemDescription = ((ProjectConfigurationProblem)error).getProblemDescription();
        if (!problemDescription.getDescription().isEmpty()) {
            HtmlChunk htmlChunk = problemDescription.getDescription();
            if (htmlChunk == null) {
                ErrorPaneConfigurable.$$$reportNull$$$0(7);
            }
            return htmlChunk;
        }
        if (!problemDescription.canShowPlace()) {
            HtmlChunk htmlChunk = HtmlChunk.raw((String)problemDescription.getMessage());
            if (htmlChunk == null) {
                ErrorPaneConfigurable.$$$reportNull$$$0(8);
            }
            return htmlChunk;
        }
        String message = StringUtil.decapitalize((String)problemDescription.getMessage());
        ProjectStructureElement place = problemDescription.getPlace().getContainingElement();
        HtmlChunk.Element link = HtmlChunk.link((String)("http://navigate/" + index), (String)place.getPresentableName());
        HtmlChunk htmlChunk = new HtmlBuilder().append(place.getTypeName()).append(" ").append((HtmlChunk)link).append(": ").append(message).toFragment();
        if (htmlChunk == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(9);
        }
        return htmlChunk;
    }

    @Nls
    public String getDisplayName() {
        return JavaUiBundle.message("configurable.ErrorPaneConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull ConfigurationError error) {
        if (error == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myErrors.add(error);
            ++this.myComputedErrorsStamp;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeError(@NotNull ConfigurationError error) {
        if (error == null) {
            ErrorPaneConfigurable.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myErrors.remove(error);
            ++this.myComputedErrorsStamp;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrors.size();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorIndex";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescriptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescriptionTag";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescriptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescriptionTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class ConfigurationErrorWithIndex {
        @NotNull
        private final ConfigurationError myError;
        private final int myIdx;

        private ConfigurationErrorWithIndex(@NotNull ConfigurationError error, int idx) {
            if (error == null) {
                ConfigurationErrorWithIndex.$$$reportNull$$$0(0);
            }
            this.myError = error;
            this.myIdx = idx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable$ConfigurationErrorWithIndex", "<init>"));
        }
    }

    private class ShowErrorsUpdate
    extends Update {
        private final int myCurrentStamp;
        @Nls(capitalization=Nls.Capitalization.Sentence)
        private final String myText;

        ShowErrorsUpdate(@Nls(capitalization=Nls.Capitalization.Sentence) int currentStamp, String text) {
            super((Object)currentStamp);
            this.myCurrentStamp = currentStamp;
            this.myText = text;
        }

        public void run() {
            if (!Disposer.isDisposed((Disposable)ErrorPaneConfigurable.this)) {
                ErrorPaneConfigurable.this.myContent.setText(this.myText);
                ErrorPaneConfigurable.this.myShownErrorsStamp = this.myCurrentStamp;
            }
        }

        public boolean canEat(@NotNull Update update) {
            if (update == null) {
                ShowErrorsUpdate.$$$reportNull$$$0(0);
            }
            return update instanceof ShowErrorsUpdate && this.myCurrentStamp > ((ShowErrorsUpdate)update).myCurrentStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable$ShowErrorsUpdate", "canEat"));
        }
    }
}

