/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/ObsoleteLibraryFilesRemover;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "oldRoots", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/LinkedHashSet;", "registerObsoleteLibraryRoots", "", "roots", "", "deleteFiles", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nObsoleteLibraryFilesRemover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObsoleteLibraryFilesRemover.kt\ncom/intellij/openapi/roots/ui/configuration/ObsoleteLibraryFilesRemover\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n777#2:41\n873#2,2:42\n1915#2,2:44\n*S KotlinDebug\n*F\n+ 1 ObsoleteLibraryFilesRemover.kt\ncom/intellij/openapi/roots/ui/configuration/ObsoleteLibraryFilesRemover\n*L\n22#1:41\n22#1:42,2\n32#1:44,2\n*E\n"})
public final class ObsoleteLibraryFilesRemover {
    @NotNull
    private final Project project;
    @NotNull
    private final LinkedHashSet<VirtualFile> oldRoots;

    public ObsoleteLibraryFilesRemover(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.oldRoots = new LinkedHashSet();
    }

    public final void registerObsoleteLibraryRoots(@NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        CollectionsKt.addAll((Collection)this.oldRoots, (Iterable)roots);
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteFiles() {
        Object[] objectArray;
        void $this$filterTo$iv$iv;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        Iterable $this$filter$iv = this.oldRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.isValid() && !index.isInLibrary(it) && index.isInContent(VfsUtil.getLocalFile((VirtualFile)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toDelete = (List)destination$iv$iv;
        this.oldRoots.clear();
        if (!((Collection)toDelete).isEmpty() && Messages.showYesNoDialog((Project)this.project, (String)JavaUiBundle.message("dialog.message.obsolete.library.files.remover.delete.files", objectArray = new Object[]{toDelete.size(), CollectionsKt.joinToString$default((Iterable)toDelete, (CharSequence)"\n", null, null, (int)0, null, ObsoleteLibraryFilesRemover::deleteFiles$lambda$1, (int)30, null)}), (String)JavaUiBundle.message("dialog.title.obsolete.library.files.remover.delete.files", new Object[0]), null) == 0) {
            ActionsKt.runWriteAction(() -> ObsoleteLibraryFilesRemover.deleteFiles$lambda$2(toDelete, this));
        }
    }

    private static final CharSequence deleteFiles$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentableUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
        return string;
    }

    private static final Unit deleteFiles$lambda$2(List $toDelete, ObsoleteLibraryFilesRemover this$0) {
        Iterable $this$forEach$iv = $toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            VfsUtil.getLocalFile((VirtualFile)it).delete((Object)this$0);
        }
        return Unit.INSTANCE;
    }
}

