/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.workspaceModel.ide.impl.legacyBridge.RootConfigurationAccessorForWorkspaceModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIRootConfigurationAccessor
extends RootConfigurationAccessor
implements RootConfigurationAccessorForWorkspaceModel {
    private final Project myProject;
    private final MutableEntityStorage myActualDiffBuilder;

    public UIRootConfigurationAccessor(@NotNull Project project2) {
        if (project2 == null) {
            UIRootConfigurationAccessor.$$$reportNull$$$0(0);
        }
        this(project2, null);
    }

    public UIRootConfigurationAccessor(@NotNull Project project2, @Nullable MutableEntityStorage actualDiffBuilder) {
        if (project2 == null) {
            UIRootConfigurationAccessor.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myActualDiffBuilder = actualDiffBuilder;
    }

    public MutableEntityStorage getActualDiffBuilder() {
        return this.myActualDiffBuilder;
    }

    @Nullable
    public Library getLibrary(Library library, String libraryName, String libraryLevel) {
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.myProject).getContext();
        if (library == null) {
            if (libraryName != null) {
                library = context.getLibrary(libraryName, libraryLevel);
            }
        } else {
            Library model = context.getLibraryModel(library);
            if (model != null) {
                library = model;
            }
            library = context.getLibrary(library.getName(), library.getTable().getTableLevel());
        }
        return library;
    }

    @Nullable
    public Sdk getSdk(Sdk sdk, String sdkName) {
        ProjectSdksModel model = ProjectStructureConfigurable.getInstance(this.myProject).getJdkConfig().getJdksTreeModel();
        return sdkName != null ? model.findSdk(sdkName) : sdk;
    }

    public Module getModule(Module module, String moduleName) {
        if (module == null) {
            return ProjectStructureConfigurable.getInstance(this.myProject).getModulesConfig().getModule(moduleName);
        }
        return module;
    }

    public Sdk getProjectSdk(@NotNull Project project2) {
        if (project2 == null) {
            UIRootConfigurationAccessor.$$$reportNull$$$0(2);
        }
        return ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk();
    }

    @Nullable
    public String getProjectSdkName(@NotNull Project project2) {
        Sdk projectJdk;
        if (project2 == null) {
            UIRootConfigurationAccessor.$$$reportNull$$$0(3);
        }
        if ((projectJdk = this.getProjectSdk(project2)) != null) {
            return projectJdk.getName();
        }
        String projectJdkName = ProjectRootManager.getInstance((Project)project2).getProjectSdkName();
        ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel();
        return projectJdkName != null && projectJdksModel.findSdk(projectJdkName) == null ? projectJdkName : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/UIRootConfigurationAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectSdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectSdkName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

