/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutNodesDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.SimpleDnDAwareTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.RenameablePackagingElement;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTree
extends SimpleDnDAwareTree
implements AdvancedDnDSource {
    private static final Logger LOG = Logger.getInstance(LayoutTree.class);
    private final ArtifactEditorImpl myArtifactsEditor;
    private final StructureTreeModel<?> myTreeModel;

    public LayoutTree(ArtifactEditorImpl artifactsEditor, StructureTreeModel<?> treeModel) {
        this.myArtifactsEditor = artifactsEditor;
        this.myTreeModel = treeModel;
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setCellEditor(new LayoutTreeCellEditor());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerSource((AdvancedDnDSource)this);
        }
        this.setToolTipText("");
    }

    protected void configureUiHelper(TreeUIHelper helper) {
        Function<TreePath, String> f = path -> {
            SimpleNode node = this.getNodeFor((TreePath)path);
            if (node instanceof PackagingElementNode) {
                return ((PackagingElementNode)node).getElementPresentation().getSearchName();
            }
            return "";
        };
        TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)true, f);
    }

    private List<PackagingElementNode<?>> getNodesToDrag() {
        return this.getSelection().getNodes();
    }

    public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            LayoutTree.$$$reportNull$$$0(0);
        }
        return !this.getNodesToDrag().isEmpty();
    }

    public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            LayoutTree.$$$reportNull$$$0(1);
        }
        return new DnDDragStartBean((Object)new LayoutNodesDraggingObject(this.myArtifactsEditor, this.getNodesToDrag()));
    }

    @Nullable
    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin, @NotNull DnDDragStartBean bean) {
        List<PackagingElementNode<?>> nodes;
        if (bean == null) {
            LayoutTree.$$$reportNull$$$0(2);
        }
        if ((nodes = this.getNodesToDrag()).size() == 1) {
            return DnDAwareTree.getDragImage((Tree)this, (TreePath)this.getPathFor((SimpleNode)nodes.get(0)), (Point)dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this, (String)JavaUiBundle.message("drag.n.drop.text.0.packaging.elements", nodes.size()), (Point)dragOrigin);
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterSource((AdvancedDnDSource)this);
        }
    }

    public LayoutTreeSelection getSelection() {
        return new LayoutTreeSelection(this);
    }

    @Nullable
    public PackagingElement<?> getElementByPath(TreePath path) {
        List elements;
        SimpleNode node = this.getNodeFor(path);
        if (node instanceof PackagingElementNode && !(elements = ((PackagingElementNode)node).getPackagingElements()).isEmpty()) {
            return (PackagingElement)elements.get(0);
        }
        return null;
    }

    public void addSubtreeToUpdate(PackagingElementNode elementNode) {
        this.myTreeModel.invalidate((Object)elementNode, true);
    }

    public TreeVisitor createVisitorCompositeNodeChild(String parentPath, Predicate<? super PackagingElementNode<?>> childFilter) {
        List parentElementFilters = ContainerUtil.map((Collection)StringUtil.split((String)parentPath, (String)"/"), LayoutTree::createCompositeNodeByNameFilter);
        TreePath predicatesPath = TreePathUtil.convertCollectionToTreePath((Iterable)ContainerUtil.append((List)parentElementFilters, (Object[])new Predicate[]{childFilter}));
        return new TreeVisitor.ByTreePath<PackagingElementNode<?>>(this, true, predicatesPath, node -> (PackagingElementNode)((Object)((Object)TreeUtil.getUserObject(PackagingElementNode.class, (Object)node)))){

            protected boolean matches(@NotNull PackagingElementNode<?> pathComponent, @NotNull Object thisComponent) {
                if (pathComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (thisComponent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return thisComponent instanceof Predicate && ((Predicate)thisComponent).test(pathComponent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pathComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "thisComponent";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTree$1";
                objectArray[2] = "matches";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static Predicate<PackagingElementNode<?>> createCompositeNodeByNameFilter(String name) {
        Predicate<PackagingElementNode<?>> predicate = node -> node instanceof CompositePackagingElementNode && ((CompositePackagingElement)((CompositePackagingElementNode)((Object)node)).getFirstElement()).getName().equals(name);
        if (predicate == null) {
            LayoutTree.$$$reportNull$$$0(3);
        }
        return predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragOrigin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeNodeByNameFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canStartDragging";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startDragging";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedImage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class LayoutTreeCellEditor
    extends DefaultCellEditor {
        LayoutTreeCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            JTextField field = (JTextField)super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            Object node = ((DefaultMutableTreeNode)value).getUserObject();
            Object element = ((PackagingElementNode)((Object)node)).getElementIfSingle();
            LOG.assertTrue(element != null);
            String name = ((RenameablePackagingElement)element).getName();
            field.setText(name);
            int i = name.lastIndexOf(46);
            field.setSelectionStart(0);
            field.setSelectionEnd(i != -1 ? i : name.length());
            return field;
        }

        @Override
        public boolean stopCellEditing() {
            boolean stopped;
            Object element;
            String newValue = ((JTextField)this.editorComponent).getText();
            TreePath path = LayoutTree.this.getEditingPath();
            SimpleNode node = LayoutTree.this.getNodeFor(path);
            RenameablePackagingElement currentElement = null;
            if (node instanceof PackagingElementNode && (element = ((PackagingElementNode)node).getElementIfSingle()) instanceof RenameablePackagingElement) {
                currentElement = (RenameablePackagingElement)element;
            }
            if ((stopped = super.stopCellEditing()) && currentElement != null) {
                RenameablePackagingElement finalCurrentElement = currentElement;
                LayoutTree.this.myArtifactsEditor.getLayoutTreeComponent().editLayout(() -> finalCurrentElement.rename(newValue));
                LayoutTree.this.myArtifactsEditor.queueValidation();
                LayoutTree.this.myArtifactsEditor.getLayoutTreeComponent().updatePropertiesPanel(true);
                LayoutTree.this.addSubtreeToUpdate((PackagingElementNode)node);
                this.requestFocusToTree();
            }
            return stopped;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.requestFocusToTree();
        }

        private void requestFocusToTree() {
            IdeFocusManager.getInstance((Project)LayoutTree.this.myArtifactsEditor.getContext().getProject()).requestFocus((Component)((Object)LayoutTree.this), true);
        }
    }
}

