/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class AddModuleDependencyAction
extends AddItemPopupAction<Module> {
    private final StructureConfigurableContext myContext;

    AddModuleDependencyAction(ClasspathPanel classpathPanel, int actionIndex, StructureConfigurableContext context) {
        super(classpathPanel, actionIndex, JavaUiBundle.message("classpath.add.module.dependency.action", new Object[0]), JavaModuleType.getModuleType().getIcon());
        this.myContext = context;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Module item) {
        return ClasspathTableItem.createItem((OrderEntry)this.myClasspathPanel.getRootModel().addModuleOrderEntry(item), this.myContext);
    }

    private List<Module> getNotAddedModules() {
        ModifiableRootModel rootModel = this.myClasspathPanel.getRootModel();
        HashSet addedModules = ContainerUtil.newHashSet((Object[])rootModel.getModuleDependencies(true));
        addedModules.add(rootModel.getModule());
        Module[] modules = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getModules();
        ArrayList<Module> elements = new ArrayList<Module>();
        for (Module module : modules) {
            if (addedModules.contains(module)) continue;
            elements.add(module);
        }
        return elements;
    }

    @Override
    protected ClasspathElementChooser<Module> createChooser() {
        List<Module> chooseItems = this.getNotAddedModules();
        if (chooseItems.isEmpty()) {
            Messages.showMessageDialog((Component)this.myClasspathPanel.getComponent(), (String)JavaUiBundle.message("message.no.module.dependency.candidates", new Object[0]), (String)this.getTitle(), (Icon)Messages.getInformationIcon());
            return null;
        }
        return new ModuleChooser(this.myClasspathPanel, chooseItems, JavaUiBundle.message("classpath.chooser.title.add.module.dependency", new Object[0]), JavaUiBundle.message("classpath.chooser.description.add.module.dependency", new Object[0]));
    }

    private static class ModuleChooser
    implements ClasspathElementChooser<Module> {
        private final List<? extends Module> myItems;
        @NlsContexts.DialogTitle
        private final String myTitle;
        private final @NlsContexts.Label String myDescription;
        private final ClasspathPanel myClasspathPanel;

        ModuleChooser(ClasspathPanel classpathPanel, List<? extends Module> items, @NlsContexts.DialogTitle String title, @NlsContexts.Label String description) {
            this.myItems = items;
            this.myTitle = title;
            this.myDescription = description;
            this.myClasspathPanel = classpathPanel;
        }

        @Override
        @NotNull
        public List<Module> chooseElements() {
            ChooseModulesDialog dialog = new ChooseModulesDialog((Component)this.myClasspathPanel.getComponent(), this.myItems, this.myTitle, this.myDescription);
            dialog.show();
            List list2 = dialog.getChosenElements();
            if (list2 == null) {
                ModuleChooser.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/AddModuleDependencyAction$ModuleChooser", "chooseElements"));
        }
    }
}

