/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CreateModuleLibraryChooser
implements ClasspathElementChooser<Library> {
    private final JComponent myParentComponent;
    private final Module myModule;
    private final LibraryTable.ModifiableModel myModuleLibrariesModel;
    @Nullable
    private final Function<? super LibraryType<?>, ? extends LibraryProperties<?>> myDefaultPropertiesFactory;
    private final Map<LibraryRootsComponentDescriptor, LibraryType<?>> myLibraryTypes;
    private final DefaultLibraryRootsComponentDescriptor myDefaultDescriptor;

    public CreateModuleLibraryChooser(ClasspathPanel classpathPanel, LibraryTable.ModifiableModel moduleLibraryModel) {
        this(ContainerUtil.map(LibraryEditingUtil.getSuitableTypes(classpathPanel), LibraryEditingUtil.TypeForNewLibrary::getType), classpathPanel.getComponent(), classpathPanel.getRootModel().getModule(), moduleLibraryModel, null);
    }

    public CreateModuleLibraryChooser(List<? extends LibraryType<?>> libraryTypes, JComponent parentComponent, Module module, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType<?>, ? extends LibraryProperties<?>> defaultPropertiesFactory) {
        this.myParentComponent = parentComponent;
        this.myModule = module;
        this.myModuleLibrariesModel = moduleLibrariesModel;
        this.myDefaultPropertiesFactory = defaultPropertiesFactory;
        this.myLibraryTypes = new HashMap();
        this.myDefaultDescriptor = new DefaultLibraryRootsComponentDescriptor();
        for (LibraryType<?> libraryType : libraryTypes) {
            boolean acceptsClasses;
            LibraryRootsComponentDescriptor descriptor = null;
            if (libraryType != null) {
                descriptor = libraryType.createLibraryRootsComponentDescriptor();
            }
            if (descriptor == null) {
                descriptor = this.myDefaultDescriptor;
            }
            if (!(acceptsClasses = descriptor.getRootDetectors().stream().anyMatch(detector -> detector.getRootType().equals((Object)OrderRootType.CLASSES))) || this.myLibraryTypes.containsKey(descriptor)) continue;
            this.myLibraryTypes.put(descriptor, libraryType);
        }
    }

    private static Library createLibraryFromRoots(List<OrderRoot> roots, @Nullable LibraryType<?> libraryType, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType<?>, ? extends LibraryProperties<?>> defaultPropertiesFactory) {
        PersistentLibraryKind kind = libraryType == null ? null : libraryType.getKind();
        Library library = moduleLibrariesModel.createLibrary(null, kind);
        LibraryEx.ModifiableModelEx libModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        if (defaultPropertiesFactory != null) {
            libModel.setProperties(defaultPropertiesFactory.apply(libraryType));
        }
        for (OrderRoot root : roots) {
            if (root.isJarDirectory()) {
                libModel.addJarDirectory(root.getFile(), false, root.getType());
                continue;
            }
            libModel.addRoot(root.getFile(), root.getType());
        }
        libModel.commit();
        return library;
    }

    @NotNull
    private static List<OrderRoot> filterAlreadyAdded(List<OrderRoot> roots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        if (roots == null || roots.isEmpty()) {
            List<OrderRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                CreateModuleLibraryChooser.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Library[] libraries = moduleLibrariesModel.getLibraries();
        if (libraries.length == 0) {
            List<OrderRoot> list3 = roots;
            if (list3 == null) {
                CreateModuleLibraryChooser.$$$reportNull$$$0(1);
            }
            return list3;
        }
        List<OrderRoot> list4 = roots.stream().filter(root -> Arrays.stream(libraries).noneMatch(library -> ArrayUtil.contains((Object)root.getFile(), (Object[])library.getFiles(root.getType())))).collect(Collectors.toList());
        if (list4 == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(2);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<Library> chooseElements() {
        DefaultLibraryRootsComponentDescriptor rootsComponentDescriptor;
        final ArrayList<Pair> descriptors = new ArrayList<Pair>();
        for (LibraryRootsComponentDescriptor componentDescriptor : this.myLibraryTypes.keySet()) {
            descriptors.add(Pair.create((Object)componentDescriptor, (Object)componentDescriptor.createAttachFilesChooserDescriptor(null)));
        }
        FileChooserDescriptor chooserDescriptor = descriptors.size() == 1 ? (FileChooserDescriptor)((Pair)descriptors.get(0)).getSecond() : new FileChooserDescriptor(this, true, true, true, false, true, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                for (Pair pair : descriptors) {
                    if (!((FileChooserDescriptor)pair.getSecond()).isFileSelectable(file)) continue;
                    return true;
                }
                return false;
            }
        };
        chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        Project project2 = this.myModule.getProject();
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)this.myParentComponent, (Project)project2, (VirtualFile)ProjectUtil.guessProjectDir((Project)project2));
        if (files.length == 0) {
            List<Library> list2 = Collections.emptyList();
            if (list2 == null) {
                CreateModuleLibraryChooser.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<LibraryRootsComponentDescriptor> suitableDescriptors = new ArrayList<LibraryRootsComponentDescriptor>();
        for (Pair pair : descriptors) {
            if (!CreateModuleLibraryChooser.acceptAll((FileChooserDescriptor)pair.getSecond(), files)) continue;
            suitableDescriptors.add((LibraryRootsComponentDescriptor)pair.getFirst());
        }
        LibraryType<?> libraryType = null;
        if (suitableDescriptors.size() == 1) {
            rootsComponentDescriptor = (LibraryRootsComponentDescriptor)suitableDescriptors.get(0);
            libraryType = this.myLibraryTypes.get((Object)rootsComponentDescriptor);
        } else {
            rootsComponentDescriptor = this.myDefaultDescriptor;
        }
        List chosenRoots = RootDetectionUtil.detectRoots(Arrays.asList(files), (Component)this.myParentComponent, (Project)project2, (LibraryRootsComponentDescriptor)rootsComponentDescriptor);
        List<Library> list3 = CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, libraryType, this.myModuleLibrariesModel, this.myDefaultPropertiesFactory);
        if (list3 == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @TestOnly
    @NotNull
    public static List<Library> createLibrariesFromRoots(List<OrderRoot> chosenRoots, LibraryTable.ModifiableModel moduleLibrariesModel) {
        List<Library> list2 = CreateModuleLibraryChooser.createLibrariesFromRoots(chosenRoots, null, moduleLibrariesModel, null);
        if (list2 == null) {
            CreateModuleLibraryChooser.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static List<Library> createLibrariesFromRoots(List<OrderRoot> chosenRoots, LibraryType<?> libraryType, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<? super LibraryType<?>, ? extends LibraryProperties<?>> defaultPropertiesFactory) {
        List<OrderRoot> roots = CreateModuleLibraryChooser.filterAlreadyAdded(chosenRoots, moduleLibrariesModel);
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        Map byFile = roots.stream().collect(Collectors.groupingBy(OrderRoot::getFile, LinkedHashMap::new, Collectors.toList()));
        Predicate<List> containsClasses = it -> it.stream().anyMatch(root -> root.getType().equals((Object)OrderRootType.CLASSES));
        if (byFile.values().stream().allMatch(containsClasses)) {
            ArrayList<Library> addedLibraries = new ArrayList<Library>();
            for (List rootsForFile : byFile.values()) {
                addedLibraries.add(CreateModuleLibraryChooser.createLibraryFromRoots(rootsForFile, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
            }
            return addedLibraries;
        }
        return List.of(CreateModuleLibraryChooser.createLibraryFromRoots(roots, libraryType, moduleLibrariesModel, defaultPropertiesFactory));
    }

    private static boolean acceptAll(FileChooserDescriptor descriptor, VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (descriptor.isFileSelectable(file)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/roots/ui/configuration/classpath/CreateModuleLibraryChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAlreadyAdded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrariesFromRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

