/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertModuleLibraryToRepositoryLibraryAction;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "classpathPanel", "Lcom/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanel;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "<init>", "(Lcom/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanel;Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getSelectedLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "replaceLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "intellij.java.ui"})
public final class ConvertModuleLibraryToRepositoryLibraryAction
extends ConvertToRepositoryLibraryActionBase {
    @NotNull
    private final ClasspathPanel classpathPanel;

    public ConvertModuleLibraryToRepositoryLibraryAction(@NotNull ClasspathPanel classpathPanel, @NotNull StructureConfigurableContext context) {
        Intrinsics.checkNotNullParameter((Object)classpathPanel, (String)"classpathPanel");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.classpathPanel = classpathPanel;
    }

    @Override
    @Nullable
    protected LibraryEx getSelectedLibrary() {
        LibraryOrderEntry entry;
        OrderEntry orderEntry = this.classpathPanel.getSelectedEntry();
        LibraryOrderEntry libraryOrderEntry = entry = orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
        if (entry == null || !entry.isModuleLevel()) {
            return null;
        }
        orderEntry = entry.getLibrary();
        return orderEntry instanceof LibraryEx ? (LibraryEx)orderEntry : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    protected void replaceLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEditorBase, Unit> configureNewLibrary) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(configureNewLibrary, (String)"configureNewLibrary");
        String name = library.getName();
        LibraryTable.ModifiableModel modifiableModel = this.classpathPanel.getModifiableModelProvider("module").getModifiableModel();
        Library library2 = modifiableModel.createLibrary(name, RepositoryLibraryType.getInstance().getKind(), null);
        Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"createLibrary(...)");
        Library newLibrary = library2;
        ModifiableRootModel modifiableRootModel = this.classpathPanel.getRootModel();
        LibraryOrderEntry libraryOrderEntry = this.classpathPanel.getRootModel().findLibraryOrderEntry(library);
        Intrinsics.checkNotNull((Object)libraryOrderEntry);
        OrderEntryUtil.replaceLibraryEntryByAdded((ModifiableRootModel)modifiableRootModel, (LibraryOrderEntry)libraryOrderEntry);
        ExistingLibraryEditor editor = new ExistingLibraryEditor(newLibrary, null);
        configureNewLibrary.invoke((Object)editor);
        editor.commit();
    }
}

