/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileItem;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigFileInfoSetImpl
implements ConfigFileInfoSet {
    private static final Logger LOG = Logger.getInstance(ConfigFileInfoSetImpl.class);
    @NonNls
    private static final String ELEMENT_NAME = "deploymentDescriptor";
    @NonNls
    private static final String ID_ATTRIBUTE = "name";
    @NonNls
    private static final String URL_ATTRIBUTE = "url";
    private final MultiMap<ConfigFileMetaData, ConfigFileInfo> configFiles;
    @Nullable
    private ConfigFileContainerImpl myContainer;
    private final ConfigFileMetaDataProvider myMetaDataProvider;

    public ConfigFileInfoSetImpl(@NotNull ConfigFileMetaDataProvider metaDataProvider) {
        if (metaDataProvider == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(0);
        }
        this.configFiles = new MultiMap();
        this.myMetaDataProvider = metaDataProvider;
    }

    public void addConfigFile(@NotNull ConfigFileInfo descriptor) {
        if (descriptor == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(1);
        }
        this.configFiles.putValue((Object)descriptor.getMetaData(), (Object)descriptor);
        this.onChange();
    }

    public void addConfigFile(@NotNull ConfigFileMetaData metaData, @NotNull String url) {
        if (metaData == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(2);
        }
        if (url == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(3);
        }
        this.addConfigFile(new ConfigFileInfo(metaData, url));
    }

    public void removeConfigFile(@NotNull ConfigFileInfo descriptor) {
        if (descriptor == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(4);
        }
        this.configFiles.remove((Object)descriptor.getMetaData(), (Object)descriptor);
        this.onChange();
    }

    public void replaceConfigFile(@NotNull ConfigFileMetaData metaData, @NotNull String newUrl2) {
        if (metaData == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(5);
        }
        if (newUrl2 == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(6);
        }
        this.configFiles.remove((Object)metaData);
        this.addConfigFile(new ConfigFileInfo(metaData, newUrl2));
    }

    public void updateConfigFile(@NotNull ConfigFile configFile) {
        if (configFile == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(7);
        }
        this.configFiles.remove((Object)configFile.getMetaData(), (Object)configFile.getInfo());
        ConfigFileInfo info = new ConfigFileInfo(configFile.getMetaData(), configFile.getUrl());
        this.configFiles.putValue((Object)info.getMetaData(), (Object)info);
        ((ConfigFileImpl)configFile).setInfo(info);
    }

    public void removeConfigFiles(ConfigFileMetaData ... metaData) {
        for (ConfigFileMetaData data : metaData) {
            this.configFiles.remove((Object)data);
        }
        this.onChange();
    }

    @Nullable
    public ConfigFileInfo getConfigFileInfo(@NotNull ConfigFileMetaData metaData) {
        Collection descriptors;
        if (metaData == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(8);
        }
        return (descriptors = this.configFiles.get((Object)metaData)).isEmpty() ? null : (ConfigFileInfo)descriptors.iterator().next();
    }

    public List<ConfigFileInfo> getConfigFileInfos() {
        return List.copyOf(this.configFiles.values());
    }

    public void setConfigFileInfos(Collection<? extends ConfigFileInfo> descriptors) {
        this.configFiles.clear();
        for (ConfigFileInfo configFileInfo : descriptors) {
            this.configFiles.putValue((Object)configFileInfo.getMetaData(), (Object)configFileInfo);
        }
        this.onChange();
    }

    public void setConfigFileItems(@NotNull List<ConfigFileItem> configFileItems) {
        if (configFileItems == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(9);
        }
        ArrayList<ConfigFileInfo> configFileInfos = new ArrayList<ConfigFileInfo>();
        for (ConfigFileItem configFileItem : configFileItems) {
            ConfigFileMetaData metadata = this.myMetaDataProvider.findMetaData(configFileItem.getId());
            if (null == metadata) continue;
            configFileInfos.add(new ConfigFileInfo(metadata, configFileItem.getUrl()));
        }
        this.setConfigFileInfos(configFileInfos);
    }

    private void onChange() {
        if (this.myContainer != null) {
            this.myContainer.updateDescriptors(this.configFiles);
        }
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.myMetaDataProvider;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.configFiles.clear();
        List children = element.getChildren(ELEMENT_NAME);
        for (Element child : children) {
            ConfigFileMetaData metaData;
            String id = child.getAttributeValue(ID_ATTRIBUTE);
            if (id == null || (metaData = this.myMetaDataProvider.findMetaData(id)) == null) continue;
            String url = child.getAttributeValue(URL_ATTRIBUTE);
            if (url == null) {
                throw new InvalidDataException("url attribute not specified for " + id + " descriptor");
            }
            this.configFiles.putValue((Object)metaData, (Object)new ConfigFileInfo(metaData, url));
        }
        this.onChange();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeSet sortedConfigFiles = new TreeSet((o1, o2) -> {
            int id = Comparing.compare((Comparable)((Object)o1.getMetaData().getId()), (Comparable)((Object)o2.getMetaData().getId()));
            return id != 0 ? id : Comparing.compare((Comparable)((Object)o1.getUrl()), (Comparable)((Object)o2.getUrl()));
        });
        sortedConfigFiles.addAll(this.configFiles.values());
        for (ConfigFileInfo configuration : sortedConfigFiles) {
            Element child = new Element(ELEMENT_NAME);
            ConfigFileMetaData metaData = configuration.getMetaData();
            child.setAttribute(ID_ATTRIBUTE, metaData.getId());
            child.setAttribute(URL_ATTRIBUTE, configuration.getUrl());
            element.addContent(child);
        }
    }

    public void setContainer(@NotNull ConfigFileContainer container) {
        if (container == null) {
            ConfigFileInfoSetImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(this.myContainer == null);
        this.myContainer = (ConfigFileContainerImpl)container;
        this.myContainer.updateDescriptors(this.configFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaDataProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTRIBUTE;
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileItems";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/descriptors/impl/ConfigFileInfoSetImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addConfigFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeConfigFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceConfigFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateConfigFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigFileInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setConfigFileItems";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

