/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.JarHttpDownloaderJps;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibrarySynchronizerKt;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryResolveErrorNotification;

public final class RepositoryUtils {
    private static final Logger LOG = Logger.getInstance(RepositoryUtils.class);

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasExternalAnnotations(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(AnnotationOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(@NotNull Project project2, Library library) {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(0);
        }
        return RepositoryUtils.getStorageRoot(project2, library.getUrls(OrderRootType.CLASSES));
    }

    public static String getStorageRoot(Project project2, String[] urls) {
        if (urls.length == 0) {
            return null;
        }
        String firstPath = RepositoryUtils.getOnDiskParentPath(urls[0]);
        for (String root : urls) {
            if (FileUtil.pathsEqual((String)firstPath, (String)RepositoryUtils.getOnDiskParentPath(root))) continue;
            return null;
        }
        if (urls.length == 1) {
            File localRepositoryPath = JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject(project2).toFile();
            if (FileUtil.startsWith((String)firstPath, (String)localRepositoryPath.getPath())) {
                return null;
            }
            try {
                String existingNioCanonicalFirstPath;
                Path existingNioFirstPath;
                String canonicalFirstPath = new File(firstPath).getCanonicalPath();
                String canonicalLocalRepositoryPath = localRepositoryPath.getCanonicalPath();
                if (FileUtil.startsWith((String)canonicalFirstPath, (String)canonicalLocalRepositoryPath)) {
                    return null;
                }
                for (existingNioFirstPath = Path.of(canonicalFirstPath, new String[0]); existingNioFirstPath != null && !Files.exists(existingNioFirstPath, new LinkOption[0]); existingNioFirstPath = existingNioFirstPath.getParent()) {
                }
                if (existingNioFirstPath != null && FileUtil.startsWith((String)(existingNioCanonicalFirstPath = existingNioFirstPath.toRealPath(new LinkOption[0]).toString()), (String)canonicalLocalRepositoryPath)) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return firstPath;
    }

    private static String getOnDiskParentPath(String url) {
        String trimmedStart = url.startsWith("jar://") ? url.substring("jar://".length()) : (url.startsWith("file://") ? url.substring("file://".length()) : url);
        return FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)trimmedStart));
    }

    public static Promise<List<OrderRoot>> loadDependenciesToLibrary(@NotNull Project project2, @NotNull LibraryEx library, boolean downloadSources, boolean downloadJavaDocs, @Nullable String copyTo) {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(1);
        }
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(2);
        }
        if (library.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return Promises.resolvedPromise(Collections.emptyList());
        }
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)library.getProperties();
        String[] annotationUrls = library.getUrls(AnnotationOrderRootType.getInstance());
        String[] excludedRootUrls = library.getExcludedRootUrls();
        return JarRepositoryManager.loadDependenciesAsync(project2, properties, downloadSources, downloadJavaDocs, null, copyTo).thenAsync(roots -> {
            if (roots == null || roots.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> RepositoryLibraryResolveErrorNotification.showOrUpdate(properties, project2));
                return Promises.rejectedPromise((String)("Library '" + properties.getMavenId() + "' resolution failed"));
            }
            LOG.debug("Loaded dependencies for '" + properties.getMavenId() + "' repository library");
            return RepositoryUtils.setupLibraryRoots(library, properties, annotationUrls, excludedRootUrls, roots).then(ignored -> roots);
        });
    }

    private static Promise<?> setupLibraryRoots(@NotNull LibraryEx library, RepositoryLibraryProperties properties, String[] annotationUrls, String[] excludedRootUrls, List<OrderRoot> roots) {
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(3);
        }
        return ReadAction.nonBlocking(() -> {
            if (library.isDisposed()) {
                return false;
            }
            return RepositoryUtils.libraryRootsEqual(library, annotationUrls, excludedRootUrls, roots);
        }).submit((Executor)NonUrgentExecutor.getInstance()).thenAsync(rootsEqual -> {
            if (rootsEqual.booleanValue()) {
                LOG.debug("Finished setup library root for: " + library.getName());
                return Promises.resolvedPromise();
            }
            AsyncPromise result = new AsyncPromise();
            ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                try {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (library.isDisposed()) {
                            result.cancel();
                            return;
                        }
                        NewLibraryEditor editor = new NewLibraryEditor(null, (LibraryProperties)properties);
                        editor.setKeepInvalidUrls(false);
                        editor.removeAllRoots();
                        editor.addRoots(roots);
                        for (String url : annotationUrls) {
                            editor.addRoot(url, AnnotationOrderRootType.getInstance());
                        }
                        List allRootUrls = editor.getOrderRootTypes().stream().flatMap(type -> Arrays.stream(editor.getUrls((OrderRootType)type))).collect(Collectors.toList());
                        for (String excludedRootUrl : excludedRootUrls) {
                            if (!VfsUtilCore.isUnder((String)excludedRootUrl, allRootUrls)) continue;
                            editor.addExcludedRoot(excludedRootUrl);
                        }
                        LibraryEx.ModifiableModelEx model = library.getModifiableModel();
                        editor.applyTo(model);
                        model.commit();
                        result.setResult(null);
                    });
                }
                catch (Throwable t) {
                    LOG.warn("Unable to update project model for library '" + library.getName() + "'", t);
                    result.setError(t);
                }
                finally {
                    LOG.debug("Finished setup library root for: " + library.getName());
                }
            });
            return result;
        });
    }

    @NotNull
    private static Boolean libraryRootsEqual(@NotNull LibraryEx library, String[] annotationUrls, String[] excludedRootUrls, List<OrderRoot> roots) {
        Set actualExcludedRootUrls;
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(4);
        }
        ArrayList<String> allRootUrls = new ArrayList<String>();
        HashSet<Pair> actualRoots = new HashSet<Pair>();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(rootType)) {
                actualRoots.add(new Pair((Object)rootType, (Object)url));
                allRootUrls.add(url);
            }
        }
        HashSet<Pair> expectedRoots = new HashSet<Pair>();
        for (OrderRoot root : roots) {
            expectedRoots.add(new Pair((Object)root.getType(), (Object)root.getFile().getUrl()));
        }
        for (String annotationUrl : annotationUrls) {
            expectedRoots.add(new Pair((Object)AnnotationOrderRootType.getInstance(), (Object)annotationUrl));
        }
        if (!actualRoots.equals(expectedRoots)) {
            Boolean bl = false;
            if (bl == null) {
                RepositoryUtils.$$$reportNull$$$0(5);
            }
            return bl;
        }
        Set expectedExcludedRootUrls = Arrays.stream(excludedRootUrls).filter(excludedRootUrl -> VfsUtilCore.isUnder((String)excludedRootUrl, (Collection)allRootUrls)).collect(Collectors.toSet());
        if (!expectedExcludedRootUrls.equals(actualExcludedRootUrls = Arrays.stream(library.getExcludedRootUrls()).collect(Collectors.toSet()))) {
            Boolean bl = false;
            if (bl == null) {
                RepositoryUtils.$$$reportNull$$$0(6);
            }
            return bl;
        }
        Boolean bl = true;
        if (bl == null) {
            RepositoryUtils.$$$reportNull$$$0(7);
        }
        return bl;
    }

    public static Promise<?> reloadDependencies(@NotNull Project project2, @NotNull LibraryEx library) {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(8);
        }
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(9);
        }
        if (JarHttpDownloaderJps.enabled() && RepositoryUtils.isLibraryHasFixedVersion(library)) {
            Promise<?> promise2 = JarHttpDownloaderJps.getInstance(project2).downloadLibraryFilesAsync(library);
            promise2.onError(error -> LOG.warn("Failed to download repository library '" + library.getName() + "' with JarHttpDownloader", error));
            if (LOG.isDebugEnabled()) {
                promise2.onSuccess(result -> LOG.debug("Downloaded repository library '" + library.getName() + "' with JarHttpDownloader"));
            }
            return promise2;
        }
        Promise<List<OrderRoot>> mavenResolverPromise = RepositoryUtils.loadDependenciesToLibrary(project2, library, RepositoryUtils.libraryHasSources((Library)library), RepositoryUtils.libraryHasJavaDocs((Library)library), RepositoryUtils.getStorageRoot(project2, (Library)library));
        mavenResolverPromise.onError(error -> LOG.warn("Failed to download repository library '" + library.getName() + "' with maven resolver", error));
        return mavenResolverPromise;
    }

    private static boolean isLibraryHasFixedVersion(@NotNull LibraryEx library) {
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(10);
        }
        if (library.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return false;
        }
        RepositoryLibraryProperties libraryProperties = (RepositoryLibraryProperties)library.getProperties();
        if (libraryProperties == null) {
            return false;
        }
        return RepositoryLibrarySynchronizerKt.isLibraryHasFixedVersion(libraryProperties);
    }

    public static Promise<?> deleteAndReloadDependencies(@NotNull Project project2, @NotNull LibraryEx library) throws IOException {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(11);
        }
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(12);
        }
        LOG.debug("start deleting files in library " + library.getName());
        ArrayList filesToDelete = new ArrayList();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            Collections.addAll(filesToDelete, library.getRootProvider().getFiles(rootType));
        }
        for (VirtualFile file : filesToDelete) {
            ArchiveFileSystem archiveFs;
            VirtualFile local;
            OrderRootType rootType;
            rootType = file.getFileSystem();
            if (!(rootType instanceof ArchiveFileSystem) || null == (local = (archiveFs = (ArchiveFileSystem)rootType).getLocalByEntry(file))) continue;
            Path path = local.toNioPath();
            FileUtil.delete((Path)path);
        }
        return RepositoryUtils.reloadDependencies(project2, library);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryUtils";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "libraryRootsEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStorageRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesToLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupLibraryRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "libraryRootsEqual";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reloadDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryHasFixedVersion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteAndReloadDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

