/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.spring.boot.SpringBootApiBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastFacade;

public class SpringBootConfigFileHighlightingUtil {
    private final ProblemsHolder myHolder;

    public SpringBootConfigFileHighlightingUtil(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void highlightDeprecatedConfigKey(PsiElement keyElement, MetaConfigKey configKey, LocalQuickFix ... quickFixes) {
        MetaConfigKey.Deprecation deprecation;
        String reasonShortText;
        if (quickFixes == null) {
            SpringBootConfigFileHighlightingUtil.$$$reportNull$$$0(0);
        }
        String reason = StringUtil.isNotEmpty((String)(reasonShortText = (deprecation = configKey.getDeprecation()).getReason().getShortText())) ? SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.deprecated", reasonShortText) : SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.deprecated.configuration.property", configKey.getName());
        ProblemHighlightType problemHighlightType = deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.LIKE_DEPRECATED;
        this.myHolder.registerProblem(keyElement, reason, problemHighlightType, quickFixes);
    }

    public void highlightUnresolvedConfigKey(PsiElement keyElement, PsiElement elementToSearch, String qualifiedConfigKeyName, boolean isOnTheFly) {
        Module module;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                return;
            }
            indicator.setText(PropertiesBundle.message((String)"searching.for.property.key.progress.text", (Object[])new Object[]{qualifiedConfigKeyName}));
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)keyElement)) == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependentsScope((Module)module).union((SearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module)).intersectWith((GlobalSearchScope)new PlaceholderPropertyReferenceScope(module.getProject()));
        boolean zeroOccurrences = false;
        if (isOnTheFly) {
            PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.getInstance((Project)keyElement.getProject()).isCheapEnoughToSearch(qualifiedConfigKeyName, scope, null);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                zeroOccurrences = true;
            } else if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return;
            }
        }
        if (zeroOccurrences || ReferencesSearch.search((PsiElement)elementToSearch, (SearchScope)scope, (boolean)false).findFirst() == null) {
            this.myHolder.registerProblem(keyElement, SpringBootApiBundle.message("SpringBootConfigFileHighlightingUtil.cannot.resolve.configuration.property", qualifiedConfigKeyName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/spring/boot/application/config/SpringBootConfigFileHighlightingUtil", "highlightDeprecatedConfigKey"));
    }

    private static final class PlaceholderPropertyReferenceScope
    extends GlobalSearchScope {
        private PlaceholderPropertyReferenceScope(@NotNull Project project) {
            if (project == null) {
                PlaceholderPropertyReferenceScope.$$$reportNull$$$0(0);
            }
            super(project);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                PlaceholderPropertyReferenceScope.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                PlaceholderPropertyReferenceScope.$$$reportNull$$$0(2);
            }
            if (file.isDirectory()) {
                return false;
            }
            FileType fileType = file.getFileType();
            if (fileType == PropertiesFileType.INSTANCE || fileType == XmlFileType.INSTANCE || fileType.getName().equals("YAML")) {
                return true;
            }
            return UastFacade.INSTANCE.isFileSupported(file.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootConfigFileHighlightingUtil$PlaceholderPropertyReferenceScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

