/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.util.text.StringUtil;

public final class ConditionMessage {
    private final String myText;

    ConditionMessage(String text) {
        this.myText = text;
    }

    public String getText() {
        return this.myText;
    }

    public static ConditionMessage found(String thing, String ... objects) {
        return ConditionMessage.generic("Found", thing, objects);
    }

    public static ConditionMessage didNotFind(String thing, String ... objects) {
        return ConditionMessage.generic("Did not find", thing, objects);
    }

    public static ConditionMessage foundClass(String fqn) {
        return ConditionMessage.found("required class", fqn);
    }

    public static ConditionMessage didNotFindClass(String ... fqns) {
        return ConditionMessage.didNotFind("required class", fqns);
    }

    public static ConditionMessage didNotFindUnwantedClass(String ... fqns) {
        return ConditionMessage.didNotFind("unwanted class", fqns);
    }

    public static ConditionMessage didNotFindConfigKey(String ... configKeys) {
        return ConditionMessage.didNotFind("property", configKeys);
    }

    public static ConditionMessage foundConfigKey(String configKey) {
        return ConditionMessage.found("property", configKey);
    }

    public static ConditionMessage foundConfigKeyWithValue(String configKey, String value) {
        return ConditionMessage.found("property", configKey + "=" + value);
    }

    public static ConditionMessage generic(String prefix, String thing, String ... objects) {
        if (objects.length == 0) {
            return new ConditionMessage(prefix + " " + thing);
        }
        return new ConditionMessage(prefix + " " + StringUtil.pluralize((String)thing, (int)objects.length) + " " + StringUtil.join((Object[])objects, s -> "'" + s + "'", (String)", "));
    }
}

