/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.PreSerializationLoweringContext;
import org.jetbrains.kotlin.backend.common.lower.inline.CallEdge;
import org.jetbrains.kotlin.backend.common.lower.inline.CallNode;
import org.jetbrains.kotlin.backend.common.lower.inline.IrInlineCallGraphBuilder;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering;", "Context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "traverseCallGraph", "callGraph", "", "Lorg/jetbrains/kotlin/backend/common/lower/inline/CallNode;", "", "Lorg/jetbrains/kotlin/backend/common/lower/inline/CallEdge;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nInlineCallCycleCheckerLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCallCycleCheckerLowering.kt\norg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1915#2,2:130\n1915#2,2:132\n952#2,15:134\n1915#2,2:149\n*S KotlinDebug\n*F\n+ 1 InlineCallCycleCheckerLowering.kt\norg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering\n*L\n85#1:130,2\n47#1:132,2\n69#1:134,15\n78#1:149,2\n*E\n"})
public final class InlineCallCycleCheckerLowering<Context extends LoweringContext>
implements ModuleLoweringPass {
    @NotNull
    private final Context context;

    public InlineCallCycleCheckerLowering(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        Map callGraph = new LinkedHashMap();
        irModule.accept(new IrInlineCallGraphBuilder(callGraph), null);
        Context Context2 = this.context;
        PreSerializationLoweringContext preSerializationLoweringContext = Context2 instanceof PreSerializationLoweringContext ? (PreSerializationLoweringContext)Context2 : null;
        IrDiagnosticReporter diagnosticReporter = preSerializationLoweringContext != null ? preSerializationLoweringContext.getDiagnosticReporter() : null;
        this.traverseCallGraph(callGraph, diagnosticReporter);
    }

    private final void traverseCallGraph(Map<CallNode, Set<CallEdge>> callGraph, IrDiagnosticReporter diagnosticReporter) {
        Set visited = new LinkedHashSet();
        Set completed = new LinkedHashSet();
        List inlineCallsStack = new ArrayList();
        Iterable $this$forEach$iv = callGraph.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallNode it = (CallNode)element$iv;
            boolean bl = false;
            InlineCallCycleCheckerLowering.traverseCallGraph$dfs(it, visited, completed, inlineCallsStack, callGraph, diagnosticReporter, this, null);
        }
    }

    private static final <Context extends LoweringContext> void traverseCallGraph$reportInlineCallCycle(IrDiagnosticReporter $diagnosticReporter, InlineCallCycleCheckerLowering<Context> this$0, List<CallEdge> edgesInCycle) {
        if ($diagnosticReporter != null) {
            Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)CollectionsKt.plus((Collection)edgesInCycle, (Object)CollectionsKt.first(edgesInCycle)));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrCall call;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                CallEdge callerEdge = (CallEdge)pair.component1();
                CallEdge calleeEdge = (CallEdge)pair.component2();
                if (calleeEdge.getCall() == null) continue;
                boolean bl2 = false;
                $diagnosticReporter.at((IrElement)call, IrUtilsKt.getFile(callerEdge.getCallNode().getFunction())).report(CommonBackendErrors.INSTANCE.getINLINE_CALL_CYCLE(), (Object)calleeEdge.getCallNode().getFunction());
            }
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$traverseCallGraph_u24reportInlineCallCycle_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$traverseCallGraph_u24reportInlineCallCycle_u24lambda_u241.append("Inline cycle detected:").append('\n');
            for (CallEdge edge : edgesInCycle) {
                $this$traverseCallGraph_u24reportInlineCallCycle_u24lambda_u241.append("The '" + IrUtilsKt.getFqNameWhenAvailable(edge.getCallNode().getFunction()) + "' invocation is a part of inline cycle").append('\n');
            }
            String errorMessage = stringBuilder.toString();
            MessageCollector.report$default((MessageCollector)this$0.context.getMessageCollector(), (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)errorMessage, null, (int)4, null);
            throw new CompilationErrorException();
        }
    }

    private static final <Context extends LoweringContext> void traverseCallGraph$dfs(CallNode $this$traverseCallGraph_u24dfs, Set<CallNode> visited, Set<CallNode> completed, List<CallEdge> inlineCallsStack, Map<CallNode, Set<CallEdge>> $callGraph, IrDiagnosticReporter $diagnosticReporter, InlineCallCycleCheckerLowering<Context> this$0, IrCall call) {
        if (visited.contains($this$traverseCallGraph_u24dfs)) {
            if (!completed.contains($this$traverseCallGraph_u24dfs)) {
                List list;
                block10: {
                    List<CallEdge> $this$takeLastWhile$iv = inlineCallsStack;
                    boolean $i$f$takeLastWhile = false;
                    if ($this$takeLastWhile$iv.isEmpty()) {
                        list = CollectionsKt.emptyList();
                    } else {
                        ListIterator<CallEdge> iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            CallEdge callEdge = iterator$iv.previous();
                            boolean bl = false;
                            CallNode callNode = callEdge.component2();
                            if (!Intrinsics.areEqual((Object)callNode, (Object)$this$traverseCallGraph_u24dfs)) continue;
                            iterator$iv.next();
                            int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                            if (expectedSize$iv == 0) {
                                list = CollectionsKt.emptyList();
                            } else {
                                ArrayList<CallEdge> arrayList;
                                ArrayList<CallEdge> $this$takeLastWhile_u24lambda_u240$iv = arrayList = new ArrayList<CallEdge>(expectedSize$iv);
                                boolean bl2 = false;
                                while (iterator$iv.hasNext()) {
                                    $this$takeLastWhile_u24lambda_u240$iv.add(iterator$iv.next());
                                }
                                list = arrayList;
                            }
                            break block10;
                        }
                        list = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
                    }
                }
                List edgesInCycle = CollectionsKt.plus((Collection)list, (Object)new CallEdge(call, $this$traverseCallGraph_u24dfs));
                InlineCallCycleCheckerLowering.traverseCallGraph$reportInlineCallCycle($diagnosticReporter, this$0, edgesInCycle);
            }
            return;
        }
        ((Collection)inlineCallsStack).add(new CallEdge(call, $this$traverseCallGraph_u24dfs));
        ((Collection)visited).add($this$traverseCallGraph_u24dfs);
        Set<CallEdge> set = $callGraph.get($this$traverseCallGraph_u24dfs);
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallEdge callEdge = (CallEdge)element$iv;
                boolean bl = false;
                IrCall call2 = callEdge.component1();
                CallNode node = callEdge.component2();
                InlineCallCycleCheckerLowering.traverseCallGraph$dfs(node, visited, completed, inlineCallsStack, $callGraph, $diagnosticReporter, this$0, call2);
            }
        }
        CollectionsKt.removeLast(inlineCallsStack);
        ((Collection)completed).add($this$traverseCallGraph_u24dfs);
    }
}

