/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.konan.checkers.EscapeAnalysisChecker;
import org.jetbrains.kotlin.backend.konan.driver.PhaseContext;
import org.jetbrains.kotlin.backend.konan.ir.BackendNativeSymbols;
import org.jetbrains.kotlin.backend.konan.lower.BackendChecker;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/konan/lower/SpecialBackendChecksTraversal;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/konan/driver/PhaseContext;", "symbols", "Lorg/jetbrains/kotlin/backend/konan/ir/BackendNativeSymbols;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "<init>", "(Lorg/jetbrains/kotlin/backend/konan/driver/PhaseContext;Lorg/jetbrains/kotlin/backend/konan/ir/BackendNativeSymbols;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.native"})
public final class SpecialBackendChecksTraversal
implements FileLoweringPass {
    @NotNull
    private final PhaseContext context;
    @NotNull
    private final BackendNativeSymbols symbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;

    public SpecialBackendChecksTraversal(@NotNull PhaseContext context2, @NotNull BackendNativeSymbols symbols, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        this.context = context2;
        this.symbols = symbols;
        this.irBuiltIns = irBuiltIns;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, new BackendChecker(this.context, this.symbols, this.irBuiltIns, irFile));
        IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, new EscapeAnalysisChecker(this.context, this.irBuiltIns, irFile));
    }
}

