/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ClassContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ExportOnlyAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptClassTypeParametersChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptImportTypeChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00032\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dJ\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00032\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020%J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\fH\u0002J\u001a\u0010,\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u00103\u001a\u0004\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020\u00032\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0010\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010(J\u0018\u00107\u001a\u0002052\u0006\u00108\u001a\u00020(2\b\u00109\u001a\u0004\u0018\u00010(J\u0010\u0010:\u001a\u0002052\b\u0010;\u001a\u0004\u0018\u00010\u0003R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001a\u0010.\u001a\b\u0012\u0004\u0012\u0002000/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006="}, d2={"Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler;", "", "place", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "value", "Lcom/intellij/lang/javascript/psi/resolve/ClassContext;", "myClassContext", "setMyClassContext", "(Lcom/intellij/lang/javascript/psi/resolve/ClassContext;)V", "isProcessStatics", "", "()Z", "setProcessStatics", "(Z)V", "allowUnqualifiedStaticsFromInstance", "getAllowUnqualifiedStaticsFromInstance", "setAllowUnqualifiedStaticsFromInstance", "myClassDeclarationStarted", "getMyClassDeclarationStarted", "setMyClassDeclarationStarted", "getPlace", "()Lcom/intellij/psi/PsiElement;", "isProcessingInheritedClasses", "setProcessingInheritedClasses", "accepts", "element", "resolveProcessor", "Lcom/intellij/lang/javascript/psi/resolve/SinkResolveProcessor;", "acceptsConstructorWithNew", "constructor", "className", "", "checkConstructorWithNew", "acceptsForMembersVisibility", "Lcom/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind;", "Lcom/intellij/lang/javascript/psi/JSPsiElementBase;", "acceptsForMemberVisibility", "memberClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "accessType", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "isStatic", "needCheckAccessFromPlace", "parentOfElement", "checkers", "", "Lcom/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker;", "getCheckers", "()Ljava/util/List;", "processCheckers", "configureClassScope", "", "jsClass", "configureClassContext", "qualifierClass", "thisClass", "startingParent", "parent", "Companion", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nAccessibilityProcessingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,308:1\n13#2:309\n*S KotlinDebug\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler\n*L\n31#1:309\n*E\n"})
public class AccessibilityProcessingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ClassContext myClassContext;
    private boolean isProcessStatics;
    private boolean allowUnqualifiedStaticsFromInstance;
    private boolean myClassDeclarationStarted;
    @Nullable
    private final PsiElement place;
    private boolean isProcessingInheritedClasses;
    @NotNull
    private static final List<JSAccessibilityChecker> CHECKERS;
    private static final int MAX_DEPTH = 10;

    public AccessibilityProcessingHandler(@Nullable PsiElement place) {
        PsiElement psiElement = place;
        this.place = psiElement != null ? Companion.getRealElement(psiElement) : null;
    }

    private final void setMyClassContext(ClassContext value) {
        if (this.myClassContext != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AccessibilityProcessingHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Redeclaration of classScope");
        }
        this.myClassContext = value;
    }

    public final boolean isProcessStatics() {
        return this.isProcessStatics;
    }

    public final void setProcessStatics(boolean bl) {
        this.isProcessStatics = bl;
    }

    protected final boolean getAllowUnqualifiedStaticsFromInstance() {
        return this.allowUnqualifiedStaticsFromInstance;
    }

    protected final void setAllowUnqualifiedStaticsFromInstance(boolean bl) {
        this.allowUnqualifiedStaticsFromInstance = bl;
    }

    protected final boolean getMyClassDeclarationStarted() {
        return this.myClassDeclarationStarted;
    }

    protected final void setMyClassDeclarationStarted(boolean bl) {
        this.myClassDeclarationStarted = bl;
    }

    @Nullable
    protected final PsiElement getPlace() {
        return this.place;
    }

    public final boolean isProcessingInheritedClasses() {
        return this.isProcessingInheritedClasses;
    }

    public final void setProcessingInheritedClasses(boolean bl) {
        this.isProcessingInheritedClasses = bl;
    }

    public final boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor<?> resolveProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(resolveProcessor, (String)"resolveProcessor");
        if (!this.checkConstructorWithNew(element, resolveProcessor)) {
            return false;
        }
        JSResolveResult.ProblemKind errorFromCheckers = this.processCheckers(element, resolveProcessor);
        if (errorFromCheckers != null) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (this.isProcessStatics && this.myClassDeclarationStarted && element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Tag) {
            return false;
        }
        if (this.place instanceof JSIndexedPropertyAccessExpression && JSUtils.isPrivateSharpItem(element)) {
            return false;
        }
        if (element instanceof JSPsiElementBase) {
            JSResolveResult.ProblemKind problem = this.acceptsForMembersVisibility((JSPsiElementBase)element);
            if (problem != null) {
                resolveProcessor.addPossibleCandidateResult(element, problem);
            }
            return problem == null;
        }
        return true;
    }

    public final boolean acceptsConstructorWithNew(@NotNull PsiElement constructor, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.checkConstructorWithNew(constructor, new SinkResolveProcessor<ResultSink>(className, this.place, (ResultSink)new ResolveResultSink(this.place, className)));
    }

    private final boolean checkConstructorWithNew(PsiElement element, SinkResolveProcessor<?> resolveProcessor) {
        if (this.place == null || !(this.place.getContext() instanceof JSNewExpression) || !(element instanceof JSClass)) {
            return true;
        }
        JSFunction jSFunction = AccessibilityProcessingHandler.Companion.findOwnOrParentConstructor((JSClass)element, 0);
        if (jSFunction == null) {
            return true;
        }
        JSFunction constructor = jSFunction;
        AccessibilityProcessingHandler handler = new AccessibilityProcessingHandler(this.place);
        handler.startingParent(element);
        return handler.accepts(constructor, resolveProcessor);
    }

    @Nullable
    public final JSResolveResult.ProblemKind acceptsForMembersVisibility(@NotNull JSPsiElementBase element) {
        block10: {
            block11: {
                boolean isStatic;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                JSClass jSClass = JSUtils.getMemberContainingClass((PsiElement)element);
                if (jSClass == null) {
                    return null;
                }
                JSClass memberContainingClass = jSClass;
                JSAttributeList.AccessType accessType = element.getAccessType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)accessType), (String)"getAccessType(...)");
                JSAttributeList.AccessType accessType2 = accessType;
                PsiElement parentOfElement = JSResolveUtil.findParent((PsiElement)element);
                if (!this.needCheckAccessFromPlace(element, parentOfElement)) break block10;
                boolean bl = isStatic = element.getJSContext() == JSContext.STATIC || element instanceof JSFunction && ((JSFunction)element).isConstructor();
                if (accessType2 == JSAttributeList.AccessType.PRIVATE && !this.acceptsForMemberVisibility(memberContainingClass, accessType2, isStatic)) {
                    JSResolveResult.ProblemKind problemKind = element instanceof JSFunction && ((JSFunction)element).isConstructor() ? JSResolveResult.ProblemKind.PRIVATE_CONSTRUCTOR_IS_NOT_ACCESSIBLE : JSResolveResult.ProblemKind.PRIVATE_MEMBER_IS_NOT_ACCESSIBLE;
                    return problemKind;
                }
                if (accessType2 != JSAttributeList.AccessType.PROTECTED || this.acceptsForMemberVisibility(memberContainingClass, accessType2, isStatic)) break block10;
                Object object = this.myClassContext;
                if (object != null && (object = ((ClassContext)object).getThisClasses()) != null ? !object.isEmpty() : false) break block11;
                if (!Companion.isParentClassContext((PsiElement)element)) break block10;
            }
            JSResolveResult.ProblemKind problemKind = element instanceof JSFunction && ((JSFunction)element).isConstructor() ? JSResolveResult.ProblemKind.PROTECTED_CONSTRUCTOR_IS_NOT_ACCESSIBLE : JSResolveResult.ProblemKind.PROTECTED_MEMBER_IS_NOT_ACCESSIBLE;
            return problemKind;
        }
        if (this.isProcessStatics) {
            if (!(element.getJSContext() != JSContext.INSTANCE || this.place instanceof JSReferenceExpression && JSUtils.isPrivateBrandCheckReference((JSReferenceExpression)this.place))) {
                return JSResolveResult.ProblemKind.INSTANCE_MEMBER_INACCESSIBLE;
            }
        } else if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
            return JSResolveResult.ProblemKind.STATIC_MEMBER_INACCESSIBLE;
        }
        return null;
    }

    private final boolean acceptsForMemberVisibility(JSClass memberClass, JSAttributeList.AccessType accessType, boolean isStatic) {
        ClassContext classContext = this.myClassContext;
        return classContext == null || classContext.acceptsMember(memberClass, accessType, isStatic);
    }

    private final boolean needCheckAccessFromPlace(JSPsiElementBase element, PsiElement parentOfElement) {
        if (this.place != null && parentOfElement instanceof TypeScriptModule) {
            PsiElement parent = JSResolveUtil.findParent(this.place);
            return parent != null && !PsiTreeUtil.isAncestor((PsiElement)parentOfElement, (PsiElement)parent, (boolean)false);
        }
        return JSResolveUtil.getClassOfContext(this.place) != JSUtils.getMemberContainingClass((PsiElement)element);
    }

    @NotNull
    public List<JSAccessibilityChecker> getCheckers() {
        return CHECKERS;
    }

    private final JSResolveResult.ProblemKind processCheckers(PsiElement element, SinkResolveProcessor<?> resolveProcessor) {
        for (JSAccessibilityChecker checker : this.getCheckers()) {
            JSResolveResult.ProblemKind check;
            if (!checker.isAvailable(this, resolveProcessor) || (check = checker.check(this.place, element)) == null) continue;
            return check;
        }
        return null;
    }

    public final void configureClassScope(@Nullable JSClass jsClass) {
        JSClass jSClass = jsClass;
        if (jSClass != null) {
            this.configureClassContext(jSClass, jsClass);
        } else {
            this.setMyClassContext(null);
        }
    }

    public final void configureClassContext(@NotNull JSClass qualifierClass, @Nullable JSClass thisClass) {
        ClassContext classContext;
        Intrinsics.checkNotNullParameter((Object)qualifierClass, (String)"qualifierClass");
        if (thisClass != null) {
            JSClass realThisClass = (JSClass)Companion.getRealElement((PsiElement)thisClass);
            Set classes = SequencesKt.toSet((Sequence)SequencesKt.generateSequence((Object)realThisClass, AccessibilityProcessingHandler::configureClassContext$lambda$0));
            classContext = new ClassContext(qualifierClass, classes);
        } else {
            classContext = new ClassContext(qualifierClass, SetsKt.emptySet());
        }
        this.setMyClassContext(classContext);
    }

    public final void startingParent(@Nullable PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            JSClass jsClass = (JSClass)Companion.getRealElement(parent);
            if (!this.isProcessingInheritedClasses && this.myClassContext == null) {
                JSClass thisClass = JSResolveUtil.getClassOfContext(this.place);
                this.configureClassContext(jsClass, thisClass);
            }
        } else if (parent instanceof JSAttributeListOwner) {
            if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)parent, JSAttributeList.ModifierType.STATIC)) {
                this.isProcessStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof XmlTag) {
            this.isProcessStatics = false;
        }
    }

    private static final JSClass configureClassContext$lambda$0(JSClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)it, JSClass.class);
    }

    @NotNull
    protected static final List<JSAccessibilityChecker> getCHECKERS() {
        return Companion.getCHECKERS();
    }

    @JvmStatic
    public static final <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Supplier<Boolean> action) {
        return Companion.processWithStatic(processor, newStatic, action);
    }

    static {
        Object[] objectArray = new JSAccessibilityChecker[]{TypeScriptImportTypeChecker.INSTANCE, TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE, ES6ExportOnlyAccessibilityChecker.INSTANCE, TypeScriptClassTypeParametersChecker.INSTANCE};
        CHECKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\u0012\"\b\b\u0000\u0010\u0016*\u00020\u001a2\u0006\u0010\u001b\u001a\u0002H\u00162\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fR\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$Companion;", "", "<init>", "()V", "CHECKERS", "", "Lcom/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker;", "getCHECKERS$annotations", "getCHECKERS", "()Ljava/util/List;", "MAX_DEPTH", "", "findOwnOrParentConstructor", "Lcom/intellij/lang/javascript/psi/JSFunction;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "depth", "isParentClassContext", "", "element", "Lcom/intellij/psi/PsiElement;", "getRealElement", "T", "psiElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "processWithStatic", "Lcom/intellij/lang/javascript/psi/resolve/processors/JSResolveProcessor;", "processor", "newStatic", "action", "Ljava/util/function/Supplier;", "(Lcom/intellij/lang/javascript/psi/resolve/processors/JSResolveProcessor;ZLjava/util/function/Supplier;)Z", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final List<JSAccessibilityChecker> getCHECKERS() {
            return CHECKERS;
        }

        @JvmStatic
        protected static /* synthetic */ void getCHECKERS$annotations() {
        }

        private final JSFunction findOwnOrParentConstructor(JSClass jsClass, int depth) {
            JSFunction constructor = JSResolveUtil.getClassConstructor(jsClass);
            if (constructor != null || depth >= 10) {
                return constructor;
            }
            JSClass[] jSClassArray = jsClass.getSuperClasses();
            Intrinsics.checkNotNullExpressionValue((Object)jSClassArray, (String)"getSuperClasses(...)");
            for (JSClass cl : jSClassArray) {
                Intrinsics.checkNotNull((Object)cl);
                JSFunction jSFunction = constructor = this.findOwnOrParentConstructor(cl, depth + 1);
                if (jSFunction == null) continue;
                return jSFunction;
            }
            return null;
        }

        public final boolean isParentClassContext(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement parent = JSResolveUtil.findParent(element);
            return parent instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
        }

        @NotNull
        public final <T extends PsiElement> T getRealElement(@NotNull T psiElement) {
            Intrinsics.checkNotNullParameter(psiElement, (String)"psiElement");
            if (IntentionPreviewUtils.isPreviewElement(psiElement)) {
                return psiElement;
            }
            PsiElement realElement = CompletionUtilCoreImpl.getOriginalElement(psiElement);
            Object object = realElement;
            if (object == null) {
                object = psiElement;
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Supplier<Boolean> action) {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (!(processor instanceof JSResolveProcessorEx)) {
                Boolean bl = action.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                return bl;
            }
            boolean oldValue = ((JSResolveProcessorEx)processor).isProcessStatics();
            ((JSResolveProcessorEx)processor).setProcessStatics(newStatic);
            try {
                Boolean bl = action.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                ((JSResolveProcessorEx)processor).setProcessStatics(oldValue);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

