/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.function;

import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u0014\u001a\u00020\u00012\u0016\u0010\u0015\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0004\u0012\u0006\b\u0001\u0012\u00020\u00040\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/psi/types/function/JSParameterTypeDecoratorDelegate;", "Lcom/intellij/lang/javascript/psi/JSParameterTypeDecorator;", "delegate", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSParameterTypeDecorator;Lcom/intellij/lang/javascript/psi/JSType;)V", "getDelegate", "()Lcom/intellij/lang/javascript/psi/JSParameterTypeDecorator;", "getJsType", "()Lcom/intellij/lang/javascript/psi/JSType;", "getName", "", "isRest", "", "isOptional", "getSimpleType", "getTypeDecorator", "isExplicitlyDeclared", "getInferredType", "copyTypeHierarchy", "childTransform", "Lcom/intellij/util/Function;", "intellij.javascript.psi.impl"})
public final class JSParameterTypeDecoratorDelegate
implements JSParameterTypeDecorator {
    @NotNull
    private final JSParameterTypeDecorator delegate;
    @Nullable
    private final JSType jsType;

    public JSParameterTypeDecoratorDelegate(@NotNull JSParameterTypeDecorator delegate, @Nullable JSType jsType) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.jsType = jsType;
    }

    @NotNull
    public final JSParameterTypeDecorator getDelegate() {
        return this.delegate;
    }

    @Nullable
    public final JSType getJsType() {
        return this.jsType;
    }

    @Override
    @Nullable
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isRest() {
        return this.delegate.isRest();
    }

    @Override
    public boolean isOptional() {
        return this.delegate.isOptional();
    }

    @Override
    @Nullable
    public JSType getSimpleType() {
        return this.jsType;
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        return this;
    }

    @Override
    public boolean isExplicitlyDeclared() {
        JSType jSType = this.jsType;
        return (jSType != null ? jSType.isSourceStrict() : false) || this.delegate.isExplicitlyDeclared();
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        JSType type = this.getSimpleType();
        return this.isOptional() ? JSTypeGuardUtil.wrapWithUndefined(type, null) : type;
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        Intrinsics.checkNotNullParameter(childTransform, (String)"childTransform");
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(this.jsType, childTransform);
        return Intrinsics.areEqual((Object)newType, (Object)this.jsType) ? (JSParameterTypeDecorator)this : (JSParameterTypeDecorator)new JSParameterTypeDecoratorDelegate(this.delegate, newType);
    }
}

