/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.codeFloatingToolbar.CodeFloatingToolbar;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractMethodIntentionAction
implements IntentionAction,
Iconable {
    @NotNull
    public String getText() {
        String string = JavaBundle.message((String)"intention.extract.method.text", (Object[])new Object[0]);
        if (string == null) {
            ExtractMethodIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ExtractMethodIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        CodeFloatingToolbar floatingToolbar;
        if (project == null) {
            ExtractMethodIntentionAction.$$$reportNull$$$0(2);
        }
        if ((floatingToolbar = CodeFloatingToolbar.getToolbar((Editor)editor)) != null && (floatingToolbar.isShown() || floatingToolbar.canBeShownAtCurrentSelection())) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment || !psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        SelectionModel model = editor.getSelectionModel();
        if (!model.hasSelection()) {
            return false;
        }
        PsiElement[] elements = ExtractMethodHandler.getElements(project, editor, psiFile);
        if (elements == null || elements.length == 0) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiClass.class) == null) {
            return false;
        }
        ExtractMethodProcessor processor = ExtractMethodHandler.getProcessor(project, elements, psiFile, false);
        if (processor == null) {
            return false;
        }
        try {
            return processor.prepare(null);
        }
        catch (PrepareFailedException e) {
            return false;
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            ExtractMethodIntentionAction.$$$reportNull$$$0(3);
        }
        new ExtractMethodHandler().invoke(project, editor, psiFile, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ExtractMethodIntentionAction.$$$reportNull$$$0(4);
        }
        return currentFile;
    }

    public Icon getIcon(int flags) {
        return ExperimentalUI.isNewUI() ? null : AllIcons.Actions.RefactoringBulb;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ExtractMethodIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ExtractMethodIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

