/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.newImpl.ExtractException;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodAnalyzerKt;
import com.intellij.refactoring.extractMethod.newImpl.MethodExtractor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractMethodRecommenderInspection
extends AbstractBaseJavaLocalInspectionTool {
    public int minLength = 500;
    public int maxParameters = 3;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"minLength", (String)JavaAnalysisBundle.message((String)"inspection.extract.method.option.min.length", (Object[])new Object[0]), (int)10, (int)10000), OptPane.number((String)"maxParameters", (String)JavaAnalysisBundle.message((String)"inspection.extract.method.option.max.parameters", (Object[])new Object[0]), (int)1, (int)10)});
        if (optPane == null) {
            ExtractMethodRecommenderInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExtractMethodRecommenderInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitCodeBlock(@NotNull PsiCodeBlock block) {
                int maxCount;
                if (block == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (block.getTextLength() < ExtractMethodRecommenderInspection.this.minLength) {
                    return;
                }
                PsiParameterListOwner container = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)block, PsiParameterListOwner.class);
                if (container == null) {
                    return;
                }
                PsiElement body = container.getBody();
                if (body == null) {
                    return;
                }
                Object[] statements = block.getStatements();
                BitSet declarations = 1.getDeclarations((PsiStatement[])statements);
                if (declarations.isEmpty()) {
                    return;
                }
                int maxLength = body.getTextLength() * 3 / 5;
                if (maxLength < ExtractMethodRecommenderInspection.this.minLength) {
                    return;
                }
                if (block == body) {
                    maxCount = statements.length - 1;
                    if (ArrayUtil.getLastElement((Object[])statements) instanceof PsiReturnStatement) {
                        --maxCount;
                    }
                } else {
                    maxCount = statements.length;
                }
                maxCount = Math.min(maxCount, 50);
                PsiElement fragment = ControlFlowUtil.findCodeFragment((PsiElement)block);
                for (int count = maxCount; count > 1; --count) {
                    for (int from = 0; from < statements.length - count; ++from) {
                        int length;
                        Object[] range;
                        int to = from + count;
                        int nextDeclaration = declarations.nextSetBit(from);
                        if (nextDeclaration == -1 || nextDeclaration >= to || ContainerUtil.exists((Object[])(range = (PsiStatement[])Arrays.copyOfRange(statements, from, to)), e -> e instanceof PsiSwitchLabelStatementBase) || (length = range[range.length - 1].getTextRange().getEndOffset() - range[0].getTextRange().getStartOffset()) < ExtractMethodRecommenderInspection.this.minLength || length > maxLength) continue;
                        try {
                            PsiReturnStatement ret;
                            Object nextStatement;
                            List inputVariables;
                            PsiTypeElement typeElement;
                            PsiVariable output;
                            PsiVariable[] variables;
                            ControlFlowWrapper wrapper = new ControlFlowWrapper(fragment, (PsiElement[])range);
                            if (!wrapper.prepareExitStatements((PsiElement[])range).isEmpty() || wrapper.isGenerateConditionalExit() || wrapper.isReturnPresentBetween() || (variables = wrapper.getOutputVariables(2)).length != 1 || SideEffectsVisitor.hasSideEffectOrSimilarUseOutside((PsiStatement[])range, output = variables[0]) || (typeElement = output.getTypeElement()) == null || typeElement.isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)output.getType(), (PsiElement)output) || (inputVariables = wrapper.getInputVariables(fragment, (PsiElement[])range, variables)).size() > ExtractMethodRecommenderInspection.this.maxParameters) continue;
                            ExtractMethodAnalyzerKt.findExtractOptions(Arrays.asList(range), false);
                            if (1.voidPrefix(fragment, (PsiStatement[])range, output) || !1.outputUsedInLastStatement((PsiStatement[])range, output)) continue;
                            wrapper.checkExitStatements((PsiElement[])range, fragment);
                            TextRange textRange = 1.getRange((PsiStatement[])range);
                            if (to < statements.length && (nextStatement = statements[to]) instanceof PsiReturnStatement && ExpressionUtils.isReferenceTo((PsiExpression)(ret = (PsiReturnStatement)nextStatement).getReturnValue(), (PsiVariable)output)) {
                                textRange = textRange.union(ret.getTextRangeInParent());
                            }
                            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                            ExtractMethodFix extractFix = new ExtractMethodFix(from, count, output, inputVariables);
                            fixes.add(extractFix);
                            if (inputVariables.size() > 1) {
                                fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)ExtractMethodRecommenderInspection.this, "maxParameters", JavaAnalysisBundle.message((String)"inspection.extract.method.dont.suggest.parameters", (Object[])new Object[]{inputVariables.size()}), inputVariables.size() - 1)));
                            }
                            if (length < 10000) {
                                fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)ExtractMethodRecommenderInspection.this, "minLength", JavaAnalysisBundle.message((String)"inspection.extract.method.dont.suggest.length", (Object[])new Object[0]), length + 1)));
                            }
                            int firstLineBreak = textRange.substring(block.getText()).indexOf(10);
                            Object anchor = block;
                            if (firstLineBreak > -1) {
                                textRange = TextRange.from((int)textRange.getStartOffset(), (int)firstLineBreak);
                                TextRange firstStatementRange = statements[from].getTextRangeInParent();
                                if (firstStatementRange.getStartOffset() == textRange.getStartOffset() && firstStatementRange.getEndOffset() >= textRange.getEndOffset()) {
                                    anchor = statements[from];
                                    extractFix.shouldUseParent();
                                    textRange = textRange.shiftLeft(textRange.getStartOffset());
                                }
                            }
                            holder.registerProblem((PsiElement)anchor, JavaAnalysisBundle.message((String)"inspection.extract.method.message", (Object[])new Object[]{output.getName()}), ProblemHighlightType.WEAK_WARNING, textRange, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                            return;
                        }
                        catch (ControlFlowWrapper.ExitStatementsNotSameException | PrepareFailedException | ExtractException throwable) {
                            // empty catch block
                        }
                    }
                }
            }

            private static boolean outputUsedInLastStatement(PsiStatement[] range, PsiVariable output) {
                int outDecl = Arrays.asList(range).indexOf(output.getParent());
                return outDecl >= range.length - 1 || VariableAccessUtils.variableIsUsed((PsiVariable)output, (PsiElement)range[range.length - 1]);
            }

            @NotNull
            private static BitSet getDeclarations(PsiStatement[] statements) {
                BitSet declarations = new BitSet();
                for (int i = 0; i < statements.length; ++i) {
                    PsiDeclarationStatement decl;
                    PsiStatement psiStatement = statements[i];
                    if (!(psiStatement instanceof PsiDeclarationStatement) || !(ArrayUtil.getFirstElement((Object[])(decl = (PsiDeclarationStatement)psiStatement).getDeclaredElements()) instanceof PsiLocalVariable)) continue;
                    declarations.set(i);
                }
                BitSet bitSet = declarations;
                if (bitSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bitSet;
            }

            private static boolean voidPrefix(@NotNull PsiElement fragment, @NotNull @NotNull PsiStatement @NotNull [] range, @NotNull PsiVariable output) throws PrepareFailedException {
                PsiElement psiElement;
                if (fragment == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (output == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (range == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((psiElement = output.getParent()) instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement statement = (PsiDeclarationStatement)psiElement;
                    int declarationIndex = Arrays.asList(range).indexOf(statement);
                    if (declarationIndex > 0) {
                        PsiStatement[] subRange = Arrays.copyOf(range, declarationIndex);
                        ControlFlowWrapper subWrapper = new ControlFlowWrapper(fragment, (PsiElement[])subRange);
                        subWrapper.prepareExitStatements((PsiElement[])subRange);
                        return subWrapper.getOutputVariables(1).length == 0;
                    }
                }
                return false;
            }

            @NotNull
            private static TextRange getRange(PsiStatement[] statements) {
                PsiStatement start = statements[0];
                int startOffset = start.getTextRangeInParent().getStartOffset();
                int endOffset = statements[statements.length - 1].getTextRangeInParent().getEndOffset();
                TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                if (textRange == null) {
                    1.$$$reportNull$$$0(5);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "block";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fragment";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDeclarations";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCodeBlock";
                        break;
                    }
                    case 1: 
                    case 5: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "voidPrefix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ExtractMethodFix
    implements LocalQuickFix {
        private final int myFrom;
        private final int myLength;
        private final String myOutputName;
        private final String myInputNames;
        private boolean shouldUseParent = false;

        private ExtractMethodFix(int from, int length, PsiVariable variable, List<PsiVariable> inputVariables) {
            this.myFrom = from;
            this.myLength = length;
            this.myOutputName = variable.getName();
            this.myInputNames = StreamEx.of(inputVariables).map(p -> p.getName()).joining((CharSequence)", ");
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"intention.extract.method.text", (Object[])new Object[0]);
            if (string == null) {
                ExtractMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiCodeBlock block;
            TextRange range;
            if (project == null) {
                ExtractMethodFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ExtractMethodFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getStartElement();
            if (this.shouldUseParent) {
                element = element.getParent();
            }
            if ((range = this.getRange(block = (PsiCodeBlock)ObjectUtils.tryCast((Object)element, PsiCodeBlock.class))) == null) {
                return;
            }
            new MethodExtractor().doExtract(block.getContainingFile(), range.shiftRight(block.getTextRange().getStartOffset()));
        }

        @NotNull
        public List<CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(Project project, ProblemDescriptor descriptor) {
            PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiCodeBlock.class);
            TextRange range = this.getRange(block);
            if (range == null) {
                List<CustomizableIntentionAction.RangeToHighlight> list = List.of();
                if (list == null) {
                    ExtractMethodFix.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<CustomizableIntentionAction.RangeToHighlight> list = List.of(new CustomizableIntentionAction.RangeToHighlight((PsiElement)block, range, EditorColors.SEARCH_RESULT_ATTRIBUTES));
            if (list == null) {
                ExtractMethodFix.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Contract(value="null -> null")
        @Nullable
        private TextRange getRange(@Nullable PsiCodeBlock block) {
            if (block == null) {
                return null;
            }
            PsiStatement[] statements = block.getStatements();
            if (statements.length < this.myFrom + this.myLength) {
                return null;
            }
            return statements[this.myFrom].getTextRangeInParent().union(statements[this.myFrom + this.myLength - 1].getTextRangeInParent());
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                ExtractMethodFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                ExtractMethodFix.$$$reportNull$$$0(6);
            }
            Object input = this.myInputNames.isEmpty() ? JavaAnalysisBundle.message((String)"inspection.extract.method.nothing", (Object[])new Object[0]) : "<b>(" + this.myInputNames + ")</b>";
            return new IntentionPreviewInfo.Html(JavaAnalysisBundle.message((String)"inspection.extract.method.preview.html", (Object[])new Object[]{this.myLength, input, this.myOutputName}));
        }

        private void shouldUseParent() {
            this.shouldUseParent = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$ExtractMethodFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$ExtractMethodFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangesToHighlight";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    record ArgumentContext(String methodName, int parameterIndex) implements VarUseContext
    {
    }

    record QualifierContext(@NotNull String name) implements VarUseContext
    {
        @NotNull
        private final String name;

        QualifierContext(@NotNull String name) {
            if (name == null) {
                QualifierContext.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                QualifierContext.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$QualifierContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$QualifierContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static enum Contexts implements VarUseContext
    {
        WRITING,
        CONDITION,
        SETTER,
        ADDER;

    }

    static sealed interface VarUseContext
    permits Contexts, QualifierContext, ArgumentContext {
        @Nullable
        public static VarUseContext from(@NotNull PsiReferenceExpression ref) {
            block10: {
                block9: {
                    PsiElement psiElement;
                    String name;
                    if (ref == null) {
                        VarUseContext.$$$reportNull$$$0(0);
                    }
                    if (PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
                        return Contexts.WRITING;
                    }
                    PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)ref);
                    if (call != null && (name = call.getMethodExpression().getReferenceName()) != null) {
                        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)call.resolveMethod())) {
                            return Contexts.SETTER;
                        }
                        if (name.matches("add[A-Z].+")) {
                            return Contexts.ADDER;
                        }
                        return new QualifierContext(name);
                    }
                    PsiParameter parameter = MethodCallUtils.getParameterForArgument((PsiExpression)ref);
                    if (parameter != null && (psiElement = parameter.getDeclarationScope()) instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)psiElement;
                        return new ArgumentContext(method.getName(), method.getParameterList().getParameterIndex(parameter));
                    }
                    PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
                    if (parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement) break block9;
                    if (!(parent instanceof PsiPolyadicExpression)) break block10;
                    PsiPolyadicExpression poly = (PsiPolyadicExpression)parent;
                    if (!TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.OROR}).contains(poly.getOperationTokenType())) break block10;
                }
                return Contexts.CONDITION;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$VarUseContext", "from"));
        }
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiElement myStartElement;
        @NotNull
        private final PsiElement myEndElement;
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiElement myParent;
        boolean found;

        SideEffectsVisitor(@NotNull @NotNull PsiStatement @NotNull [] statements, @NotNull PsiVariable variable) {
            if (variable == null) {
                SideEffectsVisitor.$$$reportNull$$$0(0);
            }
            if (statements == null) {
                SideEffectsVisitor.$$$reportNull$$$0(1);
            }
            this.myStartElement = statements[0];
            this.myEndElement = statements[statements.length - 1];
            this.myVariable = variable;
            PsiElement parent = this.myStartElement.getParent();
            if (this.myEndElement.getParent() != parent) {
                throw new IllegalArgumentException();
            }
            this.myParent = parent;
        }

        private void addSideEffect() {
            this.found = true;
            this.stopWalking();
        }

        private boolean isInside(@Nullable PsiElement element) {
            if (element == null) {
                return false;
            }
            PsiElement cur = element;
            PsiElement next = cur.getParent();
            while (next != null) {
                if (cur == this.myStartElement || cur == this.myEndElement || next == this.myParent && cur.getTextRangeInParent().getStartOffset() >= this.myStartElement.getTextRangeInParent().getStartOffset() && cur.getTextRangeInParent().getEndOffset() <= this.myEndElement.getTextRangeInParent().getEndOffset()) {
                    return true;
                }
                cur = next;
                next = cur.getParent();
            }
            return false;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            PsiLocalVariable variable;
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(2);
            }
            if (!this.isInside((PsiElement)(variable = ExpressionUtils.resolveLocalVariable((PsiExpression)expression.getLExpression())))) {
                this.addSideEffect();
            }
            super.visitAssignmentExpression(expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(3);
            }
            MutationSignature signature = MutationSignature.fromCall((PsiCall)expression);
            if (!this.assumeOkMethod(expression) && (ExpressionUtils.isVoidContext((PsiExpression)expression) || signature == MutationSignature.unknown() || signature.performsIO() || signature.mutatedExpressions(expression).map(ExpressionUtils::resolveLocalVariable).anyMatch(var -> !this.isInside((PsiElement)var)))) {
                this.addSideEffect();
                return;
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(4);
            }
            if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
                this.addSideEffect();
                return;
            }
            super.visitNewExpression(expression);
        }

        private boolean assumeOkMethod(@NotNull PsiMethodCallExpression call) {
            PsiMethod method;
            if (call == null) {
                SideEffectsVisitor.$$$reportNull$$$0(5);
            }
            if ((method = call.resolveMethod()) == null) {
                return false;
            }
            if (method.getName().startsWith("assert") && ExpressionUtils.isVoidContext((PsiExpression)call)) {
                return false;
            }
            if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
                return true;
            }
            Object[] args = call.getArgumentList().getExpressions();
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression());
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method) && ExpressionUtils.resolveLocalVariable((PsiExpression)qualifier) == this.myVariable) {
                return true;
            }
            for (PsiExpression expr : (PsiExpression[])ArrayUtil.append((Object[])args, (Object)qualifier)) {
                PsiLambdaExpression lambda;
                if (expr == null) continue;
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable((PsiExpression)expr);
                if (expr instanceof PsiLambdaExpression && (lambda = (PsiLambdaExpression)expr).getBody() != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)lambda.getBody()) || this.isInside((PsiElement)variable) || ClassUtils.isImmutable((PsiType)expr.getType())) continue;
                return false;
            }
            return true;
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                SideEffectsVisitor.$$$reportNull$$$0(6);
            }
            if (variable != this.myVariable) {
                for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)this.myParent)) {
                    if (this.isInside((PsiElement)reference)) continue;
                    this.addSideEffect();
                    return;
                }
            }
            super.visitLocalVariable(variable);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(7);
            }
            if ((tokenType = expression.getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable((PsiExpression)expression.getOperand());
                if (!this.isInside((PsiElement)variable)) {
                    this.addSideEffect();
                }
                return;
            }
            super.visitUnaryExpression(expression);
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            PsiStatement exitedStatement;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(8);
            }
            if (!this.isInside((PsiElement)(exitedStatement = statement.findExitedStatement()))) {
                this.addSideEffect();
                return;
            }
            super.visitBreakStatement(statement);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SideEffectsVisitor.$$$reportNull$$$0(9);
            }
            if (ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope(this.myParent)).anyMatch(ref -> !this.isInside(ref.getElement()))) {
                this.addSideEffect();
            }
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            PsiStatement exitedStatement;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(10);
            }
            if (!this.isInside((PsiElement)(exitedStatement = statement.findContinuedStatement()))) {
                this.addSideEffect();
                return;
            }
            super.visitContinueStatement(statement);
        }

        public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
            PsiSwitchExpression enclosingExpression;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(11);
            }
            if (!this.isInside((PsiElement)(enclosingExpression = statement.findEnclosingExpression()))) {
                this.addSideEffect();
                return;
            }
            super.visitYieldStatement(statement);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(12);
            }
            this.addSideEffect();
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(13);
            }
        }

        static boolean hasSideEffectOrSimilarUseOutside(@NotNull @NotNull PsiStatement @NotNull [] statements, PsiVariable variable) {
            if (statements == null) {
                SideEffectsVisitor.$$$reportNull$$$0(14);
            }
            SideEffectsVisitor visitor2 = new SideEffectsVisitor(statements, variable);
            for (PsiStatement statement : statements) {
                statement.accept((PsiElementVisitor)visitor2);
                if (!visitor2.found) continue;
                return true;
            }
            return visitor2.hasSimilarUseOfOutputInsideAndOutside(variable);
        }

        private boolean hasSimilarUseOfOutputInsideAndOutside(PsiVariable variable) {
            HashSet<VarUseContext> insideContexts = new HashSet<VarUseContext>();
            HashSet outsideContexts = new HashSet();
            for (PsiReferenceExpression ref : VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)this.myParent)) {
                VarUseContext context = VarUseContext.from(ref);
                if (context == null) continue;
                (this.isInside((PsiElement)ref) ? insideContexts : outsideContexts).add(context);
            }
            return !Collections.disjoint(insideContexts, outsideContexts);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodRecommenderInspection$SideEffectsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assumeOkMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYieldStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasSideEffectOrSimilarUseOutside";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

