/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstructorDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(ConstructorDescriptor.class);
    private final PsiNewExpression myNewExpression;
    private final PsiClass myPsiClass;
    @Nullable
    private final PsiMethod myConstructor;

    private ConstructorDescriptor(@NotNull PsiNewExpression expression, @Nullable PsiMethod constructor, @NotNull PsiClass psiClass) {
        if (expression == null) {
            ConstructorDescriptor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ConstructorDescriptor.$$$reportNull$$$0(1);
        }
        this.myNewExpression = expression;
        this.myConstructor = constructor;
        this.myPsiClass = psiClass;
    }

    @Nullable
    public static ConstructorDescriptor createIfInaccessible(@NotNull PsiNewExpression expression) {
        PsiMethod constructor;
        if (expression == null) {
            ConstructorDescriptor.$$$reportNull$$$0(2);
        }
        if ((constructor = expression.resolveConstructor()) != null) {
            PsiClass containingClass = constructor.getContainingClass();
            if (containingClass != null && !PsiReflectionAccessUtil.isPublicMember((PsiMember)constructor)) {
                return new ConstructorDescriptor(expression, constructor, containingClass);
            }
        } else {
            PsiElement referent;
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            PsiElement psiElement = referent = classReference != null ? classReference.resolve() : null;
            if (referent instanceof PsiClass && !PsiReflectionAccessUtil.isAccessible((PsiClass)referent)) {
                return new ConstructorDescriptor(expression, null, (PsiClass)referent);
            }
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        String args;
        ReflectionAccessMethodBuilder methodBuilder;
        if (outerClass == null) {
            ConstructorDescriptor.$$$reportNull$$$0(3);
        }
        if (elementFactory == null) {
            ConstructorDescriptor.$$$reportNull$$$0(4);
        }
        if (callExpression == null) {
            ConstructorDescriptor.$$$reportNull$$$0(5);
        }
        String className = ClassUtil.getJVMClassName((PsiClass)this.myPsiClass);
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myNewExpression, this.myPsiClass);
        if (className == null || returnType == null) {
            LOG.warn("code is incomplete: " + String.valueOf(this.myNewExpression));
            return;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, ConstructorDescriptor.methodName(className));
        Object[] arrayDimensions = this.myNewExpression.getArrayDimensions();
        if (arrayDimensions.length > 0) {
            methodBuilder = new ReflectionAccessMethodBuilder(methodName);
            methodBuilder.newArray(className).setStatic(outerClass.hasModifierProperty("static")).addParameter("int...", "dimensions").setReturnType(returnType);
            args = StreamEx.of((Object[])arrayDimensions).map(x -> x.getText()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        } else {
            PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
            if (argumentList == null) {
                LOG.warn("code is incomplete: " + String.valueOf(this.myNewExpression));
                return;
            }
            methodBuilder = new ReflectionAccessMethodBuilder(methodName);
            methodBuilder.accessedConstructor(className).setStatic(outerClass.hasModifierProperty("static")).setReturnType(returnType);
            if (this.myConstructor != null) {
                methodBuilder.addParameters(this.myConstructor.getParameterList());
            }
            args = StreamEx.of((Object[])argumentList.getExpressions()).map(x -> x.getText()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        }
        PsiMethod newPsiMethod = methodBuilder.build(elementFactory, (PsiElement)outerClass);
        outerClass.add((PsiElement)newPsiMethod);
        String newCallExpression = newPsiMethod.getName() + args;
        this.myNewExpression.replace((PsiElement)elementFactory.createExpressionFromText(newCallExpression, (PsiElement)this.myNewExpression));
    }

    @NotNull
    private static String methodName(@NotNull String jvmClassName) {
        if (jvmClassName == null) {
            ConstructorDescriptor.$$$reportNull$$$0(6);
        }
        String name = StringUtil.getShortName((String)jvmClassName);
        String string = "new" + StringUtil.capitalize((String)name);
        if (string == null) {
            ConstructorDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIfInaccessible";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "methodName";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

