/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BackpointerUsageVisitor
extends JavaRecursiveElementWalkingVisitor {
    private PsiMember myCause;
    private final List<? extends PsiField> myFields;
    private final List<? extends PsiClass> myInnerClasses;
    private final List<? extends PsiMethod> myMethods;
    private final PsiClass mySourceClass;
    private final boolean myCheckThisExpression;

    BackpointerUsageVisitor(List<? extends PsiField> fields, List<? extends PsiClass> innerClasses, List<? extends PsiMethod> methods, PsiClass sourceClass) {
        this(fields, innerClasses, methods, sourceClass, true);
    }

    BackpointerUsageVisitor(List<? extends PsiField> fields, List<? extends PsiClass> innerClasses, List<? extends PsiMethod> methods, PsiClass sourceClass, boolean checkThisExpression) {
        this.myFields = fields;
        this.myInnerClasses = innerClasses;
        this.myMethods = methods;
        this.mySourceClass = sourceClass;
        this.myCheckThisExpression = checkThisExpression;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            BackpointerUsageVisitor.$$$reportNull$$$0(0);
        }
        if (this.myCause != null) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            BackpointerUsageVisitor.$$$reportNull$$$0(1);
        }
        if (this.myCause != null) {
            return;
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        PsiElement referent = expression.resolve();
        if (!(referent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)referent;
        if (this.myFields.contains(field) || this.myInnerClasses.contains(field.getContainingClass())) {
            return;
        }
        if (field.hasModifierProperty("static")) {
            return;
        }
        if (qualifier == null || this.myCheckThisExpression && qualifier instanceof PsiQualifiedExpression) {
            this.myCause = field;
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            BackpointerUsageVisitor.$$$reportNull$$$0(2);
        }
        if (this.myCause != null) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (this.myMethods.contains(method) || this.myInnerClasses.contains(containingClass)) {
            return;
        }
        if (method.hasModifierProperty("static")) {
            return;
        }
        if (!containingClass.equals((Object)this.mySourceClass)) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || this.myCheckThisExpression && qualifier instanceof PsiQualifiedExpression) {
            this.myCause = method;
        }
    }

    public boolean isBackpointerRequired() {
        return this.myCause != null;
    }

    public PsiMember getCause() {
        return this.myCause;
    }

    public boolean backpointerRequired() {
        for (PsiMethod psiMethod : this.myMethods) {
            psiMethod.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        for (PsiField psiField : this.myFields) {
            psiField.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        for (PsiClass psiClass : this.myInnerClasses) {
            psiClass.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractclass/BackpointerUsageVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

