/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineConstantFieldHandler;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.CommonJavaInlineUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineConstantFieldProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineConstantFieldProcessor.class);
    private PsiField myField;
    private final PsiElement myRefExpr;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInCommentsAndStrings;
    private final boolean mySearchForTextOccurrences;
    private final boolean myDeleteDeclaration;
    private Map<Language, InlineHandler.Inliner> myInliners;

    public InlineConstantFieldProcessor(PsiField field, Project project, PsiElement ref, boolean isInlineThisOnly) {
        this(field, project, ref, isInlineThisOnly, false, false, true);
    }

    public InlineConstantFieldProcessor(PsiField field, Project project, PsiElement ref, boolean isInlineThisOnly, boolean searchInCommentsAndStrings, boolean searchForTextOccurrences, boolean isDeleteDeclaration) {
        super(project);
        this.myField = field;
        this.myRefExpr = ref;
        this.myInlineThisOnly = isInlineThisOnly;
        this.mySearchInCommentsAndStrings = searchInCommentsAndStrings;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
        this.myDeleteDeclaration = isDeleteDeclaration;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(0);
        }
        return new InlineViewDescriptor((PsiElement)this.myField);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(1);
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo info : usages) {
            if (!(info instanceof NonCodeUsageInfo)) continue;
            return true;
        }
        return false;
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiElement element;
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myRefExpr)};
            if (usageInfoArray == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }
        List<UsageInfo> usages = Collections.synchronizedList(new ArrayList());
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)this.myRefactoringScope, (boolean)false).asIterable()) {
            element = ref.getElement();
            UsageInfo info = new UsageInfo(element);
            if (element instanceof PsiDocMethodOrFieldRef) {
                info = new UsageFromJavaDoc(element);
            }
            usages.add(info);
        }
        if (this.mySearchInCommentsAndStrings || this.mySearchForTextOccurrences) {
            NonCodeUsageInfoFactory nonCodeUsageFactory = new NonCodeUsageInfoFactory((PsiElement)this.myField, this.myField.getName()){

                public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)InlineConstantFieldProcessor.this.myField, (PsiElement)usage, (boolean)false)) {
                        return null;
                    }
                    return super.createUsageInfo(usage, startOffset, endOffset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/inline/InlineConstantFieldProcessor$1", "createUsageInfo"));
                }
            };
            if (this.mySearchInCommentsAndStrings) {
                String stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myField, (SearchScope)this.myRefactoringScope, (String)stringToSearch, usages, (UsageInfoFactory)nonCodeUsageFactory);
            }
            if (this.mySearchForTextOccurrences && (element = this.myRefactoringScope) instanceof GlobalSearchScope) {
                GlobalSearchScope scope = (GlobalSearchScope)element;
                String stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
                TextOccurrencesUtil.addTextOccurrences((PsiElement)this.myField, (String)stringToSearch, (GlobalSearchScope)scope, usages, (UsageInfoFactory)nonCodeUsageFactory);
            }
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof PsiField);
        this.myField = (PsiField)elements[0];
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiExpression initializer;
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((initializer = InlineConstantFieldHandler.getInitializer(this.myField)) != null);
        HashSet assignments = new HashSet();
        for (UsageInfo info : usages) {
            PsiElement element;
            if (info instanceof UsageFromJavaDoc || info instanceof NonCodeUsageInfo || (element = info.getElement()) == null) continue;
            try {
                if (element instanceof PsiExpression) {
                    PsiExpression expression = (PsiExpression)element;
                    this.inlineExpressionUsage(expression, initializer, assignments);
                    continue;
                }
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                if (importStaticStatement != null) {
                    importStaticStatement.delete();
                    continue;
                }
                GenericInlineHandler.inlineReference((UsageInfo)info, (PsiElement)this.myField, this.myInliners);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        for (PsiAssignmentExpression assignment : assignments) {
            assignment.delete();
        }
        if (!this.myInlineThisOnly && this.myDeleteDeclaration && this.myField.isWritable()) {
            try {
                this.myField.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        if (this.myDeleteDeclaration) {
            data.addElement((PsiElement)this.myField);
        }
        return data;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.field";
    }

    private void inlineExpressionUsage(PsiExpression expr, PsiExpression initializer1, Set<? super PsiAssignmentExpression> assignments) {
        PsiExpression psiExpression;
        if (expr instanceof PsiLiteralExpression) {
            return;
        }
        if (this.myField.isWritable()) {
            this.myField.normalizeDeclaration();
        }
        if (InlineConstantFieldProcessor.isAccessedForWriting(expr)) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiAssignmentExpression.class);
            if (assignmentExpression != null) {
                assignments.add((PsiAssignmentExpression)assignmentExpression);
            }
            return;
        }
        if (expr instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expr;
            psiExpression = ref.getQualifierExpression();
        } else {
            psiExpression = null;
        }
        PsiExpression thisAccessExpr = psiExpression;
        PsiExpression invalidationCopy = thisAccessExpr != null ? (PsiExpression)thisAccessExpr.copy() : null;
        CommonJavaInlineUtil.getInstance().inlineVariable((PsiVariable)this.myField, initializer1, (PsiJavaCodeReferenceElement)expr, invalidationCopy);
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"inline.field.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myField)});
        if (string == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiMethod[] constructors;
        if (refUsages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(7);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        PsiExpression initializer = InlineConstantFieldHandler.getInitializer(this.myField);
        LOG.assertTrue(initializer != null);
        initializer.accept((PsiElementVisitor)collector);
        HashSet<PsiMember> referencedWithVisibility = collector.myReferencedMembers;
        if (!this.myField.hasInitializer() && (constructors = Objects.requireNonNull(this.myField.getContainingClass()).getConstructors()).length == 1) {
            boolean dependsOnContext;
            Ref reference = new Ref();
            boolean bl = dependsOnContext = !PsiTreeUtil.processElements((PsiElement)initializer, element -> {
                PsiJavaCodeReferenceElement ref;
                PsiElement resolve;
                if (element instanceof PsiJavaCodeReferenceElement && (resolve = (ref = (PsiJavaCodeReferenceElement)element).resolve()) != null && PsiTreeUtil.isAncestor((PsiElement)constructors[0], (PsiElement)resolve, (boolean)true) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolve, (boolean)true)) {
                    reference.set((Object)resolve);
                    return false;
                }
                return true;
            });
            if (dependsOnContext) {
                for (UsageInfo usageInfo : usagesIn) {
                    PsiElement element2 = usageInfo.getElement();
                    if (element2 == null || PsiTreeUtil.isAncestor((PsiElement)constructors[0], (PsiElement)element2, (boolean)true)) continue;
                    conflicts.putValue((Object)element2, (Object)JavaRefactoringBundle.message((String)"inline.field.initializer.is.not.accessible", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)((PsiElement)reference.get()), (boolean)false), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element2), (boolean)true)}));
                }
            }
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myField.getProject()).getResolveHelper();
        for (UsageInfo info : usagesIn) {
            PsiElement element3 = info.getElement();
            if (element3 instanceof PsiExpression) {
                PsiExpression exp = (PsiExpression)element3;
                if ((!this.myField.hasModifierProperty("final") || this.myInlineThisOnly) && InlineConstantFieldProcessor.isAccessedForWriting(exp)) {
                    String message = JavaRefactoringBundle.message((String)"0.is.used.for.writing.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myField, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element3), (boolean)true)});
                    conflicts.putValue((Object)element3, (Object)message);
                }
            }
            for (PsiMember member : referencedWithVisibility) {
                if (resolveHelper.isAccessible(member, element3, null)) continue;
                String message = JavaRefactoringBundle.message((String)"0.will.not.be.accessible.from.1.after.inlining", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element3), (boolean)true)});
                conflicts.putValue((Object)member, (Object)message);
            }
        }
        this.myInliners = GenericInlineHandler.initInliners((PsiElement)this.myField, (UsageInfo[])usagesIn, (InlineHandler.Settings)new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return InlineConstantFieldProcessor.this.myInlineThisOnly;
            }
        }, (MultiMap)conflicts, (Language[])new Language[]{JavaLanguage.INSTANCE});
        if (!this.myInlineThisOnly) {
            for (UsageInfo info : usagesIn) {
                PsiElement element4 = info.getElement();
                if (element4 instanceof PsiDocMethodOrFieldRef && !PsiTreeUtil.isAncestor((PsiElement)this.myField, (PsiElement)element4, (boolean)false)) {
                    conflicts.putValue((Object)element4, (Object)JavaRefactoringBundle.message((String)"inline.field.used.in.javadoc", (Object[])new Object[0]));
                }
                if (!(element4 instanceof PsiLiteralExpression)) continue;
                if (!ContainerUtil.or((Object[])element4.getReferences(), JavaLangClassMemberReference.class::isInstance)) continue;
                conflicts.putValue((Object)element4, (Object)JavaRefactoringBundle.message((String)"inline.field.used.in.reflection", (Object[])new Object[0]));
            }
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    private static boolean isAccessedForWriting(PsiExpression expr) {
        while (expr.getParent() instanceof PsiArrayAccessExpression) {
            expr = (PsiExpression)expr.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr);
    }

    protected Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor) {
        if (this.myInlineThisOnly) {
            return Collections.emptySet();
        }
        return super.computeUnloadedModulesFromUseScope(descriptor);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(8);
        }
        if (this.myInlineThisOnly) {
            List<PsiElement> list = Collections.singletonList(this.myRefExpr);
            if (list == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (!this.myField.isWritable()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(10);
            }
            return list;
        }
        Collection collection = super.getElementsToWrite(descriptor);
        if (collection == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineConstantFieldProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineConstantFieldProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static final class UsageFromJavaDoc
    extends UsageInfo {
        private UsageFromJavaDoc(@NotNull PsiElement element) {
            if (element == null) {
                UsageFromJavaDoc.$$$reportNull$$$0(0);
            }
            super(element, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/inline/InlineConstantFieldProcessor$UsageFromJavaDoc", "<init>"));
        }
    }
}

